/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javadoc.AnnotationDescImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import java.lang.reflect.Modifier;
import java.text.CollationKey;

public abstract class ProgramElementDocImpl
extends DocImpl
implements ProgramElementDoc {
    private final Symbol sym;
    JCTree tree = null;
    Position.LineMap lineMap = null;
    private int modifiers = -1;

    protected ProgramElementDocImpl(DocEnv docEnv, Symbol symbol, TreePath treePath) {
        super(docEnv, treePath);
        this.sym = symbol;
        if (treePath != null) {
            this.tree = (JCTree)treePath.getLeaf();
            this.lineMap = ((JCTree.JCCompilationUnit)treePath.getCompilationUnit()).lineMap;
        }
    }

    @Override
    void setTreePath(TreePath treePath) {
        super.setTreePath(treePath);
        this.tree = (JCTree)treePath.getLeaf();
        this.lineMap = ((JCTree.JCCompilationUnit)treePath.getCompilationUnit()).lineMap;
    }

    protected abstract Symbol.ClassSymbol getContainingClass();

    protected abstract long getFlags();

    protected int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = DocEnv.translateModifiers(this.getFlags());
        }
        return this.modifiers;
    }

    @Override
    public ClassDoc containingClass() {
        if (this.getContainingClass() == null) {
            return null;
        }
        return this.env.getClassDoc(this.getContainingClass());
    }

    @Override
    public PackageDoc containingPackage() {
        return this.env.getPackageDoc(this.getContainingClass().packge());
    }

    @Override
    public int modifierSpecifier() {
        int n = this.getModifiers();
        if (this.isMethod() && this.containingClass().isInterface()) {
            return n & 0xFFFFFBFF;
        }
        return n;
    }

    @Override
    public String modifiers() {
        int n = this.getModifiers();
        if (this.isAnnotationTypeElement() || this.isMethod() && this.containingClass().isInterface()) {
            return Modifier.toString(n & 0xFFFFFBFF);
        }
        return Modifier.toString(n);
    }

    @Override
    public AnnotationDesc[] annotations() {
        AnnotationDesc[] annotationDescArray = new AnnotationDesc[this.sym.getRawAttributes().length()];
        int n = 0;
        for (Attribute.Compound compound : this.sym.getRawAttributes()) {
            annotationDescArray[n++] = new AnnotationDescImpl(this.env, compound);
        }
        return annotationDescArray;
    }

    @Override
    public boolean isPublic() {
        int n = this.getModifiers();
        return Modifier.isPublic(n);
    }

    @Override
    public boolean isProtected() {
        int n = this.getModifiers();
        return Modifier.isProtected(n);
    }

    @Override
    public boolean isPrivate() {
        int n = this.getModifiers();
        return Modifier.isPrivate(n);
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public boolean isStatic() {
        int n = this.getModifiers();
        return Modifier.isStatic(n);
    }

    @Override
    public boolean isFinal() {
        int n = this.getModifiers();
        return Modifier.isFinal(n);
    }

    @Override
    CollationKey generateKey() {
        String string = this.name();
        return this.env.doclocale.collator.getCollationKey(string);
    }
}

