/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.MemberDocImpl;
import com.sun.tools.javadoc.SourcePositionImpl;
import com.sun.tools.javadoc.TypeMaker;
import java.lang.reflect.Modifier;

public class FieldDocImpl
extends MemberDocImpl
implements FieldDoc {
    protected final Symbol.VarSymbol sym;
    private String name;
    private String qualifiedName;

    public FieldDocImpl(DocEnv docEnv, Symbol.VarSymbol varSymbol, TreePath treePath) {
        super(docEnv, varSymbol, treePath);
        this.sym = varSymbol;
    }

    public FieldDocImpl(DocEnv docEnv, Symbol.VarSymbol varSymbol) {
        this(docEnv, varSymbol, null);
    }

    @Override
    protected long getFlags() {
        return this.sym.flags();
    }

    @Override
    protected Symbol.ClassSymbol getContainingClass() {
        return this.sym.enclClass();
    }

    @Override
    public Type type() {
        return TypeMaker.getType(this.env, this.sym.type, false);
    }

    @Override
    public Object constantValue() {
        Object object = this.sym.getConstValue();
        if (object != null && this.sym.type.hasTag(TypeTag.BOOLEAN)) {
            object = (Integer)object != 0;
        }
        return object;
    }

    @Override
    public String constantValueExpression() {
        return FieldDocImpl.constantValueExpression(this.constantValue());
    }

    static String constantValueExpression(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return FieldDocImpl.sourceForm(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return FieldDocImpl.sourceForm((Byte)object);
        }
        if (object instanceof String) {
            return FieldDocImpl.sourceForm((String)object);
        }
        if (object instanceof Double) {
            return FieldDocImpl.sourceForm((Double)object, 'd');
        }
        if (object instanceof Float) {
            return FieldDocImpl.sourceForm(((Float)object).doubleValue(), 'f');
        }
        if (object instanceof Long) {
            return object + "L";
        }
        return object.toString();
    }

    private static String sourceForm(double d, char c) {
        if (Double.isNaN(d)) {
            return "0" + c + "/0" + c;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "1" + c + "/0" + c;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-1" + c + "/0" + c;
        }
        return d + (c == 'f' || c == 'F' ? "" + c : "");
    }

    private static String sourceForm(char c) {
        StringBuilder stringBuilder = new StringBuilder(8);
        stringBuilder.append('\'');
        FieldDocImpl.sourceChar(c, stringBuilder);
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private static String sourceForm(byte by) {
        return "0x" + Integer.toString(by & 0xFF, 16);
    }

    private static String sourceForm(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            FieldDocImpl.sourceChar(c, stringBuilder);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private static void sourceChar(char c, StringBuilder stringBuilder) {
        switch (c) {
            case '\b': {
                stringBuilder.append("\\b");
                return;
            }
            case '\t': {
                stringBuilder.append("\\t");
                return;
            }
            case '\n': {
                stringBuilder.append("\\n");
                return;
            }
            case '\f': {
                stringBuilder.append("\\f");
                return;
            }
            case '\r': {
                stringBuilder.append("\\r");
                return;
            }
            case '\"': {
                stringBuilder.append("\\\"");
                return;
            }
            case '\'': {
                stringBuilder.append("\\'");
                return;
            }
            case '\\': {
                stringBuilder.append("\\\\");
                return;
            }
        }
        if (FieldDocImpl.isPrintableAscii(c)) {
            stringBuilder.append(c);
            return;
        }
        FieldDocImpl.unicodeEscape(c, stringBuilder);
    }

    private static void unicodeEscape(char c, StringBuilder stringBuilder) {
        stringBuilder.append("\\u");
        stringBuilder.append("0123456789abcdef".charAt(0xF & c >> 12));
        stringBuilder.append("0123456789abcdef".charAt(0xF & c >> 8));
        stringBuilder.append("0123456789abcdef".charAt(0xF & c >> 4));
        stringBuilder.append("0123456789abcdef".charAt(0xF & c >> 0));
    }

    private static boolean isPrintableAscii(char c) {
        return c >= ' ' && c <= '~';
    }

    @Override
    public boolean isIncluded() {
        return this.containingClass().isIncluded() && this.env.shouldDocument(this.sym);
    }

    @Override
    public boolean isField() {
        return !this.isEnumConstant();
    }

    @Override
    public boolean isEnumConstant() {
        return (this.getFlags() & 0x4000L) != 0L && !this.env.legacyDoclet;
    }

    @Override
    public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    @Override
    public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return (this.getFlags() & 0x1000L) != 0L;
    }

    @Override
    public SerialFieldTag[] serialFieldTags() {
        return this.comment().serialFieldTags();
    }

    @Override
    public String name() {
        if (this.name == null) {
            this.name = this.sym.name.toString();
        }
        return this.name;
    }

    @Override
    public String qualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.sym.enclClass().getQualifiedName() + "." + this.name();
        }
        return this.qualifiedName;
    }

    @Override
    public SourcePosition position() {
        if (this.sym.enclClass().sourcefile == null) {
            return null;
        }
        return SourcePositionImpl.make(this.sym.enclClass().sourcefile, this.tree == null ? 0 : this.tree.pos, this.lineMap);
    }
}

