/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javadoc.AnnotationTypeDocImpl;
import com.sun.tools.javadoc.AnnotationValueImpl;
import com.sun.tools.javadoc.DocEnv;

public class AnnotationDescImpl
implements AnnotationDesc {
    private final DocEnv env;
    private final Attribute.Compound annotation;

    AnnotationDescImpl(DocEnv docEnv, Attribute.Compound compound) {
        this.env = docEnv;
        this.annotation = compound;
    }

    @Override
    public AnnotationTypeDoc annotationType() {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.annotation.type.tsym;
        if (this.annotation.type.isErroneous()) {
            this.env.warning(null, "javadoc.class_not_found", this.annotation.type.toString());
            return new AnnotationTypeDocImpl(this.env, classSymbol);
        }
        return (AnnotationTypeDoc)((Object)this.env.getClassDoc(classSymbol));
    }

    @Override
    public AnnotationDesc.ElementValuePair[] elementValues() {
        List<Pair<Symbol.MethodSymbol, Attribute>> list = this.annotation.values;
        AnnotationDesc.ElementValuePair[] elementValuePairArray = new AnnotationDesc.ElementValuePair[list.length()];
        int n = 0;
        for (Pair<Symbol.MethodSymbol, Attribute> pair : list) {
            elementValuePairArray[n++] = new ElementValuePairImpl(this.env, (Symbol.MethodSymbol)pair.fst, (Attribute)pair.snd);
        }
        return elementValuePairArray;
    }

    @Override
    public boolean isSynthesized() {
        return this.annotation.isSynthesized();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("@");
        stringBuilder.append(this.annotation.type.tsym);
        AnnotationDesc.ElementValuePair[] elementValuePairArray = this.elementValues();
        if (elementValuePairArray.length > 0) {
            stringBuilder.append('(');
            boolean bl = true;
            for (AnnotationDesc.ElementValuePair elementValuePair : elementValuePairArray) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                String string = elementValuePair.element().name();
                if (elementValuePairArray.length == 1 && string.equals("value")) {
                    stringBuilder.append(elementValuePair.value());
                    continue;
                }
                stringBuilder.append(elementValuePair);
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static class ElementValuePairImpl
    implements AnnotationDesc.ElementValuePair {
        private final DocEnv env;
        private final Symbol.MethodSymbol meth;
        private final Attribute value;

        ElementValuePairImpl(DocEnv docEnv, Symbol.MethodSymbol methodSymbol, Attribute attribute) {
            this.env = docEnv;
            this.meth = methodSymbol;
            this.value = attribute;
        }

        @Override
        public AnnotationTypeElementDoc element() {
            return this.env.getAnnotationTypeElementDoc(this.meth);
        }

        @Override
        public AnnotationValue value() {
            return new AnnotationValueImpl(this.env, this.value);
        }

        public String toString() {
            return this.meth.name + "=" + this.value();
        }
    }
}

