/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.ElementScanner8;
import javax.lang.model.util.Types;

public class JavacRoundEnvironment
implements RoundEnvironment {
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ProcessingEnvironment processingEnv;
    private final Set<? extends Element> rootElements;
    private static final String NOT_AN_ANNOTATION_TYPE = "The argument does not represent an annotation type: ";

    JavacRoundEnvironment(boolean bl, boolean bl2, Set<? extends Element> set, ProcessingEnvironment processingEnvironment) {
        this.processingOver = bl;
        this.errorRaised = bl2;
        this.rootElements = set;
        this.processingEnv = processingEnvironment;
    }

    public String toString() {
        return String.format("[errorRaised=%b, rootElements=%s, processingOver=%b]", this.errorRaised, this.rootElements, this.processingOver);
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    @Override
    public Set<? extends Element> getRootElements() {
        return this.rootElements;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement typeElement) {
        Set set = Collections.emptySet();
        Types types = this.processingEnv.getTypeUtils();
        if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + typeElement);
        }
        TypeMirror typeMirror = typeElement.asType();
        if (!(typeMirror instanceof DeclaredType)) {
            throw new AssertionError((Object)("Bad implementation type for " + typeMirror));
        }
        DeclaredType declaredType = (DeclaredType)typeElement.asType();
        AnnotationSetScanner annotationSetScanner = new AnnotationSetScanner(set, types);
        for (Element element : this.rootElements) {
            set = (Set)((ElementScanner6)annotationSetScanner).scan(element, declaredType);
        }
        return set;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> clazz) {
        if (!clazz.isAnnotation()) {
            throw new IllegalArgumentException(NOT_AN_ANNOTATION_TYPE + clazz);
        }
        String string = clazz.getCanonicalName();
        if (string == null) {
            return Collections.emptySet();
        }
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(string);
        if (typeElement == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(typeElement);
    }

    private class AnnotationSetScanner
    extends ElementScanner8<Set<Element>, DeclaredType> {
        Set<Element> annotatedElements;
        Types typeUtil;

        AnnotationSetScanner(Set<Element> set, Types types) {
            super(set);
            this.annotatedElements = new LinkedHashSet<Element>();
            this.typeUtil = types;
        }

        @Override
        public Set<Element> visitType(TypeElement typeElement, DeclaredType declaredType) {
            this.scan(typeElement.getTypeParameters(), declaredType);
            return (Set)this.scan(typeElement.getEnclosedElements(), declaredType);
        }

        @Override
        public Set<Element> visitExecutable(ExecutableElement executableElement, DeclaredType declaredType) {
            this.scan(executableElement.getTypeParameters(), declaredType);
            return (Set)this.scan(executableElement.getEnclosedElements(), declaredType);
        }

        @Override
        public Set<Element> scan(Element element, DeclaredType declaredType) {
            List<? extends AnnotationMirror> list = JavacRoundEnvironment.this.processingEnv.getElementUtils().getAllAnnotationMirrors(element);
            for (AnnotationMirror annotationMirror : list) {
                if (!this.typeUtil.isSameType(annotationMirror.getAnnotationType(), declaredType)) continue;
                this.annotatedElements.add(element);
            }
            element.accept(this, declaredType);
            return this.annotatedElements;
        }
    }
}

