/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Iterator;

public class TypeAnnotationPosition {
    public TargetType type = TargetType.UNKNOWN;
    public List<TypePathEntry> location = List.nil();
    public int pos = -1;
    public boolean isValidOffset = false;
    public int offset = -1;
    public int[] lvarOffset = null;
    public int[] lvarLength = null;
    public int[] lvarIndex = null;
    public int bound_index = Integer.MIN_VALUE;
    public int parameter_index = Integer.MIN_VALUE;
    public int type_index = Integer.MIN_VALUE;
    public int exception_index = Integer.MIN_VALUE;
    public JCTree.JCLambda onLambda = null;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append((Object)this.type);
        switch (this.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                stringBuilder.append(", offset = ");
                stringBuilder.append(this.offset);
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                if (this.lvarOffset == null) {
                    stringBuilder.append(", lvarOffset is null!");
                    break;
                }
                stringBuilder.append(", {");
                for (int i = 0; i < this.lvarOffset.length; ++i) {
                    if (i != 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append("start_pc = ");
                    stringBuilder.append(this.lvarOffset[i]);
                    stringBuilder.append(", length = ");
                    stringBuilder.append(this.lvarLength[i]);
                    stringBuilder.append(", index = ");
                    stringBuilder.append(this.lvarIndex[i]);
                }
                stringBuilder.append("}");
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                stringBuilder.append(", param_index = ");
                stringBuilder.append(this.parameter_index);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                stringBuilder.append(", param_index = ");
                stringBuilder.append(this.parameter_index);
                stringBuilder.append(", bound_index = ");
                stringBuilder.append(this.bound_index);
                break;
            }
            case CLASS_EXTENDS: {
                stringBuilder.append(", type_index = ");
                stringBuilder.append(this.type_index);
                break;
            }
            case THROWS: {
                stringBuilder.append(", type_index = ");
                stringBuilder.append(this.type_index);
                break;
            }
            case EXCEPTION_PARAMETER: {
                stringBuilder.append(", exception_index = ");
                stringBuilder.append(this.exception_index);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                stringBuilder.append(", param_index = ");
                stringBuilder.append(this.parameter_index);
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                stringBuilder.append(", offset = ");
                stringBuilder.append(this.offset);
                stringBuilder.append(", type_index = ");
                stringBuilder.append(this.type_index);
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                stringBuilder.append(", position UNKNOWN!");
                break;
            }
            default: {
                Assert.error("Unknown target type: " + (Object)((Object)this.type));
            }
        }
        if (!this.location.isEmpty()) {
            stringBuilder.append(", location = (");
            stringBuilder.append(this.location);
            stringBuilder.append(")");
        }
        stringBuilder.append(", pos = ");
        stringBuilder.append(this.pos);
        if (this.onLambda != null) {
            stringBuilder.append(", onLambda hash = ");
            stringBuilder.append(this.onLambda.hashCode());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public boolean emitToClassfile() {
        return !this.type.isLocal() || this.isValidOffset;
    }

    public boolean matchesPos(int n) {
        return this.pos == n;
    }

    public void updatePosOffset(int n) {
        this.offset = n;
        this.lvarOffset = new int[]{n};
        this.isValidOffset = true;
    }

    public static List<TypePathEntry> getTypePathFromBinary(java.util.List<Integer> list) {
        ListBuffer<TypePathEntry> listBuffer = new ListBuffer<TypePathEntry>();
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            Assert.check(iterator.hasNext(), "Could not decode type path: " + list);
            Integer n2 = iterator.next();
            listBuffer = listBuffer.append(TypePathEntry.fromBinary(n, n2));
        }
        return listBuffer.toList();
    }

    public static List<Integer> getBinaryFromTypePath(java.util.List<TypePathEntry> list) {
        ListBuffer<Object> listBuffer = new ListBuffer<Integer>();
        for (TypePathEntry typePathEntry : list) {
            listBuffer = listBuffer.append(typePathEntry.tag.tag);
            listBuffer = listBuffer.append(typePathEntry.arg);
        }
        return listBuffer.toList();
    }

    public static class TypePathEntry {
        public static final int bytesPerEntry = 2;
        public final TypePathEntryKind tag;
        public final int arg;
        public static final TypePathEntry ARRAY = new TypePathEntry(TypePathEntryKind.ARRAY);
        public static final TypePathEntry INNER_TYPE = new TypePathEntry(TypePathEntryKind.INNER_TYPE);
        public static final TypePathEntry WILDCARD = new TypePathEntry(TypePathEntryKind.WILDCARD);

        private TypePathEntry(TypePathEntryKind typePathEntryKind) {
            Assert.check(typePathEntryKind == TypePathEntryKind.ARRAY || typePathEntryKind == TypePathEntryKind.INNER_TYPE || typePathEntryKind == TypePathEntryKind.WILDCARD, "Invalid TypePathEntryKind: " + (Object)((Object)typePathEntryKind));
            this.tag = typePathEntryKind;
            this.arg = 0;
        }

        public TypePathEntry(TypePathEntryKind typePathEntryKind, int n) {
            Assert.check(typePathEntryKind == TypePathEntryKind.TYPE_ARGUMENT, "Invalid TypePathEntryKind: " + (Object)((Object)typePathEntryKind));
            this.tag = typePathEntryKind;
            this.arg = n;
        }

        public static TypePathEntry fromBinary(int n, int n2) {
            Assert.check(n2 == 0 || n == TypePathEntryKind.TYPE_ARGUMENT.tag, "Invalid TypePathEntry tag/arg: " + n + "/" + n2);
            switch (n) {
                case 0: {
                    return ARRAY;
                }
                case 1: {
                    return INNER_TYPE;
                }
                case 2: {
                    return WILDCARD;
                }
                case 3: {
                    return new TypePathEntry(TypePathEntryKind.TYPE_ARGUMENT, n2);
                }
            }
            Assert.error("Invalid TypePathEntryKind tag: " + n);
            return null;
        }

        public String toString() {
            return this.tag.toString() + (this.tag == TypePathEntryKind.TYPE_ARGUMENT ? "(" + this.arg + ")" : "");
        }

        public boolean equals(Object object) {
            if (!(object instanceof TypePathEntry)) {
                return false;
            }
            TypePathEntry typePathEntry = (TypePathEntry)object;
            return this.tag == typePathEntry.tag && this.arg == typePathEntry.arg;
        }

        public int hashCode() {
            return this.tag.hashCode() * 17 + this.arg;
        }
    }

    public static enum TypePathEntryKind {
        ARRAY(0),
        INNER_TYPE(1),
        WILDCARD(2),
        TYPE_ARGUMENT(3);

        public final int tag;

        private TypePathEntryKind(int n2) {
            this.tag = n2;
        }
    }
}

