/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.doctree.DocTree;
import com.sun.source.tree.Tree;
import com.sun.tools.doclint.Env;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.tools.Diagnostic;

public class Messages {
    private final Options options;
    private final Stats stats;
    ResourceBundle bundle;
    Env env;

    Messages(Env env) {
        this.env = env;
        String string = this.getClass().getPackage().getName() + ".resources.doclint";
        this.bundle = ResourceBundle.getBundle(string, Locale.ENGLISH);
        this.stats = new Stats(this.bundle);
        this.options = new Options(this.stats);
    }

    void error(Group group, DocTree docTree, String string, Object ... objectArray) {
        this.report(group, Diagnostic.Kind.ERROR, docTree, string, objectArray);
    }

    void warning(Group group, DocTree docTree, String string, Object ... objectArray) {
        this.report(group, Diagnostic.Kind.WARNING, docTree, string, objectArray);
    }

    void setOptions(String string) {
        this.options.setOptions(string);
    }

    void setStatsEnabled(boolean bl) {
        this.stats.setEnabled(bl);
    }

    void reportStats(PrintWriter printWriter) {
        this.stats.report(printWriter);
    }

    protected void report(Group group, Diagnostic.Kind kind, DocTree docTree, String string, Object ... objectArray) {
        if (this.options.isEnabled(group, this.env.currAccess)) {
            String string2 = string == null ? (String)objectArray[0] : this.localize(string, objectArray);
            this.env.trees.printMessage(kind, string2, docTree, this.env.currDocComment, this.env.currPath.getCompilationUnit());
            this.stats.record(group, kind, string);
        }
    }

    protected void report(Group group, Diagnostic.Kind kind, Tree tree, String string, Object ... objectArray) {
        if (this.options.isEnabled(group, this.env.currAccess)) {
            String string2 = this.localize(string, objectArray);
            this.env.trees.printMessage(kind, string2, tree, this.env.currPath.getCompilationUnit());
            this.stats.record(group, kind, string);
        }
    }

    String localize(String string, Object ... objectArray) {
        String string2 = this.bundle.getString(string);
        if (string2 == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("message file broken: code=").append(string);
            if (objectArray.length > 0) {
                stringBuilder.append(" arguments={0}");
                for (int i = 1; i < objectArray.length; ++i) {
                    stringBuilder.append(", {").append(i).append("}");
                }
            }
            string2 = stringBuilder.toString();
        }
        return MessageFormat.format(string2, objectArray);
    }

    static class Stats {
        public static final String OPT = "stats";
        public static final String NO_CODE = "";
        final ResourceBundle bundle;
        int[] groupCounts;
        int[] dkindCounts;
        Map<String, Integer> codeCounts;

        Stats(ResourceBundle resourceBundle) {
            this.bundle = resourceBundle;
        }

        void setEnabled(boolean bl) {
            if (bl) {
                this.groupCounts = new int[Group.values().length];
                this.dkindCounts = new int[Diagnostic.Kind.values().length];
                this.codeCounts = new HashMap<String, Integer>();
            } else {
                this.groupCounts = null;
                this.dkindCounts = null;
                this.codeCounts = null;
            }
        }

        void record(Group group, Diagnostic.Kind kind, String string) {
            Integer n;
            if (this.codeCounts == null) {
                return;
            }
            int n2 = group.ordinal();
            this.groupCounts[n2] = this.groupCounts[n2] + 1;
            int n3 = kind.ordinal();
            this.dkindCounts[n3] = this.dkindCounts[n3] + 1;
            if (string == null) {
                string = NO_CODE;
            }
            this.codeCounts.put(string, (n = this.codeCounts.get(string)) == null ? 1 : n + 1);
        }

        void report(PrintWriter printWriter) {
            if (this.codeCounts == null) {
                return;
            }
            printWriter.println("By group...");
            Table table = new Table();
            for (Group group : Group.values()) {
                table.put(group.optName(), this.groupCounts[group.ordinal()]);
            }
            table.print(printWriter);
            printWriter.println();
            printWriter.println("By diagnostic kind...");
            Table table2 = new Table();
            for (Diagnostic.Kind object2 : Diagnostic.Kind.values()) {
                table2.put(object2.toString().toLowerCase(), this.dkindCounts[object2.ordinal()]);
            }
            table2.print(printWriter);
            printWriter.println();
            printWriter.println("By message kind...");
            Table table3 = new Table();
            for (Map.Entry<String, Integer> entry : this.codeCounts.entrySet()) {
                String string;
                String string2 = entry.getKey();
                try {
                    string = string2.equals(NO_CODE) ? "OTHER" : this.bundle.getString(string2);
                }
                catch (MissingResourceException missingResourceException) {
                    string = string2;
                }
                table3.put(string, entry.getValue());
            }
            table3.print(printWriter);
        }

        private static class Table {
            private static final Comparator<Integer> DECREASING = new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return n2.compareTo(n);
                }
            };
            private final TreeMap<Integer, Set<String>> map = new TreeMap(DECREASING);

            private Table() {
            }

            void put(String string, int n) {
                if (n == 0) {
                    return;
                }
                Set<String> set = this.map.get(n);
                if (set == null) {
                    set = new TreeSet<String>();
                    this.map.put(n, set);
                }
                set.add(string);
            }

            void print(PrintWriter printWriter) {
                for (Map.Entry<Integer, Set<String>> entry : this.map.entrySet()) {
                    int n = entry.getKey();
                    Set<String> set = entry.getValue();
                    for (String string : set) {
                        printWriter.println(String.format("%6d: %s", n, string));
                    }
                }
            }
        }
    }

    static class Options {
        Map<String, Env.AccessKind> map = new HashMap<String, Env.AccessKind>();
        private final Stats stats;
        private static final String ALL = "all";

        static boolean isValidOptions(String string) {
            for (String string2 : string.split(",")) {
                if (Options.isValidOption(string2.trim().toLowerCase())) continue;
                return false;
            }
            return true;
        }

        private static boolean isValidOption(String string) {
            if (string.equals("none") || string.equals("stats")) {
                return true;
            }
            int n = string.startsWith("-") ? 1 : 0;
            int n2 = string.indexOf("/");
            String string2 = string.substring(n, n2 != -1 ? n2 : string.length());
            return (n == 0 && string2.equals(ALL) || Group.accepts(string2)) && (n2 == -1 || Env.AccessKind.accepts(string.substring(n2 + 1)));
        }

        Options(Stats stats) {
            this.stats = stats;
        }

        boolean isEnabled(Group group, Env.AccessKind accessKind) {
            Env.AccessKind accessKind2;
            if (this.map.isEmpty()) {
                this.map.put(ALL, Env.AccessKind.PROTECTED);
            }
            if ((accessKind2 = this.map.get(group.optName())) != null && accessKind.compareTo(accessKind2) >= 0) {
                return true;
            }
            accessKind2 = this.map.get(ALL);
            return accessKind2 != null && accessKind.compareTo(accessKind2) >= 0 && ((accessKind2 = this.map.get(group.notOptName())) == null || accessKind.compareTo(accessKind2) > 0);
        }

        void setOptions(String string) {
            if (string == null) {
                this.setOption(ALL, Env.AccessKind.PRIVATE);
            } else {
                for (String string2 : string.split(",")) {
                    this.setOption(string2.trim().toLowerCase());
                }
            }
        }

        private void setOption(String string) throws IllegalArgumentException {
            if (string.equals("stats")) {
                this.stats.setEnabled(true);
                return;
            }
            int n = string.indexOf("/");
            if (n > 0) {
                Env.AccessKind accessKind = Env.AccessKind.valueOf(string.substring(n + 1).toUpperCase());
                this.setOption(string.substring(0, n), accessKind);
            } else {
                this.setOption(string, null);
            }
        }

        private void setOption(String string, Env.AccessKind accessKind) {
            this.map.put(string, accessKind != null ? accessKind : (string.startsWith("-") ? Env.AccessKind.PUBLIC : Env.AccessKind.PRIVATE));
        }
    }

    public static enum Group {
        ACCESSIBILITY,
        HTML,
        MISSING,
        SYNTAX,
        REFERENCE;


        String optName() {
            return this.name().toLowerCase();
        }

        String notOptName() {
            return "-" + this.optName();
        }

        static boolean accepts(String string) {
            for (Group group : Group.values()) {
                if (!string.equals(group.optName())) continue;
                return true;
            }
            return false;
        }
    }
}

