/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.doclint.Messages;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class Env {
    final Messages messages = new Messages(this);
    int implicitHeaderLevel = 0;
    Set<String> customTags;
    DocTrees trees;
    Elements elements;
    Types types;
    TypeMirror java_lang_Error;
    TypeMirror java_lang_RuntimeException;
    TypeMirror java_lang_Throwable;
    TypeMirror java_lang_Void;
    TreePath currPath;
    Element currElement;
    DocCommentTree currDocComment;
    AccessKind currAccess;
    Set<? extends ExecutableElement> currOverriddenMethods;

    Env() {
    }

    void init(JavacTask javacTask) {
        this.init(DocTrees.instance(javacTask), javacTask.getElements(), javacTask.getTypes());
    }

    void init(DocTrees docTrees, Elements elements, Types types) {
        this.trees = docTrees;
        this.elements = elements;
        this.types = types;
        this.java_lang_Error = elements.getTypeElement("java.lang.Error").asType();
        this.java_lang_RuntimeException = elements.getTypeElement("java.lang.RuntimeException").asType();
        this.java_lang_Throwable = elements.getTypeElement("java.lang.Throwable").asType();
        this.java_lang_Void = elements.getTypeElement("java.lang.Void").asType();
    }

    void setImplicitHeaders(int n) {
        this.implicitHeaderLevel = n;
    }

    void setCustomTags(String string) {
        this.customTags = new LinkedHashSet<String>();
        for (String string2 : string.split(",")) {
            if (string2.isEmpty()) continue;
            this.customTags.add(string2);
        }
    }

    void setCurrent(TreePath treePath, DocCommentTree docCommentTree) {
        this.currPath = treePath;
        this.currDocComment = docCommentTree;
        this.currElement = this.trees.getElement(this.currPath);
        this.currOverriddenMethods = ((JavacTypes)this.types).getOverriddenMethods(this.currElement);
        AccessKind accessKind = AccessKind.PUBLIC;
        for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
            Element element = this.trees.getElement(treePath2);
            if (element == null || element.getKind() == ElementKind.PACKAGE) continue;
            accessKind = this.min(accessKind, AccessKind.of(element.getModifiers()));
        }
        this.currAccess = accessKind;
    }

    AccessKind getAccessKind() {
        return this.currAccess;
    }

    long getPos(TreePath treePath) {
        return ((JCTree)treePath.getLeaf()).pos;
    }

    long getStartPos(TreePath treePath) {
        DocSourcePositions docSourcePositions = this.trees.getSourcePositions();
        return docSourcePositions.getStartPosition(treePath.getCompilationUnit(), treePath.getLeaf());
    }

    private <T extends Comparable<T>> T min(T t, T t2) {
        return t == null ? t2 : (t2 == null ? t : (t.compareTo(t2) <= 0 ? t : t2));
    }

    public static enum AccessKind {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC;


        static boolean accepts(String string) {
            for (AccessKind accessKind : AccessKind.values()) {
                if (!string.equals(accessKind.name().toLowerCase())) continue;
                return true;
            }
            return false;
        }

        static AccessKind of(Set<Modifier> set) {
            if (set.contains((Object)Modifier.PUBLIC)) {
                return PUBLIC;
            }
            if (set.contains((Object)Modifier.PROTECTED)) {
                return PROTECTED;
            }
            if (set.contains((Object)Modifier.PRIVATE)) {
                return PRIVATE;
            }
            return PACKAGE;
        }
    }
}

