/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocFileFactory;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.javac.nio.PathFileManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.tools.DocumentationTool;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class PathDocFileFactory
extends DocFileFactory {
    private final PathFileManager fileManager;
    private final Path destDir;

    public PathDocFileFactory(Configuration configuration) {
        super(configuration);
        this.fileManager = (PathFileManager)configuration.getFileManager();
        if (!configuration.destDirName.isEmpty() || !this.fileManager.hasLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT)) {
            try {
                String string = configuration.destDirName.isEmpty() ? "." : configuration.destDirName;
                Path path = this.fileManager.getDefaultFileSystem().getPath(string, new String[0]);
                this.fileManager.setLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT, Arrays.asList(path));
            }
            catch (IOException iOException) {
                throw new DocletAbortException(iOException);
            }
        }
        this.destDir = this.fileManager.getLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT).iterator().next();
    }

    @Override
    public DocFile createFileForDirectory(String string) {
        return new StandardDocFile(this.fileManager.getDefaultFileSystem().getPath(string, new String[0]));
    }

    @Override
    public DocFile createFileForInput(String string) {
        return new StandardDocFile(this.fileManager.getDefaultFileSystem().getPath(string, new String[0]));
    }

    @Override
    public DocFile createFileForOutput(DocPath docPath) {
        return new StandardDocFile(DocumentationTool.Location.DOCUMENTATION_OUTPUT, docPath);
    }

    @Override
    Iterable<DocFile> list(JavaFileManager.Location location, DocPath docPath) {
        if (location != StandardLocation.SOURCE_PATH) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<DocFile> linkedHashSet = new LinkedHashSet<DocFile>();
        if (this.fileManager.hasLocation(location)) {
            for (Path path : this.fileManager.getLocation(location)) {
                Path path2;
                if (!Files.isDirectory(path, new LinkOption[0]) || !Files.exists(path2 = path.resolve(docPath.getPath()), new LinkOption[0])) continue;
                linkedHashSet.add(new StandardDocFile(path2));
            }
        }
        return linkedHashSet;
    }

    class StandardDocFile
    extends DocFile {
        private Path file;

        private StandardDocFile(Path path) {
            super(PathDocFileFactory.this.configuration);
            this.file = path;
        }

        private StandardDocFile(JavaFileManager.Location location, DocPath docPath) {
            super(PathDocFileFactory.this.configuration, location, docPath);
            this.file = PathDocFileFactory.this.destDir.resolve(docPath.getPath());
        }

        @Override
        public InputStream openInputStream() throws IOException {
            JavaFileObject javaFileObject = this.getJavaFileObjectForInput(this.file);
            return new BufferedInputStream(javaFileObject.openInputStream());
        }

        @Override
        public OutputStream openOutputStream() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream outputStream = this.getFileObjectForOutput(this.path).openOutputStream();
            return new BufferedOutputStream(outputStream);
        }

        @Override
        public Writer openWriter() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream outputStream = this.getFileObjectForOutput(this.path).openOutputStream();
            if (PathDocFileFactory.this.configuration.docencoding == null) {
                return new BufferedWriter(new OutputStreamWriter(outputStream));
            }
            return new BufferedWriter(new OutputStreamWriter(outputStream, PathDocFileFactory.this.configuration.docencoding));
        }

        @Override
        public boolean canRead() {
            return Files.isReadable(this.file);
        }

        @Override
        public boolean canWrite() {
            return Files.isWritable(this.file);
        }

        @Override
        public boolean exists() {
            return Files.exists(this.file, new LinkOption[0]);
        }

        @Override
        public String getName() {
            return this.file.getFileName().toString();
        }

        @Override
        public String getPath() {
            return this.file.toString();
        }

        @Override
        public boolean isAbsolute() {
            return this.file.isAbsolute();
        }

        @Override
        public boolean isDirectory() {
            return Files.isDirectory(this.file, new LinkOption[0]);
        }

        @Override
        public boolean isFile() {
            return Files.isRegularFile(this.file, new LinkOption[0]);
        }

        @Override
        public boolean isSameFile(DocFile docFile) {
            if (!(docFile instanceof StandardDocFile)) {
                return false;
            }
            try {
                return Files.isSameFile(this.file, ((StandardDocFile)docFile).file);
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public Iterable<DocFile> list() throws IOException {
            ArrayList<DocFile> arrayList = new ArrayList<DocFile>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.file);){
                for (Path path : directoryStream) {
                    arrayList.add(new StandardDocFile(path));
                }
            }
            return arrayList;
        }

        @Override
        public boolean mkdirs() {
            try {
                Files.createDirectories(this.file, new FileAttribute[0]);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public DocFile resolve(DocPath docPath) {
            return this.resolve(docPath.getPath());
        }

        @Override
        public DocFile resolve(String string) {
            if (this.location == null && this.path == null) {
                return new StandardDocFile(this.file.resolve(string));
            }
            return new StandardDocFile(this.location, this.path.resolve(string));
        }

        @Override
        public DocFile resolveAgainst(JavaFileManager.Location location) {
            if (location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalArgumentException();
            }
            return new StandardDocFile(PathDocFileFactory.this.destDir.resolve(this.file));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("PathDocFile[");
            if (this.location != null) {
                stringBuilder.append("locn:").append(this.location).append(",");
            }
            if (this.path != null) {
                stringBuilder.append("path:").append(this.path.getPath()).append(",");
            }
            stringBuilder.append("file:").append(this.file);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        private JavaFileObject getJavaFileObjectForInput(Path path) {
            return PathDocFileFactory.this.fileManager.getJavaFileObjects(path).iterator().next();
        }

        private FileObject getFileObjectForOutput(DocPath docPath) throws IOException {
            String string = docPath.getPath();
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '/') {
                    n = i;
                    continue;
                }
                if (i == n + 1 && !Character.isJavaIdentifierStart(c) || !Character.isJavaIdentifierPart(c)) break;
            }
            String string2 = n == -1 ? "" : string.substring(0, n);
            String string3 = string.substring(n + 1);
            return PathDocFileFactory.this.fileManager.getFileForOutput(this.location, string2, string3, null);
        }
    }
}

