/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class PackageListWriter
extends PrintWriter {
    private Configuration configuration;

    public PackageListWriter(Configuration configuration) throws IOException {
        super(DocFile.createFileForOutput(configuration, DocPaths.PACKAGE_LIST).openWriter());
        this.configuration = configuration;
    }

    public static void generate(Configuration configuration) {
        try {
            PackageListWriter packageListWriter = new PackageListWriter(configuration);
            packageListWriter.generatePackageListFile(configuration.root);
            packageListWriter.close();
        }
        catch (IOException iOException) {
            configuration.message.error("doclet.exception_encountered", iOException.toString(), DocPaths.PACKAGE_LIST);
            throw new DocletAbortException(iOException);
        }
    }

    protected void generatePackageListFile(RootDoc rootDoc) {
        int n;
        PackageDoc[] packageDocArray = this.configuration.packages;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < packageDocArray.length; ++n) {
            if (this.configuration.nodeprecated && Util.isDeprecated(packageDocArray[n])) continue;
            arrayList.add(packageDocArray[n].name());
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            this.println((String)arrayList.get(n));
        }
    }
}

