/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.taglets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.taglets.CodeTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.InheritDocTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.LegacyTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.LiteralTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.PropertyGetterTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.PropertySetterTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ReturnTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.SeeTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.SimpleTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ThrowsTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ValueTaglet;
import com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;

public class TagletManager {
    public static final char SIMPLE_TAGLET_OPT_SEPARATOR = ':';
    public static final String ALT_SIMPLE_TAGLET_OPT_SEPARATOR = "-";
    private LinkedHashMap<String, Taglet> customTags;
    private Taglet[] packageTags;
    private Taglet[] typeTags;
    private Taglet[] fieldTags;
    private Taglet[] constructorTags;
    private Taglet[] methodTags;
    private Taglet[] overviewTags;
    private Taglet[] inlineTags;
    private Taglet[] serializedFormTags;
    private MessageRetriever message;
    private Set<String> standardTags;
    private Set<String> standardTagsLowercase;
    private Set<String> overridenStandardTags = new HashSet<String>();
    private Set<String> potentiallyConflictingTags = new HashSet<String>();
    private Set<String> unseenCustomTags;
    private boolean nosince;
    private boolean showversion;
    private boolean showauthor;
    private boolean javafx;

    public TagletManager(boolean bl, boolean bl2, boolean bl3, boolean bl4, MessageRetriever messageRetriever) {
        this.standardTags = new HashSet<String>();
        this.standardTagsLowercase = new HashSet<String>();
        this.unseenCustomTags = new HashSet<String>();
        this.customTags = new LinkedHashMap();
        this.nosince = bl;
        this.showversion = bl2;
        this.showauthor = bl3;
        this.javafx = bl4;
        this.message = messageRetriever;
        this.initStandardTaglets();
        this.initStandardTagsLowercase();
    }

    public void addCustomTag(Taglet taglet) {
        if (taglet != null) {
            String string = taglet.getName();
            if (this.customTags.containsKey(string)) {
                this.customTags.remove(string);
            }
            this.customTags.put(string, taglet);
            this.checkTagName(string);
        }
    }

    public Set<String> getCustomTagNames() {
        return this.customTags.keySet();
    }

    public void addCustomTag(String string, JavaFileManager javaFileManager, String string2) {
        try {
            Object object;
            ClassLoader classLoader;
            Class<?> clazz = null;
            String string3 = null;
            if (javaFileManager != null && javaFileManager.hasLocation(DocumentationTool.Location.TAGLET_PATH)) {
                classLoader = javaFileManager.getClassLoader(DocumentationTool.Location.TAGLET_PATH);
            } else {
                string3 = this.appendPath(System.getProperty("env.class.path"), string3);
                string3 = this.appendPath(System.getProperty("java.class.path"), string3);
                string3 = this.appendPath(string2, string3);
                classLoader = new URLClassLoader(this.pathToURLs(string3));
            }
            clazz = classLoader.loadClass(string);
            Method method = clazz.getMethod("register", Map.class);
            Object[] objectArray = this.customTags.values().toArray();
            Taglet taglet = objectArray != null && objectArray.length > 0 ? (Taglet)objectArray[objectArray.length - 1] : null;
            method.invoke(null, this.customTags);
            objectArray = this.customTags.values().toArray();
            Object object2 = object = objectArray != null && objectArray.length > 0 ? objectArray[objectArray.length - 1] : null;
            if (taglet != object) {
                this.message.notice("doclet.Notice_taglet_registered", string);
                if (object != null) {
                    this.checkTaglet(object);
                }
            }
        }
        catch (Exception exception) {
            this.message.error("doclet.Error_taglet_not_registered", exception.getClass().getName(), string);
        }
    }

    private String appendPath(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2 == null ? "." : string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + File.pathSeparator + string2;
    }

    private URL[] pathToURLs(String string) {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.isEmpty()) continue;
            try {
                linkedHashSet.add(new File(string2).getAbsoluteFile().toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.message.error("doclet.MalformedURL", string2);
            }
        }
        return linkedHashSet.toArray(new URL[linkedHashSet.size()]);
    }

    public void addNewSimpleCustomTag(String string, String string2, String string3) {
        if (string == null || string3 == null) {
            return;
        }
        Taglet taglet = this.customTags.get(string);
        string3 = string3.toLowerCase();
        if (taglet == null || string2 != null) {
            this.customTags.remove(string);
            this.customTags.put(string, new SimpleTaglet(string, string2, string3));
            if (string3 != null && string3.indexOf(120) == -1) {
                this.checkTagName(string);
            }
        } else {
            this.customTags.remove(string);
            this.customTags.put(string, taglet);
        }
    }

    private void checkTagName(String string) {
        if (this.standardTags.contains(string)) {
            this.overridenStandardTags.add(string);
        } else {
            if (string.indexOf(46) == -1) {
                this.potentiallyConflictingTags.add(string);
            }
            this.unseenCustomTags.add(string);
        }
    }

    private void checkTaglet(Object object) {
        if (object instanceof Taglet) {
            this.checkTagName(((Taglet)object).getName());
        } else if (object instanceof com.sun.tools.doclets.Taglet) {
            com.sun.tools.doclets.Taglet taglet = (com.sun.tools.doclets.Taglet)object;
            this.customTags.remove(taglet.getName());
            this.customTags.put(taglet.getName(), new LegacyTaglet(taglet));
            this.checkTagName(taglet.getName());
        } else {
            throw new IllegalArgumentException("Given object is not a taglet.");
        }
    }

    public void seenCustomTag(String string) {
        this.unseenCustomTags.remove(string);
    }

    public void checkTags(Doc doc, Tag[] tagArray, boolean bl) {
        if (tagArray == null) {
            return;
        }
        for (int i = 0; i < tagArray.length; ++i) {
            String string = tagArray[i].name();
            if (string.length() > 0 && string.charAt(0) == '@') {
                string = string.substring(1, string.length());
            }
            if (!this.standardTags.contains(string) && !this.customTags.containsKey(string)) {
                if (this.standardTagsLowercase.contains(string.toLowerCase())) {
                    this.message.warning(tagArray[i].position(), "doclet.UnknownTagLowercase", tagArray[i].name());
                    continue;
                }
                this.message.warning(tagArray[i].position(), "doclet.UnknownTag", tagArray[i].name());
                continue;
            }
            Taglet taglet = this.customTags.get(string);
            if (taglet == null) continue;
            if (bl && !taglet.isInlineTag()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "inline");
            }
            if (doc instanceof RootDoc && !taglet.inOverview()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "overview");
                continue;
            }
            if (doc instanceof PackageDoc && !taglet.inPackage()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "package");
                continue;
            }
            if (doc instanceof ClassDoc && !taglet.inType()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "class");
                continue;
            }
            if (doc instanceof ConstructorDoc && !taglet.inConstructor()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "constructor");
                continue;
            }
            if (doc instanceof FieldDoc && !taglet.inField()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "field");
                continue;
            }
            if (!(doc instanceof MethodDoc) || taglet.inMethod()) continue;
            this.printTagMisuseWarn(taglet, tagArray[i], "method");
        }
    }

    private void printTagMisuseWarn(Taglet taglet, Tag tag, String string) {
        String[] stringArray;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (taglet.inOverview()) {
            linkedHashSet.add("overview");
        }
        if (taglet.inPackage()) {
            linkedHashSet.add("package");
        }
        if (taglet.inType()) {
            linkedHashSet.add("class/interface");
        }
        if (taglet.inConstructor()) {
            linkedHashSet.add("constructor");
        }
        if (taglet.inField()) {
            linkedHashSet.add("field");
        }
        if (taglet.inMethod()) {
            linkedHashSet.add("method");
        }
        if (taglet.isInlineTag()) {
            linkedHashSet.add("inline text");
        }
        if ((stringArray = linkedHashSet.toArray(new String[0])) == null || stringArray.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        this.message.warning(tag.position(), "doclet.tag_misuse", "@" + taglet.getName(), string, stringBuilder.toString());
    }

    public Taglet[] getPackageCustomTaglets() {
        if (this.packageTags == null) {
            this.initCustomTagletArrays();
        }
        return this.packageTags;
    }

    public Taglet[] getTypeCustomTaglets() {
        if (this.typeTags == null) {
            this.initCustomTagletArrays();
        }
        return this.typeTags;
    }

    public Taglet[] getInlineCustomTaglets() {
        if (this.inlineTags == null) {
            this.initCustomTagletArrays();
        }
        return this.inlineTags;
    }

    public Taglet[] getFieldCustomTaglets() {
        if (this.fieldTags == null) {
            this.initCustomTagletArrays();
        }
        return this.fieldTags;
    }

    public Taglet[] getSerializedFormTaglets() {
        if (this.serializedFormTags == null) {
            this.initCustomTagletArrays();
        }
        return this.serializedFormTags;
    }

    public Taglet[] getCustomTaglets(Doc doc) {
        if (doc instanceof ConstructorDoc) {
            return this.getConstructorCustomTaglets();
        }
        if (doc instanceof MethodDoc) {
            return this.getMethodCustomTaglets();
        }
        if (doc instanceof FieldDoc) {
            return this.getFieldCustomTaglets();
        }
        if (doc instanceof ClassDoc) {
            return this.getTypeCustomTaglets();
        }
        if (doc instanceof PackageDoc) {
            return this.getPackageCustomTaglets();
        }
        if (doc instanceof RootDoc) {
            return this.getOverviewCustomTaglets();
        }
        return null;
    }

    public Taglet[] getConstructorCustomTaglets() {
        if (this.constructorTags == null) {
            this.initCustomTagletArrays();
        }
        return this.constructorTags;
    }

    public Taglet[] getMethodCustomTaglets() {
        if (this.methodTags == null) {
            this.initCustomTagletArrays();
        }
        return this.methodTags;
    }

    public Taglet[] getOverviewCustomTaglets() {
        if (this.overviewTags == null) {
            this.initCustomTagletArrays();
        }
        return this.overviewTags;
    }

    private void initCustomTagletArrays() {
        Iterator<Taglet> iterator = this.customTags.values().iterator();
        ArrayList<Taglet> arrayList = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList2 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList3 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList4 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList5 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList6 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList7 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList8 = new ArrayList<Taglet>();
        while (iterator.hasNext()) {
            Taglet taglet = iterator.next();
            if (taglet.inPackage() && !taglet.isInlineTag()) {
                arrayList.add(taglet);
            }
            if (taglet.inType() && !taglet.isInlineTag()) {
                arrayList2.add(taglet);
            }
            if (taglet.inField() && !taglet.isInlineTag()) {
                arrayList3.add(taglet);
            }
            if (taglet.inConstructor() && !taglet.isInlineTag()) {
                arrayList4.add(taglet);
            }
            if (taglet.inMethod() && !taglet.isInlineTag()) {
                arrayList5.add(taglet);
            }
            if (taglet.isInlineTag()) {
                arrayList6.add(taglet);
            }
            if (!taglet.inOverview() || taglet.isInlineTag()) continue;
            arrayList7.add(taglet);
        }
        this.packageTags = arrayList.toArray(new Taglet[0]);
        this.typeTags = arrayList2.toArray(new Taglet[0]);
        this.fieldTags = arrayList3.toArray(new Taglet[0]);
        this.constructorTags = arrayList4.toArray(new Taglet[0]);
        this.methodTags = arrayList5.toArray(new Taglet[0]);
        this.overviewTags = arrayList7.toArray(new Taglet[0]);
        this.inlineTags = arrayList6.toArray(new Taglet[0]);
        arrayList8.add(this.customTags.get("serialData"));
        arrayList8.add(this.customTags.get("throws"));
        if (!this.nosince) {
            arrayList8.add(this.customTags.get("since"));
        }
        arrayList8.add(this.customTags.get("see"));
        this.serializedFormTags = arrayList8.toArray(new Taglet[0]);
    }

    private void initStandardTaglets() {
        if (this.javafx) {
            this.initJavaFXTaglets();
        }
        this.addStandardTaglet(new ParamTaglet());
        this.addStandardTaglet(new ReturnTaglet());
        this.addStandardTaglet(new ThrowsTaglet());
        this.addStandardTaglet(new SimpleTaglet("exception", null, "mc"));
        this.addStandardTaglet(!this.nosince, new SimpleTaglet("since", this.message.getText("doclet.Since", new Object[0]), "a"));
        this.addStandardTaglet(this.showversion, new SimpleTaglet("version", this.message.getText("doclet.Version", new Object[0]), "pto"));
        this.addStandardTaglet(this.showauthor, new SimpleTaglet("author", this.message.getText("doclet.Author", new Object[0]), "pto"));
        this.addStandardTaglet(new SimpleTaglet("serialData", this.message.getText("doclet.SerialData", new Object[0]), "x"));
        SimpleTaglet simpleTaglet = new SimpleTaglet("factory", this.message.getText("doclet.Factory", new Object[0]), "m");
        this.customTags.put(simpleTaglet.getName(), simpleTaglet);
        this.addStandardTaglet(new SeeTaglet());
        this.addStandardTaglet(new DocRootTaglet());
        this.addStandardTaglet(new InheritDocTaglet());
        this.addStandardTaglet(new ValueTaglet());
        this.addStandardTaglet(new LiteralTaglet());
        this.addStandardTaglet(new CodeTaglet());
        this.standardTags.add("deprecated");
        this.standardTags.add("link");
        this.standardTags.add("linkplain");
        this.standardTags.add("serial");
        this.standardTags.add("serialField");
        this.standardTags.add("Text");
    }

    private void initJavaFXTaglets() {
        this.addStandardTaglet(new PropertyGetterTaglet());
        this.addStandardTaglet(new PropertySetterTaglet());
        this.addStandardTaglet(new SimpleTaglet("propertyDescription", this.message.getText("doclet.PropertyDescription", new Object[0]), "fm"));
        this.addStandardTaglet(new SimpleTaglet("defaultValue", this.message.getText("doclet.DefaultValue", new Object[0]), "fm"));
        this.addStandardTaglet(new SimpleTaglet("treatAsPrivate", null, "fmt"));
    }

    void addStandardTaglet(Taglet taglet) {
        String string = taglet.getName();
        this.customTags.put(string, taglet);
        this.standardTags.add(string);
    }

    void addStandardTaglet(boolean bl, Taglet taglet) {
        String string = taglet.getName();
        if (bl) {
            this.customTags.put(string, taglet);
        }
        this.standardTags.add(string);
    }

    private void initStandardTagsLowercase() {
        Iterator<String> iterator = this.standardTags.iterator();
        while (iterator.hasNext()) {
            this.standardTagsLowercase.add(iterator.next().toLowerCase());
        }
    }

    public boolean isKnownCustomTag(String string) {
        return this.customTags.containsKey(string);
    }

    public void printReport() {
        this.printReportHelper("doclet.Notice_taglet_conflict_warn", this.potentiallyConflictingTags);
        this.printReportHelper("doclet.Notice_taglet_overriden", this.overridenStandardTags);
        this.printReportHelper("doclet.Notice_taglet_unseen", this.unseenCustomTags);
    }

    private void printReportHelper(String string, Set<String> set) {
        if (set.size() > 0) {
            String[] stringArray = set.toArray(new String[0]);
            String string2 = " ";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + "@" + stringArray[i];
                if (i + 1 >= stringArray.length) continue;
                string2 = string2 + ", ";
            }
            this.message.notice(string, string2);
        }
    }

    public Taglet getTaglet(String string) {
        if (string.indexOf("@") == 0) {
            return this.customTags.get(string.substring(1));
        }
        return this.customTags.get(string);
    }
}

