/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.PropertyWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PropertyBuilder
extends AbstractMemberBuilder {
    private final ClassDoc classDoc;
    private final VisibleMemberMap visibleMemberMap;
    private final PropertyWriter writer;
    private final List<ProgramElementDoc> properties;
    private int currentPropertyIndex;

    private PropertyBuilder(AbstractBuilder.Context context, ClassDoc classDoc, PropertyWriter propertyWriter) {
        super(context);
        this.classDoc = classDoc;
        this.writer = propertyWriter;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, 8, this.configuration);
        this.properties = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getMembersFor(classDoc));
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.properties, this.configuration.getMemberComparator());
        }
    }

    public static PropertyBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, PropertyWriter propertyWriter) {
        return new PropertyBuilder(context, classDoc, propertyWriter);
    }

    @Override
    public String getName() {
        return "PropertyDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.properties.size() > 0;
    }

    public void buildPropertyDoc(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.properties.size();
        if (n > 0) {
            Content content2 = this.writer.getPropertyDetailsTreeHeader(this.classDoc, content);
            this.currentPropertyIndex = 0;
            while (this.currentPropertyIndex < n) {
                Content content3 = this.writer.getPropertyDocTreeHeader((MethodDoc)this.properties.get(this.currentPropertyIndex), content2);
                this.buildChildren(xMLNode, content3);
                content2.addContent(this.writer.getPropertyDoc(content3, this.currentPropertyIndex == n - 1));
                ++this.currentPropertyIndex;
            }
            content.addContent(this.writer.getPropertyDetails(content2));
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((MethodDoc)this.properties.get(this.currentPropertyIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((MethodDoc)this.properties.get(this.currentPropertyIndex), content);
    }

    public void buildPropertyComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((MethodDoc)this.properties.get(this.currentPropertyIndex), content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((MethodDoc)this.properties.get(this.currentPropertyIndex), content);
    }

    public PropertyWriter getWriter() {
        return this.writer;
    }
}

