/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.ProfileSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.jvm.Profile;
import java.io.IOException;

public class ProfileSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "ProfileDoc";
    private final Profile profile;
    private final ProfileSummaryWriter profileWriter;
    private Content contentTree;
    private PackageDoc pkg;

    private ProfileSummaryBuilder(AbstractBuilder.Context context, Profile profile, ProfileSummaryWriter profileSummaryWriter) {
        super(context);
        this.profile = profile;
        this.profileWriter = profileSummaryWriter;
    }

    public static ProfileSummaryBuilder getInstance(AbstractBuilder.Context context, Profile profile, ProfileSummaryWriter profileSummaryWriter) {
        return new ProfileSummaryBuilder(context, profile, profileSummaryWriter);
    }

    @Override
    public void build() throws IOException {
        if (this.profileWriter == null) {
            return;
        }
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildProfileDoc(XMLNode xMLNode, Content content) throws Exception {
        content = this.profileWriter.getProfileHeader(this.profile.name);
        this.buildChildren(xMLNode, content);
        this.profileWriter.addProfileFooter(content);
        this.profileWriter.printDocument(content);
        this.profileWriter.close();
        Util.copyDocFiles(this.configuration, DocPaths.profileSummary(this.profile.name));
    }

    public void buildContent(XMLNode xMLNode, Content content) {
        Content content2 = this.profileWriter.getContentHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
    }

    public void buildSummary(XMLNode xMLNode, Content content) {
        Content content2 = this.profileWriter.getSummaryHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(this.profileWriter.getSummaryTree(content2));
    }

    public void buildPackageSummary(XMLNode xMLNode, Content content) {
        PackageDoc[] packageDocArray = this.configuration.profilePackages.get(this.profile.name);
        for (int i = 0; i < packageDocArray.length; ++i) {
            this.pkg = packageDocArray[i];
            Content content2 = this.profileWriter.getPackageSummaryHeader(this.pkg);
            this.buildChildren(xMLNode, content2);
            content.addContent(this.profileWriter.getPackageSummaryTree(content2));
        }
    }

    public void buildInterfaceSummary(XMLNode xMLNode, Content content) {
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Interface_Summary"), this.configuration.getText("doclet.interfaces"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Interface"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = this.pkg.interfaces();
        if (classDocArray.length > 0) {
            this.profileWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Interface_Summary"), string, stringArray, content);
        }
    }

    public void buildClassSummary(XMLNode xMLNode, Content content) {
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Class_Summary"), this.configuration.getText("doclet.classes"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = this.pkg.ordinaryClasses();
        if (classDocArray.length > 0) {
            this.profileWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Class_Summary"), string, stringArray, content);
        }
    }

    public void buildEnumSummary(XMLNode xMLNode, Content content) {
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Enum_Summary"), this.configuration.getText("doclet.enums"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Enum"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = this.pkg.enums();
        if (classDocArray.length > 0) {
            this.profileWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Enum_Summary"), string, stringArray, content);
        }
    }

    public void buildExceptionSummary(XMLNode xMLNode, Content content) {
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Exception_Summary"), this.configuration.getText("doclet.exceptions"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Exception"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = this.pkg.exceptions();
        if (classDocArray.length > 0) {
            this.profileWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Exception_Summary"), string, stringArray, content);
        }
    }

    public void buildErrorSummary(XMLNode xMLNode, Content content) {
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Error_Summary"), this.configuration.getText("doclet.errors"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.Error"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = this.pkg.errors();
        if (classDocArray.length > 0) {
            this.profileWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Error_Summary"), string, stringArray, content);
        }
    }

    public void buildAnnotationTypeSummary(XMLNode xMLNode, Content content) {
        String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Annotation_Types_Summary"), this.configuration.getText("doclet.annotationtypes"));
        String[] stringArray = new String[]{this.configuration.getText("doclet.AnnotationType"), this.configuration.getText("doclet.Description")};
        ClassDoc[] classDocArray = this.pkg.annotationTypes();
        if (classDocArray.length > 0) {
            this.profileWriter.addClassesSummary(classDocArray, this.configuration.getText("doclet.Annotation_Types_Summary"), string, stringArray, content);
        }
    }
}

