/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.FieldWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldBuilder
extends AbstractMemberBuilder {
    private final ClassDoc classDoc;
    private final VisibleMemberMap visibleMemberMap;
    private final FieldWriter writer;
    private final List<ProgramElementDoc> fields;
    private int currentFieldIndex;

    private FieldBuilder(AbstractBuilder.Context context, ClassDoc classDoc, FieldWriter fieldWriter) {
        super(context);
        this.classDoc = classDoc;
        this.writer = fieldWriter;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, 2, this.configuration);
        this.fields = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getLeafClassMembers(this.configuration));
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.fields, this.configuration.getMemberComparator());
        }
    }

    public static FieldBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, FieldWriter fieldWriter) {
        return new FieldBuilder(context, classDoc, fieldWriter);
    }

    @Override
    public String getName() {
        return "FieldDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.fields.size() > 0;
    }

    public void buildFieldDoc(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.fields.size();
        if (n > 0) {
            Content content2 = this.writer.getFieldDetailsTreeHeader(this.classDoc, content);
            this.currentFieldIndex = 0;
            while (this.currentFieldIndex < n) {
                Content content3 = this.writer.getFieldDocTreeHeader((FieldDoc)this.fields.get(this.currentFieldIndex), content2);
                this.buildChildren(xMLNode, content3);
                content2.addContent(this.writer.getFieldDoc(content3, this.currentFieldIndex == n - 1));
                ++this.currentFieldIndex;
            }
            content.addContent(this.writer.getFieldDetails(content2));
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((FieldDoc)this.fields.get(this.currentFieldIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((FieldDoc)this.fields.get(this.currentFieldIndex), content);
    }

    public void buildFieldComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((FieldDoc)this.fields.get(this.currentFieldIndex), content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((FieldDoc)this.fields.get(this.currentFieldIndex), content);
    }

    public FieldWriter getWriter() {
        return this.writer;
    }
}

