/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.WriterFactory;
import com.sun.tools.doclets.internal.toolkit.builders.BuilderFactory;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletManager;
import com.sun.tools.doclets.internal.toolkit.util.ClassDocCatalog;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Extern;
import com.sun.tools.doclets.internal.toolkit.util.Group;
import com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.sun.tools.doclets.internal.toolkit.util.MetaKeywords;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.sym.Profiles;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileManager;

public abstract class Configuration {
    protected BuilderFactory builderFactory;
    public TagletManager tagletManager;
    public String builderXMLPath;
    private static final String DEFAULT_BUILDER_XML = "resources/doclet.xml";
    public String tagletpath = "";
    public boolean serialwarn = false;
    public int sourcetab;
    public String tabSpaces;
    public boolean linksource = false;
    public boolean nosince = false;
    public boolean copydocfilesubdirs = false;
    public String charset = "";
    public boolean keywords = false;
    public final MetaKeywords metakeywords = new MetaKeywords(this);
    protected Set<String> excludedDocFileDirs;
    protected Set<String> excludedQualifiers;
    public RootDoc root;
    public String destDirName = "";
    public String docFileDestDirName = "";
    public String docencoding = null;
    public boolean nocomment = false;
    public String encoding = null;
    public boolean showauthor = false;
    public boolean javafx = false;
    public boolean showversion = false;
    public String sourcepath = "";
    public String profilespath = "";
    public boolean showProfiles = false;
    public boolean nodeprecated = false;
    public ClassDocCatalog classDocCatalog;
    public MessageRetriever message = null;
    public boolean notimestamp = false;
    public final Group group = new Group(this);
    public final Extern extern = new Extern(this);
    public Profiles profiles;
    public Map<String, PackageDoc[]> profilePackages;
    public PackageDoc[] packages;

    public abstract String getDocletSpecificBuildDate();

    public abstract void setSpecificDocletOptions(String[][] var1) throws Fault;

    public abstract MessageRetriever getDocletSpecificMsg();

    public Configuration() {
        this.message = new MessageRetriever(this, "com.sun.tools.doclets.internal.toolkit.resources.doclets");
        this.excludedDocFileDirs = new HashSet<String>();
        this.excludedQualifiers = new HashSet<String>();
        this.setTabWidth(8);
    }

    public BuilderFactory getBuilderFactory() {
        if (this.builderFactory == null) {
            this.builderFactory = new BuilderFactory(this);
        }
        return this.builderFactory;
    }

    public int optionLength(String string) {
        if ((string = string.toLowerCase()).equals("-author") || string.equals("-docfilessubdirs") || string.equals("-javafx") || string.equals("-keywords") || string.equals("-linksource") || string.equals("-nocomment") || string.equals("-nodeprecated") || string.equals("-nosince") || string.equals("-notimestamp") || string.equals("-quiet") || string.equals("-xnodate") || string.equals("-version")) {
            return 1;
        }
        if (string.equals("-d") || string.equals("-docencoding") || string.equals("-encoding") || string.equals("-excludedocfilessubdir") || string.equals("-link") || string.equals("-sourcetab") || string.equals("-noqualifier") || string.equals("-output") || string.equals("-sourcepath") || string.equals("-tag") || string.equals("-taglet") || string.equals("-tagletpath") || string.equals("-xprofilespath")) {
            return 2;
        }
        if (string.equals("-group") || string.equals("-linkoffline")) {
            return 3;
        }
        return -1;
    }

    public abstract boolean validOptions(String[][] var1, DocErrorReporter var2);

    private void initProfiles() throws IOException {
        Object object;
        if (this.profilespath.isEmpty()) {
            return;
        }
        this.profiles = Profiles.read(new File(this.profilespath));
        EnumMap enumMap = new EnumMap(Profile.class);
        for (Profile object2 : Profile.values()) {
            enumMap.put(object2, new ArrayList());
        }
        for (Profile profile : this.packages) {
            int n;
            if (this.nodeprecated && Util.isDeprecated((Doc)((Object)profile)) || (object = Profile.lookup(n = this.profiles.getProfile(profile.name().replace(".", "/") + "/*"))) == null) continue;
            List list = (List)enumMap.get(object);
            list.add(profile);
        }
        this.profilePackages = new HashMap<String, PackageDoc[]>();
        Object object3 = Collections.emptyList();
        for (Map.Entry entry : enumMap.entrySet()) {
            Profile profile = (Profile)((Object)entry.getKey());
            object = (List)entry.getValue();
            object.addAll(object3);
            Collections.sort(object);
            int n = object.size();
            if (n > 0) {
                this.profilePackages.put(profile.name, object.toArray(new PackageDoc[object.size()]));
            }
            object3 = object;
        }
        this.showProfiles = !object3.isEmpty();
    }

    private void initPackageArray() {
        HashSet<PackageDoc> hashSet = new HashSet<PackageDoc>(Arrays.asList(this.root.specifiedPackages()));
        ClassDoc[] classDocArray = this.root.specifiedClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            hashSet.add(classDocArray[i].containingPackage());
        }
        ArrayList<PackageDoc> arrayList = new ArrayList<PackageDoc>(hashSet);
        Collections.sort(arrayList);
        this.packages = arrayList.toArray(new PackageDoc[0]);
    }

    public void setOptions(String[][] stringArray) throws Fault {
        String string;
        String[] stringArray2;
        int n;
        LinkedHashSet<String[]> linkedHashSet = new LinkedHashSet<String[]>();
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2 = stringArray[n];
            string = stringArray2[0].toLowerCase();
            if (!string.equals("-d")) continue;
            this.docFileDestDirName = this.destDirName = Configuration.addTrailingFileSep(stringArray2[1]);
            this.ensureOutputDirExists();
            break;
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string2;
            stringArray2 = stringArray[n];
            string = stringArray2[0].toLowerCase();
            if (string.equals("-docfilessubdirs")) {
                this.copydocfilesubdirs = true;
                continue;
            }
            if (string.equals("-docencoding")) {
                this.docencoding = stringArray2[1];
                continue;
            }
            if (string.equals("-encoding")) {
                this.encoding = stringArray2[1];
                continue;
            }
            if (string.equals("-author")) {
                this.showauthor = true;
                continue;
            }
            if (string.equals("-javafx")) {
                this.javafx = true;
                continue;
            }
            if (string.equals("-nosince")) {
                this.nosince = true;
                continue;
            }
            if (string.equals("-version")) {
                this.showversion = true;
                continue;
            }
            if (string.equals("-nodeprecated")) {
                this.nodeprecated = true;
                continue;
            }
            if (string.equals("-sourcepath")) {
                this.sourcepath = stringArray2[1];
                continue;
            }
            if ((string.equals("-classpath") || string.equals("-cp")) && this.sourcepath.length() == 0) {
                this.sourcepath = stringArray2[1];
                continue;
            }
            if (string.equals("-excludedocfilessubdir")) {
                this.addToSet(this.excludedDocFileDirs, stringArray2[1]);
                continue;
            }
            if (string.equals("-noqualifier")) {
                this.addToSet(this.excludedQualifiers, stringArray2[1]);
                continue;
            }
            if (string.equals("-linksource")) {
                this.linksource = true;
                continue;
            }
            if (string.equals("-sourcetab")) {
                this.linksource = true;
                try {
                    this.setTabWidth(Integer.parseInt(stringArray2[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    this.sourcetab = -1;
                }
                if (this.sourcetab > 0) continue;
                this.message.warning("doclet.sourcetab_warning", new Object[0]);
                this.setTabWidth(8);
                continue;
            }
            if (string.equals("-notimestamp")) {
                this.notimestamp = true;
                continue;
            }
            if (string.equals("-nocomment")) {
                this.nocomment = true;
                continue;
            }
            if (string.equals("-tag") || string.equals("-taglet")) {
                linkedHashSet.add(stringArray2);
                continue;
            }
            if (string.equals("-tagletpath")) {
                this.tagletpath = stringArray2[1];
                continue;
            }
            if (string.equals("-xprofilespath")) {
                this.profilespath = stringArray2[1];
                continue;
            }
            if (string.equals("-keywords")) {
                this.keywords = true;
                continue;
            }
            if (string.equals("-serialwarn")) {
                this.serialwarn = true;
                continue;
            }
            if (string.equals("-group")) {
                this.group.checkPackageGroups(stringArray2[1], stringArray2[2]);
                continue;
            }
            if (string.equals("-link")) {
                string2 = stringArray2[1];
                this.extern.link(string2, string2, this.root, false);
                continue;
            }
            if (!string.equals("-linkoffline")) continue;
            string2 = stringArray2[1];
            String string3 = stringArray2[2];
            this.extern.link(string2, string3, this.root, true);
        }
        if (this.sourcepath.length() == 0) {
            String string4 = this.sourcepath = System.getProperty("env.class.path") == null ? "" : System.getProperty("env.class.path");
        }
        if (this.docencoding == null) {
            this.docencoding = this.encoding;
        }
        this.classDocCatalog = new ClassDocCatalog(this.root.specifiedClasses(), this);
        this.initTagletManager(linkedHashSet);
    }

    public void setOptions() throws Fault {
        this.initPackageArray();
        this.setOptions(this.root.options());
        try {
            this.initProfiles();
        }
        catch (Exception exception) {
            throw new DocletAbortException(exception);
        }
        this.setSpecificDocletOptions(this.root.options());
    }

    private void ensureOutputDirExists() throws Fault {
        DocFile docFile = DocFile.createFileForDirectory(this, this.destDirName);
        if (!docFile.exists()) {
            this.root.printNotice(this.getText("doclet.dest_dir_create", this.destDirName));
            docFile.mkdirs();
        } else {
            if (!docFile.isDirectory()) {
                throw new Fault(this.getText("doclet.destination_directory_not_directory_0", docFile.getPath()));
            }
            if (!docFile.canWrite()) {
                throw new Fault(this.getText("doclet.destination_directory_not_writable_0", docFile.getPath()));
            }
        }
    }

    private void initTagletManager(Set<String[]> set) {
        this.tagletManager = this.tagletManager == null ? new TagletManager(this.nosince, this.showversion, this.showauthor, this.javafx, this.message) : this.tagletManager;
        for (String[] stringArray : set) {
            if (stringArray[0].equals("-taglet")) {
                this.tagletManager.addCustomTag(stringArray[1], this.getFileManager(), this.tagletpath);
                continue;
            }
            String[] stringArray2 = this.tokenize(stringArray[1], ':', 3);
            if (stringArray2.length == 1) {
                String string = stringArray[1];
                if (this.tagletManager.isKnownCustomTag(string)) {
                    this.tagletManager.addNewSimpleCustomTag(string, null, "");
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder(string + ":");
                stringBuilder.setCharAt(0, Character.toUpperCase(string.charAt(0)));
                this.tagletManager.addNewSimpleCustomTag(string, stringBuilder.toString(), "a");
                continue;
            }
            if (stringArray2.length == 2) {
                this.tagletManager.addNewSimpleCustomTag(stringArray2[0], stringArray2[1], "");
                continue;
            }
            if (stringArray2.length >= 3) {
                this.tagletManager.addNewSimpleCustomTag(stringArray2[0], stringArray2[2], stringArray2[1]);
                continue;
            }
            this.message.error("doclet.Error_invalid_custom_tag_argument", stringArray[1]);
        }
    }

    private String[] tokenize(String string, char c, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(i)) {
            int n2 = string.codePointAt(i);
            if (bl) {
                stringBuilder.appendCodePoint(n2);
                bl = false;
                continue;
            }
            if (n2 == c && arrayList.size() < n - 1) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                continue;
            }
            if (n2 == 92) {
                bl = true;
                continue;
            }
            stringBuilder.appendCodePoint(n2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    private void addToSet(Set<String> set, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            set.add(string2);
        }
    }

    public static String addTrailingFileSep(String string) {
        int n;
        String string2 = System.getProperty("file.separator");
        String string3 = string2 + string2;
        while ((n = string.indexOf(string3, 1)) >= 0) {
            string = string.substring(0, n) + string.substring(n + string2.length());
        }
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        return string;
    }

    public boolean generalValidOptions(String[][] stringArray, DocErrorReporter docErrorReporter) {
        boolean bl = false;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string2 = stringArray2[0].toLowerCase();
            if (string2.equals("-docencoding")) {
                bl = true;
                if (this.checkOutputFileEncoding(stringArray2[1], docErrorReporter)) continue;
                return false;
            }
            if (!string2.equals("-encoding")) continue;
            string = stringArray2[1];
        }
        return bl || string.length() <= 0 || this.checkOutputFileEncoding(string, docErrorReporter);
    }

    public boolean shouldDocumentProfile(String string) {
        return this.profilePackages.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutputFileEncoding(String string, DocErrorReporter docErrorReporter) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            docErrorReporter.printError(this.getText("doclet.Encoding_not_supported", string));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public boolean shouldExcludeDocFileDir(String string) {
        return this.excludedDocFileDirs.contains(string);
    }

    public boolean shouldExcludeQualifier(String string) {
        if (this.excludedQualifiers.contains("all") || this.excludedQualifiers.contains(string) || this.excludedQualifiers.contains(string + ".*")) {
            return true;
        }
        int n = -1;
        while ((n = string.indexOf(".", n + 1)) != -1) {
            if (!this.excludedQualifiers.contains(string.substring(0, n + 1) + "*")) continue;
            return true;
        }
        return false;
    }

    public String getClassName(ClassDoc classDoc) {
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc != null && this.shouldExcludeQualifier(classDoc.containingPackage().name())) {
            return classDoc.name();
        }
        return classDoc.qualifiedName();
    }

    public String getText(String string) {
        try {
            return this.getDocletSpecificMsg().getText(string, new Object[0]);
        }
        catch (Exception exception) {
            return this.message.getText(string, new Object[0]);
        }
    }

    public String getText(String string, String string2) {
        try {
            return this.getDocletSpecificMsg().getText(string, string2);
        }
        catch (Exception exception) {
            return this.message.getText(string, string2);
        }
    }

    public String getText(String string, String string2, String string3) {
        try {
            return this.getDocletSpecificMsg().getText(string, string2, string3);
        }
        catch (Exception exception) {
            return this.message.getText(string, string2, string3);
        }
    }

    public String getText(String string, String string2, String string3, String string4) {
        try {
            return this.getDocletSpecificMsg().getText(string, string2, string3, string4);
        }
        catch (Exception exception) {
            return this.message.getText(string, string2, string3, string4);
        }
    }

    public abstract Content newContent();

    public Content getResource(String string) {
        Content content = this.newContent();
        content.addContent(this.getText(string));
        return content;
    }

    public Content getResource(String string, Object object) {
        return this.getResource(string, object, null, null);
    }

    public Content getResource(String string, Object object, Object object2) {
        return this.getResource(string, object, object2, null);
    }

    public Content getResource(String string, Object object, Object object2, Object object3) {
        Content content = this.newContent();
        Pattern pattern = Pattern.compile("\\{([012])\\}");
        String string2 = this.getText(string);
        Matcher matcher = pattern.matcher(string2);
        int n = 0;
        while (matcher.find(n)) {
            content.addContent(string2.substring(n, matcher.start()));
            Object object4 = null;
            switch (matcher.group(1).charAt(0)) {
                case '0': {
                    object4 = object;
                    break;
                }
                case '1': {
                    object4 = object2;
                    break;
                }
                case '2': {
                    object4 = object3;
                }
            }
            if (object4 == null) {
                content.addContent("{" + matcher.group(1) + "}");
            } else if (object4 instanceof String) {
                content.addContent((String)object4);
            } else if (object4 instanceof Content) {
                content.addContent((Content)object4);
            }
            n = matcher.end();
        }
        content.addContent(string2.substring(n));
        return content;
    }

    public boolean isGeneratedDoc(ClassDoc classDoc) {
        if (!this.nodeprecated) {
            return true;
        }
        return !Util.isDeprecated(classDoc) && !Util.isDeprecated(classDoc.containingPackage());
    }

    public abstract WriterFactory getWriterFactory();

    public InputStream getBuilderXML() throws IOException {
        return this.builderXMLPath == null ? Configuration.class.getResourceAsStream(DEFAULT_BUILDER_XML) : DocFile.createFileForInput(this, this.builderXMLPath).openInputStream();
    }

    public abstract Locale getLocale();

    public abstract JavaFileManager getFileManager();

    public abstract Comparator<ProgramElementDoc> getMemberComparator();

    private void setTabWidth(int n) {
        this.sourcetab = n;
        this.tabSpaces = String.format("%" + n + "s", "");
    }

    public abstract boolean showMessage(SourcePosition var1, String var2);

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String string) {
            super(string);
        }

        Fault(String string, Exception exception) {
            super(string, exception);
        }
    }
}

