/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.AbstractTreeWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;

public class TreeWriter
extends AbstractTreeWriter {
    private PackageDoc[] packages;
    private boolean classesonly;

    public TreeWriter(ConfigurationImpl configurationImpl, DocPath docPath, ClassTree classTree) throws IOException {
        super(configurationImpl, docPath, classTree);
        this.packages = configurationImpl.packages;
        this.classesonly = this.packages.length == 0;
    }

    public static void generate(ConfigurationImpl configurationImpl, ClassTree classTree) {
        DocPath docPath = DocPaths.OVERVIEW_TREE;
        try {
            TreeWriter treeWriter = new TreeWriter(configurationImpl, docPath, classTree);
            treeWriter.generateTreeFile();
            treeWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), docPath);
            throw new DocletAbortException(iOException);
        }
    }

    public void generateTreeFile() throws IOException {
        Content content = this.getTreeHeader();
        Content content2 = this.getResource("doclet.Hierarchy_For_All_Packages");
        HtmlTree htmlTree = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, content2);
        HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.header, htmlTree);
        this.addPackageTreeLinks(htmlTree2);
        content.addContent(htmlTree2);
        HtmlTree htmlTree3 = new HtmlTree(HtmlTag.DIV);
        htmlTree3.addStyle(HtmlStyle.contentContainer);
        this.addTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy", htmlTree3);
        this.addTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy", htmlTree3);
        this.addTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy", htmlTree3);
        this.addTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy", htmlTree3);
        content.addContent(htmlTree3);
        this.addNavLinks(false, content);
        this.addBottom(content);
        this.printHtmlDocument(null, true, content);
    }

    protected void addPackageTreeLinks(Content content) {
        if (this.packages.length == 1 && this.packages[0].name().length() == 0) {
            return;
        }
        if (!this.classesonly) {
            HtmlTree htmlTree = HtmlTree.SPAN(HtmlStyle.packageHierarchyLabel, this.getResource("doclet.Package_Hierarchies"));
            content.addContent(htmlTree);
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.UL);
            htmlTree2.addStyle(HtmlStyle.horizontal);
            for (int i = 0; i < this.packages.length; ++i) {
                if (this.packages[i].name().length() == 0 || this.configuration.nodeprecated && Util.isDeprecated(this.packages[i])) continue;
                DocPath docPath = this.pathString(this.packages[i], DocPaths.PACKAGE_TREE);
                HtmlTree htmlTree3 = HtmlTree.LI(this.getHyperLink(docPath, (Content)new StringContent(this.packages[i].name())));
                if (i < this.packages.length - 1) {
                    ((Content)htmlTree3).addContent(", ");
                }
                htmlTree2.addContent(htmlTree3);
            }
            content.addContent(htmlTree2);
        }
    }

    protected Content getTreeHeader() {
        String string = this.configuration.getText("doclet.Window_Class_Hierarchy");
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        return htmlTree;
    }
}

