/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.ClassWriterImpl;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.ContentBuilder;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.SerializedFormBuilder;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.sun.tools.doclets.internal.toolkit.util.DocLink;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import com.sun.tools.doclets.internal.toolkit.util.Util;

public class TagletWriterImpl
extends TagletWriter {
    private final HtmlDocletWriter htmlWriter;
    private final ConfigurationImpl configuration;

    public TagletWriterImpl(HtmlDocletWriter htmlDocletWriter, boolean bl) {
        super(bl);
        this.htmlWriter = htmlDocletWriter;
        this.configuration = htmlDocletWriter.configuration;
    }

    @Override
    public Content getOutputInstance() {
        return new ContentBuilder();
    }

    @Override
    protected Content codeTagOutput(Tag tag) {
        HtmlTree htmlTree = HtmlTree.CODE(new StringContent(Util.normalizeNewlines(tag.text())));
        return htmlTree;
    }

    @Override
    public Content getDocRootOutput() {
        String string = this.htmlWriter.pathToRoot.isEmpty() ? "." : this.htmlWriter.pathToRoot.getPath();
        return new StringContent(string);
    }

    @Override
    public Content deprecatedTagOutput(Doc doc) {
        ContentBuilder contentBuilder = new ContentBuilder();
        Tag[] tagArray = doc.tags("deprecated");
        if (doc instanceof ClassDoc) {
            if (Util.isDeprecated((ProgramElementDoc)doc)) {
                Tag[] tagArray2;
                contentBuilder.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
                contentBuilder.addContent(RawHtml.nbsp);
                if (tagArray.length > 0 && (tagArray2 = tagArray[0].inlineTags()).length > 0) {
                    contentBuilder.addContent(this.commentTagsToOutput(null, doc, tagArray[0].inlineTags(), false));
                }
            }
        } else {
            MemberDoc memberDoc = (MemberDoc)doc;
            if (Util.isDeprecated((ProgramElementDoc)doc)) {
                Content content;
                contentBuilder.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
                contentBuilder.addContent(RawHtml.nbsp);
                if (tagArray.length > 0 && !(content = this.commentTagsToOutput(null, doc, tagArray[0].inlineTags(), false)).isEmpty()) {
                    contentBuilder.addContent(HtmlTree.SPAN(HtmlStyle.deprecationComment, content));
                }
            } else if (Util.isDeprecated(memberDoc.containingClass())) {
                contentBuilder.addContent(HtmlTree.SPAN(HtmlStyle.deprecatedLabel, new StringContent(this.configuration.getText("doclet.Deprecated"))));
                contentBuilder.addContent(RawHtml.nbsp);
            }
        }
        return contentBuilder;
    }

    @Override
    protected Content literalTagOutput(Tag tag) {
        StringContent stringContent = new StringContent(Util.normalizeNewlines(tag.text()));
        return stringContent;
    }

    @Override
    public MessageRetriever getMsgRetriever() {
        return this.configuration.message;
    }

    @Override
    public Content getParamHeader(String string) {
        HtmlTree htmlTree = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.paramLabel, new StringContent(string)));
        return htmlTree;
    }

    @Override
    public Content paramTagOutput(ParamTag paramTag, String string) {
        ContentBuilder contentBuilder = new ContentBuilder();
        contentBuilder.addContent(HtmlTree.CODE(new RawHtml(string)));
        contentBuilder.addContent(" - ");
        contentBuilder.addContent(this.htmlWriter.commentTagsToContent(paramTag, null, paramTag.inlineTags(), false));
        HtmlTree htmlTree = HtmlTree.DD(contentBuilder);
        return htmlTree;
    }

    @Override
    public Content propertyTagOutput(Tag tag, String string) {
        ContentBuilder contentBuilder = new ContentBuilder();
        ((Content)contentBuilder).addContent(new RawHtml(string));
        ((Content)contentBuilder).addContent(" ");
        ((Content)contentBuilder).addContent(HtmlTree.CODE(new RawHtml(tag.text())));
        ((Content)contentBuilder).addContent(".");
        HtmlTree htmlTree = HtmlTree.P(contentBuilder);
        return htmlTree;
    }

    @Override
    public Content returnTagOutput(Tag tag) {
        ContentBuilder contentBuilder = new ContentBuilder();
        contentBuilder.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.returnLabel, new StringContent(this.configuration.getText("doclet.Returns")))));
        contentBuilder.addContent(HtmlTree.DD(this.htmlWriter.commentTagsToContent(tag, null, tag.inlineTags(), false)));
        return contentBuilder;
    }

    @Override
    public Content seeTagOutput(Doc doc, SeeTag[] seeTagArray) {
        Object object;
        ContentBuilder contentBuilder = new ContentBuilder();
        if (seeTagArray.length > 0) {
            for (int i = 0; i < seeTagArray.length; ++i) {
                this.appendSeparatorIfNotEmpty(contentBuilder);
                contentBuilder.addContent(this.htmlWriter.seeTagToContent(seeTagArray[i]));
            }
        }
        if (doc.isField() && ((FieldDoc)doc).constantValue() != null && this.htmlWriter instanceof ClassWriterImpl) {
            this.appendSeparatorIfNotEmpty(contentBuilder);
            DocPath docPath = this.htmlWriter.pathToRoot.resolve(DocPaths.CONSTANT_VALUES);
            object = ((ClassWriterImpl)this.htmlWriter).getClassDoc().qualifiedName() + "." + ((FieldDoc)doc).name();
            DocLink docLink = docPath.fragment((String)object);
            contentBuilder.addContent(this.htmlWriter.getHyperLink(docLink, (Content)new StringContent(this.configuration.getText("doclet.Constants_Summary"))));
        }
        if (doc.isClass() && ((ClassDoc)doc).isSerializable() && SerializedFormBuilder.serialInclude(doc) && SerializedFormBuilder.serialInclude(((ClassDoc)doc).containingPackage())) {
            this.appendSeparatorIfNotEmpty(contentBuilder);
            DocPath docPath = this.htmlWriter.pathToRoot.resolve(DocPaths.SERIALIZED_FORM);
            object = docPath.fragment(((ClassDoc)doc).qualifiedName());
            contentBuilder.addContent(this.htmlWriter.getHyperLink((DocLink)object, (Content)new StringContent(this.configuration.getText("doclet.Serialized_Form"))));
        }
        if (contentBuilder.isEmpty()) {
            return contentBuilder;
        }
        ContentBuilder contentBuilder2 = new ContentBuilder();
        contentBuilder2.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.seeLabel, new StringContent(this.configuration.getText("doclet.See_Also")))));
        contentBuilder2.addContent(HtmlTree.DD(contentBuilder));
        return contentBuilder2;
    }

    private void appendSeparatorIfNotEmpty(ContentBuilder contentBuilder) {
        if (!contentBuilder.isEmpty()) {
            contentBuilder.addContent(", ");
            contentBuilder.addContent(DocletConstants.NL);
        }
    }

    @Override
    public Content simpleTagOutput(Tag[] tagArray, String string) {
        ContentBuilder contentBuilder = new ContentBuilder();
        contentBuilder.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.simpleTagLabel, new RawHtml(string))));
        ContentBuilder contentBuilder2 = new ContentBuilder();
        for (int i = 0; i < tagArray.length; ++i) {
            if (i > 0) {
                contentBuilder2.addContent(", ");
            }
            contentBuilder2.addContent(this.htmlWriter.commentTagsToContent(tagArray[i], null, tagArray[i].inlineTags(), false));
        }
        contentBuilder.addContent(HtmlTree.DD(contentBuilder2));
        return contentBuilder;
    }

    @Override
    public Content simpleTagOutput(Tag tag, String string) {
        ContentBuilder contentBuilder = new ContentBuilder();
        contentBuilder.addContent(HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.simpleTagLabel, new RawHtml(string))));
        Content content = this.htmlWriter.commentTagsToContent(tag, null, tag.inlineTags(), false);
        contentBuilder.addContent(HtmlTree.DD(content));
        return contentBuilder;
    }

    @Override
    public Content getThrowsHeader() {
        HtmlTree htmlTree = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.throwsLabel, new StringContent(this.configuration.getText("doclet.Throws"))));
        return htmlTree;
    }

    @Override
    public Content throwsTagOutput(ThrowsTag throwsTag) {
        ContentBuilder contentBuilder = new ContentBuilder();
        RawHtml rawHtml = throwsTag.exceptionType() == null ? new RawHtml(throwsTag.exceptionName()) : this.htmlWriter.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, throwsTag.exceptionType()));
        contentBuilder.addContent(HtmlTree.CODE(rawHtml));
        Content content = this.htmlWriter.commentTagsToContent(throwsTag, null, throwsTag.inlineTags(), false);
        if (content != null && !content.isEmpty()) {
            contentBuilder.addContent(" - ");
            contentBuilder.addContent(content);
        }
        HtmlTree htmlTree = HtmlTree.DD(contentBuilder);
        return htmlTree;
    }

    @Override
    public Content throwsTagOutput(Type type) {
        HtmlTree htmlTree = HtmlTree.DD(HtmlTree.CODE(this.htmlWriter.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, type))));
        return htmlTree;
    }

    @Override
    public Content valueTagOutput(FieldDoc fieldDoc, String string, boolean bl) {
        return bl ? this.htmlWriter.getDocLink(LinkInfoImpl.Kind.VALUE_TAG, fieldDoc, string, false) : new RawHtml(string);
    }

    @Override
    public Content commentTagsToOutput(Tag tag, Tag[] tagArray) {
        return this.commentTagsToOutput(tag, null, tagArray, false);
    }

    @Override
    public Content commentTagsToOutput(Doc doc, Tag[] tagArray) {
        return this.commentTagsToOutput(null, doc, tagArray, false);
    }

    @Override
    public Content commentTagsToOutput(Tag tag, Doc doc, Tag[] tagArray, boolean bl) {
        return this.htmlWriter.commentTagsToContent(tag, doc, tagArray, bl);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

