/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.ProfileSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.jvm.Profile;
import java.io.IOException;

public class ProfileWriterImpl
extends HtmlDocletWriter
implements ProfileSummaryWriter {
    protected Profile prevProfile;
    protected Profile nextProfile;
    protected Profile profile;

    public ProfileWriterImpl(ConfigurationImpl configurationImpl, Profile profile, Profile profile2, Profile profile3) throws IOException {
        super(configurationImpl, DocPaths.profileSummary(profile.name));
        this.prevProfile = profile2;
        this.nextProfile = profile3;
        this.profile = profile;
    }

    @Override
    public Content getProfileHeader(String string) {
        String string2 = this.profile.name;
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string2));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DIV);
        htmlTree2.addStyle(HtmlStyle.header);
        HtmlTree htmlTree3 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, this.profileLabel);
        ((Content)htmlTree3).addContent(this.getSpace());
        RawHtml rawHtml = new RawHtml(string);
        ((Content)htmlTree3).addContent(rawHtml);
        htmlTree2.addContent(htmlTree3);
        ((Content)htmlTree).addContent(htmlTree2);
        return htmlTree;
    }

    @Override
    public Content getContentHeader() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
        htmlTree.addStyle(HtmlStyle.contentContainer);
        return htmlTree;
    }

    @Override
    public Content getSummaryHeader() {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.LI);
        htmlTree.addStyle(HtmlStyle.blockList);
        return htmlTree;
    }

    @Override
    public Content getSummaryTree(Content content) {
        HtmlTree htmlTree = HtmlTree.UL(HtmlStyle.blockList, content);
        HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.summary, htmlTree);
        return htmlTree2;
    }

    @Override
    public Content getPackageSummaryHeader(PackageDoc packageDoc) {
        Content content = this.getTargetProfilePackageLink(packageDoc, "classFrame", new StringContent(packageDoc.name()), this.profile.name);
        HtmlTree htmlTree = HtmlTree.HEADING(HtmlTag.H3, content);
        HtmlTree htmlTree2 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
        this.addPackageDeprecationInfo(htmlTree2, packageDoc);
        return htmlTree2;
    }

    @Override
    public Content getPackageSummaryTree(Content content) {
        HtmlTree htmlTree = HtmlTree.UL(HtmlStyle.blockList, content);
        return htmlTree;
    }

    @Override
    public void addClassesSummary(ClassDoc[] classDocArray, String string, String string2, String[] stringArray, Content content) {
        this.addClassesSummary(classDocArray, string, string2, stringArray, content, this.profile.value);
    }

    @Override
    public void addProfileFooter(Content content) {
        this.addNavLinks(false, content);
        this.addBottom(content);
    }

    @Override
    public void printDocument(Content content) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.profile), true, content);
    }

    public void addPackageDeprecationInfo(Content content, PackageDoc packageDoc) {
        if (Util.isDeprecated(packageDoc)) {
            Tag[] tagArray;
            Tag[] tagArray2 = packageDoc.tags("deprecated");
            HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
            htmlTree.addStyle(HtmlStyle.deprecatedContent);
            HtmlTree htmlTree2 = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            htmlTree.addContent(htmlTree2);
            if (tagArray2.length > 0 && (tagArray = tagArray2[0].inlineTags()).length > 0) {
                this.addInlineDeprecatedComment(packageDoc, tagArray2[0], htmlTree);
            }
            content.addContent(htmlTree);
        }
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree htmlTree = this.prevProfile == null ? HtmlTree.LI(this.prevprofileLabel) : HtmlTree.LI(this.getHyperLink(this.pathToRoot.resolve(DocPaths.profileSummary(this.prevProfile.name)), this.prevprofileLabel, "", ""));
        return htmlTree;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree htmlTree = this.nextProfile == null ? HtmlTree.LI(this.nextprofileLabel) : HtmlTree.LI(this.getHyperLink(this.pathToRoot.resolve(DocPaths.profileSummary(this.nextProfile.name)), this.nextprofileLabel, "", ""));
        return htmlTree;
    }
}

