/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.jvm.Profile;
import java.io.IOException;
import java.util.Arrays;

public class ProfilePackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;

    public ProfilePackageFrameWriter(ConfigurationImpl configurationImpl, PackageDoc packageDoc, String string) throws IOException {
        super(configurationImpl, DocPath.forPackage(packageDoc).resolve(DocPaths.profilePackageFrame(string)));
        this.packageDoc = packageDoc;
    }

    public static void generate(ConfigurationImpl configurationImpl, PackageDoc packageDoc, int n) {
        try {
            String string = Profile.lookup((int)n).name;
            ProfilePackageFrameWriter profilePackageFrameWriter = new ProfilePackageFrameWriter(configurationImpl, packageDoc, string);
            StringBuilder stringBuilder = new StringBuilder(string);
            String string2 = " - ";
            stringBuilder.append(string2);
            String string3 = Util.getPackageName(packageDoc);
            stringBuilder.append(string3);
            HtmlTree htmlTree = profilePackageFrameWriter.getBody(false, profilePackageFrameWriter.getWindowTitle(stringBuilder.toString()));
            StringContent stringContent = new StringContent(string);
            StringContent stringContent2 = new StringContent(string2);
            RawHtml rawHtml = new RawHtml(string3);
            HtmlTree htmlTree2 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, profilePackageFrameWriter.getTargetProfileLink("classFrame", stringContent, string));
            ((Content)htmlTree2).addContent(stringContent2);
            ((Content)htmlTree2).addContent(profilePackageFrameWriter.getTargetProfilePackageLink(packageDoc, "classFrame", rawHtml, string));
            ((Content)htmlTree).addContent(htmlTree2);
            HtmlTree htmlTree3 = new HtmlTree(HtmlTag.DIV);
            htmlTree3.addStyle(HtmlStyle.indexContainer);
            profilePackageFrameWriter.addClassListing(htmlTree3, n);
            ((Content)htmlTree).addContent(htmlTree3);
            profilePackageFrameWriter.printHtmlDocument(configurationImpl.metakeywords.getMetaKeywords(packageDoc), false, htmlTree);
            profilePackageFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), DocPaths.PACKAGE_FRAME.getPath());
            throw new DocletAbortException(iOException);
        }
    }

    protected void addClassListing(Content content, int n) {
        if (this.packageDoc.isIncluded()) {
            this.addClassKindListing(this.packageDoc.interfaces(), this.getResource("doclet.Interfaces"), content, n);
            this.addClassKindListing(this.packageDoc.ordinaryClasses(), this.getResource("doclet.Classes"), content, n);
            this.addClassKindListing(this.packageDoc.enums(), this.getResource("doclet.Enums"), content, n);
            this.addClassKindListing(this.packageDoc.exceptions(), this.getResource("doclet.Exceptions"), content, n);
            this.addClassKindListing(this.packageDoc.errors(), this.getResource("doclet.Errors"), content, n);
            this.addClassKindListing(this.packageDoc.annotationTypes(), this.getResource("doclet.AnnotationTypes"), content, n);
        }
    }

    protected void addClassKindListing(ClassDoc[] classDocArray, Content content, Content content2, int n) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            boolean bl = false;
            HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
            htmlTree.setTitle(content);
            for (int i = 0; i < classDocArray.length; ++i) {
                Content content3;
                if (!this.isTypeInProfile(classDocArray[i], n) || !Util.isCoreClass(classDocArray[i]) || !this.configuration.isGeneratedDoc(classDocArray[i])) continue;
                if (!bl) {
                    content3 = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, content);
                    content2.addContent(content3);
                    bl = true;
                }
                content3 = new StringContent(classDocArray[i].name());
                if (classDocArray[i].isInterface()) {
                    content3 = HtmlTree.SPAN(HtmlStyle.interfaceName, content3);
                }
                Content content4 = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE_FRAME, classDocArray[i]).label(content3).target("classFrame"));
                HtmlTree htmlTree2 = HtmlTree.LI(content4);
                htmlTree.addContent(htmlTree2);
            }
            content2.addContent(htmlTree);
        }
    }
}

