/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.ClassWriterImpl;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.LinkFactoryImpl;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.MethodWriterImpl;
import com.sun.tools.doclets.formats.html.SectionName;
import com.sun.tools.doclets.formats.html.SourceToHTMLConverter;
import com.sun.tools.doclets.formats.html.TagletWriterImpl;
import com.sun.tools.doclets.formats.html.markup.Comment;
import com.sun.tools.doclets.formats.html.markup.ContentBuilder;
import com.sun.tools.doclets.formats.html.markup.DocType;
import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlDocWriter;
import com.sun.tools.doclets.formats.html.markup.HtmlDocument;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.RawHtml;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import com.sun.tools.doclets.internal.toolkit.ClassWriter;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.PackageSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletWriter;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocLink;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.ImplementedMethods;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HtmlDocletWriter
extends HtmlDocWriter {
    public final DocPath pathToRoot;
    public final DocPath path;
    public final DocPath filename;
    public final ConfigurationImpl configuration;
    protected boolean printedAnnotationHeading = false;
    protected boolean printedAnnotationFieldHeading = false;
    private boolean isAnnotationDocumented = false;
    private boolean isContainerDocumented = false;
    static final Set<String> blockTags = new HashSet<String>();

    public HtmlDocletWriter(ConfigurationImpl configurationImpl, DocPath docPath) throws IOException {
        super(configurationImpl, docPath);
        this.configuration = configurationImpl;
        this.path = docPath;
        this.pathToRoot = docPath.parent().invert();
        this.filename = docPath.basename();
    }

    public String replaceDocRootDir(String string) {
        int n = string.indexOf("{@");
        if (n < 0) {
            return string;
        }
        String string2 = string.toLowerCase();
        n = string2.indexOf("{@docroot}", n);
        if (n < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (true) {
            if ((n = string2.indexOf("{@docroot}", n2)) < 0) break;
            stringBuilder.append(string.substring(n2, n));
            n2 = n + "{@docroot}".length();
            if (this.configuration.docrootparent.length() > 0 && string.startsWith("/..", n2)) {
                stringBuilder.append(this.configuration.docrootparent);
                n2 += 3;
            } else {
                stringBuilder.append(this.pathToRoot.isEmpty() ? "." : this.pathToRoot.getPath());
            }
            if (n2 >= string.length() || string.charAt(n2) == '/') continue;
            stringBuilder.append('/');
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public Content getAllClassesLinkScript(String string) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SCRIPT);
        htmlTree.addAttr(HtmlAttr.TYPE, "text/javascript");
        String string2 = "<!--" + DocletConstants.NL + "  allClassesLink = document.getElementById(\"" + string + "\");" + DocletConstants.NL + "  if(window==top) {" + DocletConstants.NL + "    allClassesLink.style.display = \"block\";" + DocletConstants.NL + "  }" + DocletConstants.NL + "  else {" + DocletConstants.NL + "    allClassesLink.style.display = \"none\";" + DocletConstants.NL + "  }" + DocletConstants.NL + "  //-->" + DocletConstants.NL;
        RawHtml rawHtml = new RawHtml(string2);
        htmlTree.addContent(rawHtml);
        HtmlTree htmlTree2 = HtmlTree.DIV(htmlTree);
        return htmlTree2;
    }

    private void addMethodInfo(MethodDoc methodDoc, Content content) {
        ClassDoc[] classDocArray = methodDoc.containingClass().interfaces();
        MethodDoc methodDoc2 = methodDoc.overriddenMethod();
        if (classDocArray.length > 0 && new ImplementedMethods(methodDoc, this.configuration).build().length > 0 || methodDoc2 != null) {
            MethodWriterImpl.addImplementsInfo(this, methodDoc, content);
            if (methodDoc2 != null) {
                MethodWriterImpl.addOverridden(this, methodDoc.overriddenType(), methodDoc2, content);
            }
        }
    }

    protected void addTagsInfo(Doc doc, Content content) {
        if (this.configuration.nocomment) {
            return;
        }
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DL);
        if (doc instanceof MethodDoc) {
            this.addMethodInfo((MethodDoc)doc, htmlTree);
        }
        ContentBuilder contentBuilder = new ContentBuilder();
        TagletWriter.genTagOuput(this.configuration.tagletManager, doc, this.configuration.tagletManager.getCustomTaglets(doc), this.getTagletWriterInstance(false), contentBuilder);
        ((Content)htmlTree).addContent(contentBuilder);
        content.addContent(htmlTree);
    }

    protected boolean hasSerializationOverviewTags(FieldDoc fieldDoc) {
        ContentBuilder contentBuilder = new ContentBuilder();
        TagletWriter.genTagOuput(this.configuration.tagletManager, fieldDoc, this.configuration.tagletManager.getCustomTaglets(fieldDoc), this.getTagletWriterInstance(false), contentBuilder);
        return !((Content)contentBuilder).isEmpty();
    }

    public TagletWriter getTagletWriterInstance(boolean bl) {
        return new TagletWriterImpl(this, bl);
    }

    public Content getTargetPackageLink(PackageDoc packageDoc, String string, Content content) {
        return this.getHyperLink(this.pathString(packageDoc, DocPaths.PACKAGE_SUMMARY), content, "", string);
    }

    public Content getTargetProfilePackageLink(PackageDoc packageDoc, String string, Content content, String string2) {
        return this.getHyperLink(this.pathString(packageDoc, DocPaths.profilePackageSummary(string2)), content, "", string);
    }

    public Content getTargetProfileLink(String string, Content content, String string2) {
        return this.getHyperLink(this.pathToRoot.resolve(DocPaths.profileSummary(string2)), content, "", string);
    }

    public String getTypeNameForProfile(ClassDoc classDoc) {
        StringBuilder stringBuilder = new StringBuilder(classDoc.containingPackage().name().replace(".", "/"));
        stringBuilder.append("/").append(classDoc.name().replace(".", "$"));
        return stringBuilder.toString();
    }

    public boolean isTypeInProfile(ClassDoc classDoc, int n) {
        return this.configuration.profiles.getProfile(this.getTypeNameForProfile(classDoc)) <= n;
    }

    public void addClassesSummary(ClassDoc[] classDocArray, String string, String string2, String[] stringArray, Content content, int n) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            Content content2 = this.getTableCaption(new RawHtml(string));
            HtmlTree htmlTree = HtmlTree.TABLE(HtmlStyle.typeSummary, 0, 3, 0, string2, content2);
            ((Content)htmlTree).addContent(this.getSummaryTableHeader(stringArray, "col"));
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < classDocArray.length; ++i) {
                if (!this.isTypeInProfile(classDocArray[i], n) || !Util.isCoreClass(classDocArray[i]) || !this.configuration.isGeneratedDoc(classDocArray[i])) continue;
                Content content3 = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE, classDocArray[i]));
                HtmlTree htmlTree3 = HtmlTree.TD(HtmlStyle.colFirst, content3);
                HtmlTree htmlTree4 = HtmlTree.TR(htmlTree3);
                if (i % 2 == 0) {
                    htmlTree4.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree4.addStyle(HtmlStyle.rowColor);
                }
                HtmlTree htmlTree5 = new HtmlTree(HtmlTag.TD);
                htmlTree5.addStyle(HtmlStyle.colLast);
                if (Util.isDeprecated(classDocArray[i])) {
                    htmlTree5.addContent(this.deprecatedLabel);
                    if (classDocArray[i].tags("deprecated").length > 0) {
                        this.addSummaryDeprecatedComment(classDocArray[i], classDocArray[i].tags("deprecated")[0], htmlTree5);
                    }
                } else {
                    this.addSummaryComment(classDocArray[i], htmlTree5);
                }
                htmlTree4.addContent(htmlTree5);
                ((Content)htmlTree2).addContent(htmlTree4);
            }
            ((Content)htmlTree).addContent(htmlTree2);
            content.addContent(htmlTree);
        }
    }

    public void printHtmlDocument(String[] stringArray, boolean bl, Content content) throws IOException {
        Content content2;
        Object object;
        DocType docType = DocType.TRANSITIONAL;
        Comment comment = new Comment(this.configuration.getText("doclet.New_Page"));
        HtmlTree htmlTree = new HtmlTree(HtmlTag.HEAD);
        ((Content)htmlTree).addContent(this.getGeneratedBy(!this.configuration.notimestamp));
        if (this.configuration.charset.length() > 0) {
            object = HtmlTree.META("Content-Type", "text/html", this.configuration.charset);
            ((Content)htmlTree).addContent((Content)object);
        }
        ((Content)htmlTree).addContent(this.getTitle());
        if (!this.configuration.notimestamp) {
            object = new SimpleDateFormat("yyyy-MM-dd");
            content2 = HtmlTree.META("date", ((DateFormat)object).format(new Date()));
            ((Content)htmlTree).addContent(content2);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                content2 = HtmlTree.META("keywords", stringArray[i]);
                ((Content)htmlTree).addContent(content2);
            }
        }
        ((Content)htmlTree).addContent(this.getStyleSheetProperties());
        ((Content)htmlTree).addContent(this.getScriptProperties());
        HtmlTree htmlTree2 = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), htmlTree, content);
        content2 = new HtmlDocument(docType, comment, htmlTree2);
        this.write(content2);
    }

    public String getWindowTitle(String string) {
        if (this.configuration.windowtitle.length() > 0) {
            string = string + " (" + this.configuration.windowtitle + ")";
        }
        return string;
    }

    public Content getUserHeaderFooter(boolean bl) {
        String string = bl ? this.replaceDocRootDir(this.configuration.header) : (this.configuration.footer.length() != 0 ? this.replaceDocRootDir(this.configuration.footer) : this.replaceDocRootDir(this.configuration.header));
        RawHtml rawHtml = new RawHtml(string);
        return rawHtml;
    }

    public void addTop(Content content) {
        RawHtml rawHtml = new RawHtml(this.replaceDocRootDir(this.configuration.top));
        content.addContent(rawHtml);
    }

    public void addBottom(Content content) {
        RawHtml rawHtml = new RawHtml(this.replaceDocRootDir(this.configuration.bottom));
        HtmlTree htmlTree = HtmlTree.SMALL(rawHtml);
        HtmlTree htmlTree2 = HtmlTree.P(HtmlStyle.legalCopy, htmlTree);
        content.addContent(htmlTree2);
    }

    protected void addNavLinks(boolean bl, Content content) {
        if (!this.configuration.nonavbar) {
            HtmlTree htmlTree;
            Content content2;
            String string = "allclasses_";
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DIV);
            Content content3 = this.configuration.getResource("doclet.Skip_navigation_links");
            if (bl) {
                content.addContent(HtmlConstants.START_OF_TOP_NAVBAR);
                htmlTree2.addStyle(HtmlStyle.topNav);
                string = string + "navbar_top";
                content2 = this.getMarkerAnchor(SectionName.NAVBAR_TOP);
                htmlTree2.addContent(content2);
                htmlTree = HtmlTree.DIV(HtmlStyle.skipNav, this.getHyperLink(this.getDocLink(SectionName.SKIP_NAVBAR_TOP), content3, content3.toString(), ""));
                htmlTree2.addContent(htmlTree);
            } else {
                content.addContent(HtmlConstants.START_OF_BOTTOM_NAVBAR);
                htmlTree2.addStyle(HtmlStyle.bottomNav);
                string = string + "navbar_bottom";
                content2 = this.getMarkerAnchor(SectionName.NAVBAR_BOTTOM);
                htmlTree2.addContent(content2);
                htmlTree = HtmlTree.DIV(HtmlStyle.skipNav, this.getHyperLink(this.getDocLink(SectionName.SKIP_NAVBAR_BOTTOM), content3, content3.toString(), ""));
                htmlTree2.addContent(htmlTree);
            }
            if (bl) {
                htmlTree2.addContent(this.getMarkerAnchor(SectionName.NAVBAR_TOP_FIRSTROW));
            } else {
                htmlTree2.addContent(this.getMarkerAnchor(SectionName.NAVBAR_BOTTOM_FIRSTROW));
            }
            content2 = new HtmlTree(HtmlTag.UL);
            ((HtmlTree)content2).addStyle(HtmlStyle.navList);
            ((HtmlTree)content2).addAttr(HtmlAttr.TITLE, this.configuration.getText("doclet.Navigation"));
            if (this.configuration.createoverview) {
                ((HtmlTree)content2).addContent(this.getNavLinkContents());
            }
            if (this.configuration.packages.length == 1) {
                ((HtmlTree)content2).addContent(this.getNavLinkPackage(this.configuration.packages[0]));
            } else if (this.configuration.packages.length > 1) {
                ((HtmlTree)content2).addContent(this.getNavLinkPackage());
            }
            ((HtmlTree)content2).addContent(this.getNavLinkClass());
            if (this.configuration.classuse) {
                ((HtmlTree)content2).addContent(this.getNavLinkClassUse());
            }
            if (this.configuration.createtree) {
                ((HtmlTree)content2).addContent(this.getNavLinkTree());
            }
            if (!this.configuration.nodeprecated && !this.configuration.nodeprecatedlist) {
                ((HtmlTree)content2).addContent(this.getNavLinkDeprecated());
            }
            if (this.configuration.createindex) {
                ((HtmlTree)content2).addContent(this.getNavLinkIndex());
            }
            if (!this.configuration.nohelp) {
                ((HtmlTree)content2).addContent(this.getNavLinkHelp());
            }
            htmlTree2.addContent(content2);
            htmlTree = HtmlTree.DIV(HtmlStyle.aboutLanguage, this.getUserHeaderFooter(bl));
            htmlTree2.addContent(htmlTree);
            content.addContent(htmlTree2);
            HtmlTree htmlTree3 = HtmlTree.UL(HtmlStyle.navList, this.getNavLinkPrevious());
            ((Content)htmlTree3).addContent(this.getNavLinkNext());
            HtmlTree htmlTree4 = HtmlTree.DIV(HtmlStyle.subNav, htmlTree3);
            HtmlTree htmlTree5 = HtmlTree.UL(HtmlStyle.navList, this.getNavShowLists());
            ((Content)htmlTree5).addContent(this.getNavHideLists(this.filename));
            ((Content)htmlTree4).addContent(htmlTree5);
            HtmlTree htmlTree6 = HtmlTree.UL(HtmlStyle.navList, this.getNavLinkClassIndex());
            htmlTree6.addAttr(HtmlAttr.ID, string.toString());
            ((Content)htmlTree4).addContent(htmlTree6);
            ((Content)htmlTree4).addContent(this.getAllClassesLinkScript(string.toString()));
            this.addSummaryDetailLinks(htmlTree4);
            if (bl) {
                ((Content)htmlTree4).addContent(this.getMarkerAnchor(SectionName.SKIP_NAVBAR_TOP));
                content.addContent(htmlTree4);
                content.addContent(HtmlConstants.END_OF_TOP_NAVBAR);
            } else {
                ((Content)htmlTree4).addContent(this.getMarkerAnchor(SectionName.SKIP_NAVBAR_BOTTOM));
                content.addContent(htmlTree4);
                content.addContent(HtmlConstants.END_OF_BOTTOM_NAVBAR);
            }
        }
    }

    protected Content getNavLinkNext() {
        return this.getNavLinkNext(null);
    }

    protected Content getNavLinkPrevious() {
        return this.getNavLinkPrevious(null);
    }

    protected void addSummaryDetailLinks(Content content) {
    }

    protected Content getNavLinkContents() {
        Content content = this.getHyperLink(this.pathToRoot.resolve(DocPaths.OVERVIEW_SUMMARY), this.overviewLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkPackage(PackageDoc packageDoc) {
        Content content = this.getPackageLink(packageDoc, this.packageLabel);
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkPackage() {
        HtmlTree htmlTree = HtmlTree.LI(this.packageLabel);
        return htmlTree;
    }

    protected Content getNavLinkClassUse() {
        HtmlTree htmlTree = HtmlTree.LI(this.useLabel);
        return htmlTree;
    }

    public Content getNavLinkPrevious(DocPath docPath) {
        HtmlTree htmlTree = docPath != null ? HtmlTree.LI(this.getHyperLink(docPath, this.prevLabel, "", "")) : HtmlTree.LI(this.prevLabel);
        return htmlTree;
    }

    public Content getNavLinkNext(DocPath docPath) {
        HtmlTree htmlTree = docPath != null ? HtmlTree.LI(this.getHyperLink(docPath, this.nextLabel, "", "")) : HtmlTree.LI(this.nextLabel);
        return htmlTree;
    }

    protected Content getNavShowLists(DocPath docPath) {
        DocLink docLink = new DocLink(docPath, this.path.getPath(), null);
        Content content = this.getHyperLink(docLink, this.framesLabel, "", "_top");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavShowLists() {
        return this.getNavShowLists(this.pathToRoot.resolve(DocPaths.INDEX));
    }

    protected Content getNavHideLists(DocPath docPath) {
        Content content = this.getHyperLink(docPath, this.noframesLabel, "", "_top");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkTree() {
        PackageDoc[] packageDocArray = this.configuration.root.specifiedPackages();
        Content content = packageDocArray.length == 1 && this.configuration.root.specifiedClasses().length == 0 ? this.getHyperLink(this.pathString(packageDocArray[0], DocPaths.PACKAGE_TREE), this.treeLabel, "", "") : this.getHyperLink(this.pathToRoot.resolve(DocPaths.OVERVIEW_TREE), this.treeLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkMainTree(String string) {
        Content content = this.getHyperLink(this.pathToRoot.resolve(DocPaths.OVERVIEW_TREE), (Content)new StringContent(string));
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkClass() {
        HtmlTree htmlTree = HtmlTree.LI(this.classLabel);
        return htmlTree;
    }

    protected Content getNavLinkDeprecated() {
        Content content = this.getHyperLink(this.pathToRoot.resolve(DocPaths.DEPRECATED_LIST), this.deprecatedLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkClassIndex() {
        Content content = this.getHyperLink(this.pathToRoot.resolve(DocPaths.ALLCLASSES_NOFRAME), this.allclassesLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkIndex() {
        Content content = this.getHyperLink(this.pathToRoot.resolve(this.configuration.splitindex ? DocPaths.INDEX_FILES.resolve(DocPaths.indexN(1)) : DocPaths.INDEX_ALL), this.indexLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }

    protected Content getNavLinkHelp() {
        Object object;
        DocPath docPath;
        String string = this.configuration.helpfile;
        if (string.isEmpty()) {
            docPath = DocPaths.HELP_DOC;
        } else {
            object = DocFile.createFileForInput(this.configuration, string);
            docPath = DocPath.create(((DocFile)object).getName());
        }
        object = this.getHyperLink(this.pathToRoot.resolve(docPath), this.helpLabel, "", "");
        HtmlTree htmlTree = HtmlTree.LI((Content)object);
        return htmlTree;
    }

    public Content getSummaryTableHeader(String[] stringArray, String string) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TR);
        int n = stringArray.length;
        if (n == 1) {
            StringContent stringContent = new StringContent(stringArray[0]);
            ((Content)htmlTree).addContent(HtmlTree.TH(HtmlStyle.colOne, string, stringContent));
            return htmlTree;
        }
        for (int i = 0; i < n; ++i) {
            StringContent stringContent = new StringContent(stringArray[i]);
            if (i == 0) {
                ((Content)htmlTree).addContent(HtmlTree.TH(HtmlStyle.colFirst, string, stringContent));
                continue;
            }
            if (i == n - 1) {
                ((Content)htmlTree).addContent(HtmlTree.TH(HtmlStyle.colLast, string, stringContent));
                continue;
            }
            ((Content)htmlTree).addContent(HtmlTree.TH(string, stringContent));
        }
        return htmlTree;
    }

    public Content getTableCaption(Content content) {
        HtmlTree htmlTree = HtmlTree.SPAN(content);
        Content content2 = this.getSpace();
        HtmlTree htmlTree2 = HtmlTree.SPAN(HtmlStyle.tabEnd, content2);
        HtmlTree htmlTree3 = HtmlTree.CAPTION(htmlTree);
        ((Content)htmlTree3).addContent(htmlTree2);
        return htmlTree3;
    }

    public Content getMarkerAnchor(String string) {
        return this.getMarkerAnchor(this.getName(string), null);
    }

    public Content getMarkerAnchor(SectionName sectionName) {
        return this.getMarkerAnchor(sectionName.getName(), null);
    }

    public Content getMarkerAnchor(SectionName sectionName, String string) {
        return this.getMarkerAnchor(sectionName.getName() + this.getName(string), null);
    }

    public Content getMarkerAnchor(String string, Content content) {
        if (content == null) {
            content = new Comment(" ");
        }
        HtmlTree htmlTree = HtmlTree.A_NAME(string, content);
        return htmlTree;
    }

    public Content getPackageName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? this.defaultPackageLabel : this.getPackageLabel(packageDoc.name());
    }

    public Content getPackageLabel(String string) {
        return new StringContent(string);
    }

    protected void addPackageDeprecatedAPI(List<Doc> list, String string, String string2, String[] stringArray, Content content) {
        if (list.size() > 0) {
            Object object;
            HtmlTree htmlTree = HtmlTree.TABLE(HtmlStyle.deprecatedSummary, 0, 3, 0, string2, this.getTableCaption(this.configuration.getResource(string)));
            ((Content)htmlTree).addContent(this.getSummaryTableHeader(stringArray, "col"));
            HtmlTree htmlTree2 = new HtmlTree(HtmlTag.TBODY);
            for (int i = 0; i < list.size(); ++i) {
                object = (PackageDoc)list.get(i);
                HtmlTree htmlTree3 = HtmlTree.TD(HtmlStyle.colOne, this.getPackageLink((PackageDoc)object, this.getPackageName((PackageDoc)object)));
                if (object.tags("deprecated").length > 0) {
                    this.addInlineDeprecatedComment((Doc)object, object.tags("deprecated")[0], htmlTree3);
                }
                HtmlTree htmlTree4 = HtmlTree.TR(htmlTree3);
                if (i % 2 == 0) {
                    htmlTree4.addStyle(HtmlStyle.altColor);
                } else {
                    htmlTree4.addStyle(HtmlStyle.rowColor);
                }
                ((Content)htmlTree2).addContent(htmlTree4);
            }
            ((Content)htmlTree).addContent(htmlTree2);
            HtmlTree htmlTree5 = HtmlTree.LI(HtmlStyle.blockList, htmlTree);
            object = HtmlTree.UL(HtmlStyle.blockList, htmlTree5);
            content.addContent((Content)object);
        }
    }

    protected DocPath pathString(ClassDoc classDoc, DocPath docPath) {
        return this.pathString(classDoc.containingPackage(), docPath);
    }

    protected DocPath pathString(PackageDoc packageDoc, DocPath docPath) {
        return this.pathToRoot.resolve(DocPath.forPackage(packageDoc).resolve(docPath));
    }

    public Content getPackageLink(PackageDoc packageDoc, String string) {
        return this.getPackageLink(packageDoc, new StringContent(string));
    }

    public Content getPackageLink(PackageDoc packageDoc, Content content) {
        Object object;
        boolean bl;
        boolean bl2 = bl = packageDoc != null && packageDoc.isIncluded();
        if (!bl) {
            object = this.configuration.packages;
            for (int i = 0; i < ((PackageDoc[])object).length; ++i) {
                if (!object[i].equals(packageDoc)) continue;
                bl = true;
                break;
            }
        }
        if (bl || packageDoc == null) {
            return this.getHyperLink(this.pathString(packageDoc, DocPaths.PACKAGE_SUMMARY), content);
        }
        object = this.getCrossPackageLink(Util.getPackageName(packageDoc));
        if (object != null) {
            return this.getHyperLink((DocLink)object, content);
        }
        return content;
    }

    public Content italicsClassName(ClassDoc classDoc, boolean bl) {
        StringContent stringContent = new StringContent(bl ? classDoc.qualifiedName() : classDoc.name());
        return classDoc.isInterface() ? HtmlTree.SPAN(HtmlStyle.interfaceName, stringContent) : stringContent;
    }

    public void addSrcLink(ProgramElementDoc programElementDoc, Content content, Content content2) {
        if (programElementDoc == null) {
            return;
        }
        ClassDoc classDoc = programElementDoc.containingClass();
        if (classDoc == null) {
            classDoc = (ClassDoc)programElementDoc;
        }
        DocPath docPath = this.pathToRoot.resolve(DocPaths.SOURCE_OUTPUT).resolve(DocPath.forClass(classDoc));
        Content content3 = this.getHyperLink(docPath.fragment(SourceToHTMLConverter.getAnchorName(programElementDoc)), content, "", "");
        content2.addContent(content3);
    }

    public Content getLink(LinkInfoImpl linkInfoImpl) {
        LinkFactoryImpl linkFactoryImpl = new LinkFactoryImpl(this);
        return linkFactoryImpl.getLink(linkInfoImpl);
    }

    public Content getTypeParameterLinks(LinkInfoImpl linkInfoImpl) {
        LinkFactoryImpl linkFactoryImpl = new LinkFactoryImpl(this);
        return linkFactoryImpl.getTypeParameterLinks(linkInfoImpl, false);
    }

    public Content getCrossClassLink(String string, String string2, Content content, boolean bl, String string3, boolean bl2) {
        int n;
        String string4;
        String string5 = "";
        String string6 = string4 = string == null ? "" : string;
        while ((n = string4.lastIndexOf(46)) != -1) {
            string5 = string4.substring(n + 1, string4.length()) + (string5.length() > 0 ? "." + string5 : "");
            Content content2 = new StringContent(string5);
            if (bl2) {
                content2 = HtmlTree.CODE(content2);
            }
            if (this.getCrossPackageLink(string4 = string4.substring(0, n)) == null) continue;
            DocLink docLink = this.configuration.extern.getExternalLink(string4, this.pathToRoot, string5 + ".html", string2);
            return this.getHyperLink(docLink, content == null || content.isEmpty() ? content2 : content, bl, string3, this.configuration.getText("doclet.Href_Class_Or_Interface_Title", string4), "");
        }
        return null;
    }

    public boolean isClassLinkable(ClassDoc classDoc) {
        if (classDoc.isIncluded()) {
            return this.configuration.isGeneratedDoc(classDoc);
        }
        return this.configuration.extern.isExternal(classDoc);
    }

    public DocLink getCrossPackageLink(String string) {
        return this.configuration.extern.getExternalLink(string, this.pathToRoot, DocPaths.PACKAGE_SUMMARY.getPath());
    }

    public Content getQualifiedClassLink(LinkInfoImpl.Kind kind, ClassDoc classDoc) {
        return this.getLink(new LinkInfoImpl(this.configuration, kind, classDoc).label(this.configuration.getClassName(classDoc)));
    }

    public void addPreQualifiedClassLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, Content content) {
        this.addPreQualifiedClassLink(kind, classDoc, false, content);
    }

    public Content getPreQualifiedClassLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, boolean bl) {
        ContentBuilder contentBuilder = new ContentBuilder();
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc != null && !this.configuration.shouldExcludeQualifier(packageDoc.name())) {
            contentBuilder.addContent(this.getPkgName(classDoc));
        }
        contentBuilder.addContent(this.getLink(new LinkInfoImpl(this.configuration, kind, classDoc).label(classDoc.name()).strong(bl)));
        return contentBuilder;
    }

    public void addPreQualifiedClassLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, boolean bl, Content content) {
        PackageDoc packageDoc = classDoc.containingPackage();
        if (packageDoc != null && !this.configuration.shouldExcludeQualifier(packageDoc.name())) {
            content.addContent(this.getPkgName(classDoc));
        }
        content.addContent(this.getLink(new LinkInfoImpl(this.configuration, kind, classDoc).label(classDoc.name()).strong(bl)));
    }

    public void addPreQualifiedStrongClassLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, Content content) {
        this.addPreQualifiedClassLink(kind, classDoc, true, content);
    }

    public Content getDocLink(LinkInfoImpl.Kind kind, MemberDoc memberDoc, String string) {
        return this.getDocLink(kind, memberDoc.containingClass(), memberDoc, new StringContent(string));
    }

    public Content getDocLink(LinkInfoImpl.Kind kind, MemberDoc memberDoc, String string, boolean bl) {
        return this.getDocLink(kind, memberDoc.containingClass(), memberDoc, string, bl);
    }

    public Content getDocLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, MemberDoc memberDoc, String string, boolean bl) {
        return this.getDocLink(kind, classDoc, memberDoc, string, bl, false);
    }

    public Content getDocLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, MemberDoc memberDoc, Content content, boolean bl) {
        return this.getDocLink(kind, classDoc, memberDoc, content, bl, false);
    }

    public Content getDocLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, MemberDoc memberDoc, String string, boolean bl, boolean bl2) {
        return this.getDocLink(kind, classDoc, memberDoc, new StringContent(this.check(string)), bl, bl2);
    }

    String check(String string) {
        if (string.matches(".*[&<>].*")) {
            throw new IllegalArgumentException(string);
        }
        return string;
    }

    public Content getDocLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, MemberDoc memberDoc, Content content, boolean bl, boolean bl2) {
        if (!memberDoc.isIncluded() && !Util.isLinkable(classDoc, this.configuration)) {
            return content;
        }
        if (memberDoc instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)memberDoc;
            return this.getLink(new LinkInfoImpl(this.configuration, kind, classDoc).label(content).where(this.getName(this.getAnchor(executableMemberDoc, bl2))).strong(bl));
        }
        if (memberDoc instanceof MemberDoc) {
            return this.getLink(new LinkInfoImpl(this.configuration, kind, classDoc).label(content).where(this.getName(memberDoc.name())).strong(bl));
        }
        return content;
    }

    public Content getDocLink(LinkInfoImpl.Kind kind, ClassDoc classDoc, MemberDoc memberDoc, Content content) {
        if (!memberDoc.isIncluded() && !Util.isLinkable(classDoc, this.configuration)) {
            return content;
        }
        if (memberDoc instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)memberDoc;
            return this.getLink(new LinkInfoImpl(this.configuration, kind, classDoc).label(content).where(this.getName(this.getAnchor(executableMemberDoc))));
        }
        if (memberDoc instanceof MemberDoc) {
            return this.getLink(new LinkInfoImpl(this.configuration, kind, classDoc).label(content).where(this.getName(memberDoc.name())));
        }
        return content;
    }

    public String getAnchor(ExecutableMemberDoc executableMemberDoc) {
        return this.getAnchor(executableMemberDoc, false);
    }

    public String getAnchor(ExecutableMemberDoc executableMemberDoc, boolean bl) {
        if (bl) {
            return executableMemberDoc.name();
        }
        StringBuilder stringBuilder = new StringBuilder(executableMemberDoc.signature());
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '<') {
                ++n;
                continue;
            }
            if (c == '>') {
                --n;
                continue;
            }
            if (n != 0) continue;
            stringBuilder2.append(c);
        }
        return executableMemberDoc.name() + stringBuilder2.toString();
    }

    public Content seeTagToContent(SeeTag seeTag) {
        String string = seeTag.name();
        if (!string.startsWith("@link") && !string.equals("@see")) {
            return new ContentBuilder();
        }
        String string2 = this.replaceDocRootDir(Util.normalizeNewlines(seeTag.text()));
        if (string2.startsWith("<") || string2.startsWith("\"")) {
            return new RawHtml(string2);
        }
        boolean bl = string.equalsIgnoreCase("@linkplain");
        Content content = this.plainOrCode(bl, new RawHtml(seeTag.label()));
        Content content2 = this.plainOrCode(bl, new RawHtml(string2));
        ClassDoc classDoc = seeTag.referencedClass();
        String string3 = seeTag.referencedClassName();
        MemberDoc memberDoc = seeTag.referencedMember();
        String string4 = seeTag.referencedMemberName();
        if (classDoc == null) {
            PackageDoc packageDoc = seeTag.referencedPackage();
            if (packageDoc != null && packageDoc.isIncluded()) {
                if (content.isEmpty()) {
                    content = this.plainOrCode(bl, new StringContent(packageDoc.name()));
                }
                return this.getPackageLink(packageDoc, content);
            }
            DocLink docLink = this.getCrossPackageLink(string3);
            if (docLink != null) {
                return this.getHyperLink(docLink, content.isEmpty() ? content2 : content);
            }
            Content content3 = this.getCrossClassLink(string3, string4, content, false, "", !bl);
            if (content3 != null) {
                return content3;
            }
            this.configuration.getDocletSpecificMsg().warning(seeTag.position(), "doclet.see.class_or_package_not_found", string, string2);
            return content.isEmpty() ? content2 : content;
        }
        if (string4 == null) {
            if (content.isEmpty()) {
                content = this.plainOrCode(bl, new StringContent(classDoc.name()));
            }
            return this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.DEFAULT, classDoc).label(content));
        }
        if (memberDoc == null) {
            return content.isEmpty() ? content2 : content;
        }
        ClassDoc classDoc2 = memberDoc.containingClass();
        if (seeTag.text().trim().startsWith("#") && !classDoc2.isPublic() && !Util.isLinkable(classDoc2, this.configuration)) {
            if (this instanceof ClassWriterImpl) {
                classDoc2 = ((ClassWriterImpl)this).getClassDoc();
            } else if (!classDoc2.isPublic()) {
                this.configuration.getDocletSpecificMsg().warning(seeTag.position(), "doclet.see.class_or_package_not_accessible", string, classDoc2.qualifiedName());
            } else {
                this.configuration.getDocletSpecificMsg().warning(seeTag.position(), "doclet.see.class_or_package_not_found", string, string2);
            }
        }
        if (this.configuration.currentcd != classDoc2) {
            string4 = classDoc2.name() + "." + string4;
        }
        if (memberDoc instanceof ExecutableMemberDoc && string4.indexOf(40) < 0) {
            string4 = string4 + ((ExecutableMemberDoc)memberDoc).signature();
        }
        content2 = this.plainOrCode(bl, new StringContent(string4));
        return this.getDocLink(LinkInfoImpl.Kind.SEE_TAG, classDoc2, memberDoc, content.isEmpty() ? content2 : content, false);
    }

    private Content plainOrCode(boolean bl, Content content) {
        return bl || content.isEmpty() ? content : HtmlTree.CODE(content);
    }

    public void addInlineComment(Doc doc, Tag tag, Content content) {
        this.addCommentTags(doc, tag, tag.inlineTags(), false, false, content);
    }

    public void addInlineDeprecatedComment(Doc doc, Tag tag, Content content) {
        this.addCommentTags(doc, tag.inlineTags(), true, false, content);
    }

    public void addSummaryComment(Doc doc, Content content) {
        this.addSummaryComment(doc, doc.firstSentenceTags(), content);
    }

    public void addSummaryComment(Doc doc, Tag[] tagArray, Content content) {
        this.addCommentTags(doc, tagArray, false, true, content);
    }

    public void addSummaryDeprecatedComment(Doc doc, Tag tag, Content content) {
        this.addCommentTags(doc, tag.firstSentenceTags(), true, true, content);
    }

    public void addInlineComment(Doc doc, Content content) {
        this.addCommentTags(doc, doc.inlineTags(), false, false, content);
    }

    private void addCommentTags(Doc doc, Tag[] tagArray, boolean bl, boolean bl2, Content content) {
        this.addCommentTags(doc, null, tagArray, bl, bl2, content);
    }

    private void addCommentTags(Doc doc, Tag tag, Tag[] tagArray, boolean bl, boolean bl2, Content content) {
        if (this.configuration.nocomment) {
            return;
        }
        Content content2 = this.commentTagsToContent(null, doc, tagArray, bl2);
        if (bl) {
            HtmlTree htmlTree = HtmlTree.SPAN(HtmlStyle.deprecationComment, content2);
            HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.block, htmlTree);
            content.addContent(htmlTree2);
        } else {
            HtmlTree htmlTree = HtmlTree.DIV(HtmlStyle.block, content2);
            content.addContent(htmlTree);
        }
        if (tagArray.length == 0) {
            content.addContent(this.getSpace());
        }
    }

    public Content commentTagsToContent(Tag tag, Doc doc, Tag[] tagArray, boolean bl) {
        ContentBuilder contentBuilder = new ContentBuilder();
        boolean bl2 = false;
        this.configuration.tagletManager.checkTags(doc, tagArray, true);
        for (int i = 0; i < tagArray.length; ++i) {
            Tag tag2 = tagArray[i];
            String string = tag2.name();
            if (tag2 instanceof SeeTag) {
                ((Content)contentBuilder).addContent(this.seeTagToContent((SeeTag)tag2));
                continue;
            }
            if (!string.equals("Text")) {
                Content content;
                boolean bl3 = ((Content)contentBuilder).isEmpty();
                if (this.configuration.docrootparent.length() > 0 && tag2.name().equals("@docRoot") && tagArray[i + 1].text().startsWith("/..")) {
                    bl2 = true;
                    content = new StringContent(this.configuration.docrootparent);
                } else {
                    content = TagletWriter.getInlineTagOuput(this.configuration.tagletManager, tag, tag2, this.getTagletWriterInstance(bl));
                }
                if (content != null) {
                    ((Content)contentBuilder).addContent(content);
                }
                if (!bl3 || !bl || !tag2.name().equals("@inheritDoc") || ((Content)contentBuilder).isEmpty()) continue;
                break;
            }
            String string2 = tag2.text();
            if (bl2) {
                string2 = string2.replaceFirst("/..", "");
                bl2 = false;
            }
            string2 = this.redirectRelativeLinks(tag2.holder(), string2);
            string2 = this.replaceDocRootDir(string2);
            if (bl) {
                string2 = HtmlDocletWriter.removeNonInlineHtmlTags(string2);
            }
            string2 = Util.replaceTabs(this.configuration, string2);
            string2 = Util.normalizeNewlines(string2);
            ((Content)contentBuilder).addContent(new RawHtml(string2));
        }
        return contentBuilder;
    }

    private boolean shouldNotRedirectRelativeLinks() {
        return this instanceof AnnotationTypeWriter || this instanceof ClassWriter || this instanceof PackageSummaryWriter;
    }

    private String redirectRelativeLinks(Doc doc, String string) {
        DocPath docPath;
        if (doc == null || this.shouldNotRedirectRelativeLinks()) {
            return string;
        }
        if (doc instanceof ClassDoc) {
            docPath = DocPath.forPackage(((ClassDoc)doc).containingPackage());
        } else if (doc instanceof MemberDoc) {
            docPath = DocPath.forPackage(((MemberDoc)doc).containingPackage());
        } else if (doc instanceof PackageDoc) {
            docPath = DocPath.forPackage((PackageDoc)doc);
        } else {
            return string;
        }
        int n = string.toLowerCase().indexOf("<a");
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            while (n >= 0) {
                String string2;
                if (stringBuilder.length() > n + 2 && !Character.isWhitespace(stringBuilder.charAt(n + 2))) {
                    n = stringBuilder.toString().toLowerCase().indexOf("<a", n + 1);
                    continue;
                }
                n = stringBuilder.indexOf("=", n) + 1;
                int n2 = stringBuilder.indexOf(">", n + 1);
                if (n == 0) {
                    this.configuration.root.printWarning(doc.position(), this.configuration.getText("doclet.malformed_html_link_tag", string));
                    break;
                }
                if (n2 == -1) break;
                if (stringBuilder.substring(n, n2).indexOf("\"") != -1) {
                    n = stringBuilder.indexOf("\"", n) + 1;
                    n2 = stringBuilder.indexOf("\"", n + 1);
                    if (n == 0 || n2 == -1) break;
                }
                if (!((string2 = stringBuilder.substring(n, n2)).toLowerCase().startsWith("mailto:") || string2.toLowerCase().startsWith("http:") || string2.toLowerCase().startsWith("https:") || string2.toLowerCase().startsWith("file:"))) {
                    string2 = "{@" + new DocRootTaglet().getName() + "}/" + docPath.resolve(string2).getPath();
                    stringBuilder.replace(n, n2, string2);
                }
                n = stringBuilder.toString().toLowerCase().indexOf("<a", n + 1);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static String removeNonInlineHtmlTags(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = string.indexOf(60);
        if (n4 < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        block0: while (n4 != -1 && (n = n4 + 1) != n2) {
            char c = string.charAt(n);
            if (c == '/') {
                if (++n == n2) break;
                c = string.charAt(n);
            }
            int n5 = n;
            while (HtmlDocletWriter.isHtmlTagLetterOrDigit(c)) {
                if (++n == n2) break block0;
                c = string.charAt(n);
            }
            if (c == '>' && blockTags.contains(string.substring(n5, n).toLowerCase())) {
                stringBuilder.append(string, n3, n4);
                n3 = n + 1;
            }
            n4 = string.indexOf(60, n);
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    private static boolean isHtmlTagLetterOrDigit(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '1' <= c && c <= '6';
    }

    public HtmlTree getStyleSheetProperties() {
        Object object;
        DocPath docPath;
        String string = this.configuration.stylesheetfile;
        if (string.isEmpty()) {
            docPath = DocPaths.STYLESHEET;
        } else {
            object = DocFile.createFileForInput(this.configuration, string);
            docPath = DocPath.create(((DocFile)object).getName());
        }
        object = HtmlTree.LINK("stylesheet", "text/css", this.pathToRoot.resolve(docPath).getPath(), "Style");
        return object;
    }

    public HtmlTree getScriptProperties() {
        HtmlTree htmlTree = HtmlTree.SCRIPT("text/javascript", this.pathToRoot.resolve(DocPaths.JAVASCRIPT).getPath());
        return htmlTree;
    }

    public boolean isCoreClass(ClassDoc classDoc) {
        return classDoc.containingClass() == null || classDoc.isStatic();
    }

    public void addAnnotationInfo(PackageDoc packageDoc, Content content) {
        this.addAnnotationInfo(packageDoc, packageDoc.annotations(), content);
    }

    public void addReceiverAnnotationInfo(ExecutableMemberDoc executableMemberDoc, AnnotationDesc[] annotationDescArray, Content content) {
        this.addAnnotationInfo(0, executableMemberDoc, annotationDescArray, false, content);
    }

    public void addAnnotationInfo(ProgramElementDoc programElementDoc, Content content) {
        this.addAnnotationInfo(programElementDoc, programElementDoc.annotations(), content);
    }

    public boolean addAnnotationInfo(int n, Doc doc, Parameter parameter, Content content) {
        return this.addAnnotationInfo(n, doc, parameter.annotations(), false, content);
    }

    private void addAnnotationInfo(Doc doc, AnnotationDesc[] annotationDescArray, Content content) {
        this.addAnnotationInfo(0, doc, annotationDescArray, true, content);
    }

    private boolean addAnnotationInfo(int n, Doc doc, AnnotationDesc[] annotationDescArray, boolean bl, Content content) {
        List<Content> list = this.getAnnotations(n, annotationDescArray, bl);
        String string = "";
        if (list.isEmpty()) {
            return false;
        }
        for (Content content2 : list) {
            content.addContent(string);
            content.addContent(content2);
            string = " ";
        }
        return true;
    }

    private List<Content> getAnnotations(int n, AnnotationDesc[] annotationDescArray, boolean bl) {
        return this.getAnnotations(n, annotationDescArray, bl, true);
    }

    public List<Content> getAnnotations(int n, AnnotationDesc[] annotationDescArray, boolean bl, boolean bl2) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        for (int i = 0; i < annotationDescArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            AnnotationTypeDoc annotationTypeDoc = annotationDescArray[i].annotationType();
            if (!Util.isDocumentedAnnotation(annotationTypeDoc) && !this.isAnnotationDocumented && !this.isContainerDocumented) continue;
            ContentBuilder contentBuilder = new ContentBuilder();
            this.isAnnotationDocumented = false;
            LinkInfoImpl linkInfoImpl = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.ANNOTATION, annotationTypeDoc);
            AnnotationDesc.ElementValuePair[] elementValuePairArray = annotationDescArray[i].elementValues();
            if (annotationDescArray[i].isSynthesized()) {
                for (int j = 0; j < elementValuePairArray.length; ++j) {
                    object4 = elementValuePairArray[j].value();
                    object3 = new ArrayList<AnnotationValue>();
                    if (object4.value() instanceof AnnotationValue[]) {
                        object2 = (AnnotationValue[])object4.value();
                        object3.addAll(Arrays.asList(object2));
                    } else {
                        object3.add(object4);
                    }
                    object2 = "";
                    object = object3.iterator();
                    while (object.hasNext()) {
                        AnnotationValue annotationValue = (AnnotationValue)object.next();
                        contentBuilder.addContent((String)object2);
                        contentBuilder.addContent(this.annotationValueToContent(annotationValue));
                        object2 = " ";
                    }
                }
            } else if (this.isAnnotationArray(elementValuePairArray)) {
                if (elementValuePairArray.length == 1 && this.isAnnotationDocumented) {
                    AnnotationValue[] annotationValueArray = (AnnotationValue[])elementValuePairArray[0].value().value();
                    object4 = new ArrayList();
                    object4.addAll(Arrays.asList(annotationValueArray));
                    object3 = "";
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        object = (AnnotationValue)object2.next();
                        contentBuilder.addContent((String)object3);
                        contentBuilder.addContent(this.annotationValueToContent((AnnotationValue)object));
                        object3 = " ";
                    }
                } else {
                    this.addAnnotations(annotationTypeDoc, linkInfoImpl, contentBuilder, elementValuePairArray, n, false);
                }
            } else {
                this.addAnnotations(annotationTypeDoc, linkInfoImpl, contentBuilder, elementValuePairArray, n, bl);
            }
            contentBuilder.addContent(bl ? DocletConstants.NL : "");
            arrayList.add(contentBuilder);
        }
        return arrayList;
    }

    private void addAnnotations(AnnotationTypeDoc annotationTypeDoc, LinkInfoImpl linkInfoImpl, ContentBuilder contentBuilder, AnnotationDesc.ElementValuePair[] elementValuePairArray, int n, boolean bl) {
        linkInfoImpl.label = new StringContent("@" + annotationTypeDoc.name());
        contentBuilder.addContent(this.getLink(linkInfoImpl));
        if (elementValuePairArray.length > 0) {
            contentBuilder.addContent("(");
            for (int i = 0; i < elementValuePairArray.length; ++i) {
                Object object;
                if (i > 0) {
                    contentBuilder.addContent(",");
                    if (bl) {
                        contentBuilder.addContent(DocletConstants.NL);
                        int n2 = annotationTypeDoc.name().length() + 2;
                        for (int j = 0; j < n2 + n; ++j) {
                            contentBuilder.addContent(" ");
                        }
                    }
                }
                contentBuilder.addContent(this.getDocLink(LinkInfoImpl.Kind.ANNOTATION, elementValuePairArray[i].element(), elementValuePairArray[i].element().name(), false));
                contentBuilder.addContent("=");
                AnnotationValue annotationValue = elementValuePairArray[i].value();
                ArrayList<AnnotationValue> arrayList = new ArrayList<AnnotationValue>();
                if (annotationValue.value() instanceof AnnotationValue[]) {
                    object = (AnnotationValue[])annotationValue.value();
                    arrayList.addAll(Arrays.asList(object));
                } else {
                    arrayList.add(annotationValue);
                }
                contentBuilder.addContent(arrayList.size() == 1 ? "" : "{");
                object = "";
                for (AnnotationValue annotationValue2 : arrayList) {
                    contentBuilder.addContent((String)object);
                    contentBuilder.addContent(this.annotationValueToContent(annotationValue2));
                    object = ",";
                }
                contentBuilder.addContent(arrayList.size() == 1 ? "" : "}");
                this.isContainerDocumented = false;
            }
            contentBuilder.addContent(")");
        }
    }

    private boolean isAnnotationArray(AnnotationDesc.ElementValuePair[] elementValuePairArray) {
        for (int i = 0; i < elementValuePairArray.length; ++i) {
            AnnotationValue[] annotationValueArray;
            AnnotationValue annotationValue = elementValuePairArray[i].value();
            if (!(annotationValue.value() instanceof AnnotationValue[]) || (annotationValueArray = (AnnotationValue[])annotationValue.value()).length <= 1 || !(annotationValueArray[0].value() instanceof AnnotationDesc)) continue;
            AnnotationTypeDoc annotationTypeDoc = ((AnnotationDesc)annotationValueArray[0].value()).annotationType();
            this.isContainerDocumented = true;
            if (Util.isDocumentedAnnotation(annotationTypeDoc)) {
                this.isAnnotationDocumented = true;
            }
            return true;
        }
        return false;
    }

    private Content annotationValueToContent(AnnotationValue annotationValue) {
        if (annotationValue.value() instanceof Type) {
            Type type = (Type)annotationValue.value();
            if (type.asClassDoc() != null) {
                LinkInfoImpl linkInfoImpl = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.ANNOTATION, type);
                linkInfoImpl.label = new StringContent((type.asClassDoc().isIncluded() ? type.typeName() : type.qualifiedTypeName()) + type.dimension() + ".class");
                return this.getLink(linkInfoImpl);
            }
            return new StringContent(type.typeName() + type.dimension() + ".class");
        }
        if (annotationValue.value() instanceof AnnotationDesc) {
            List<Content> list = this.getAnnotations(0, new AnnotationDesc[]{(AnnotationDesc)annotationValue.value()}, false);
            ContentBuilder contentBuilder = new ContentBuilder();
            for (Content content : list) {
                contentBuilder.addContent(content);
            }
            return contentBuilder;
        }
        if (annotationValue.value() instanceof MemberDoc) {
            return this.getDocLink(LinkInfoImpl.Kind.ANNOTATION, (MemberDoc)annotationValue.value(), ((MemberDoc)annotationValue.value()).name(), false);
        }
        return new StringContent(annotationValue.toString());
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    static {
        for (HtmlTag htmlTag : HtmlTag.values()) {
            if (htmlTag.blockType != HtmlTag.BlockType.BLOCK) continue;
            blockTags.add(htmlTag.value);
        }
    }
}

