/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.tools.doclets.formats.html.AbstractMemberWriter;
import com.sun.tools.doclets.formats.html.AnnotationTypeOptionalMemberWriterImpl;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.ConstructorWriterImpl;
import com.sun.tools.doclets.formats.html.EnumConstantWriterImpl;
import com.sun.tools.doclets.formats.html.FieldWriterImpl;
import com.sun.tools.doclets.formats.html.MethodWriterImpl;
import com.sun.tools.doclets.formats.html.NestedClassWriterImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DeprecatedAPIListBuilder;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class DeprecatedListWriter
extends SubWriterHolderWriter {
    private static final String[] ANCHORS = new String[]{"package", "interface", "class", "enum", "exception", "error", "annotation.type", "field", "method", "constructor", "enum.constant", "annotation.type.member"};
    private static final String[] HEADING_KEYS = new String[]{"doclet.Deprecated_Packages", "doclet.Deprecated_Interfaces", "doclet.Deprecated_Classes", "doclet.Deprecated_Enums", "doclet.Deprecated_Exceptions", "doclet.Deprecated_Errors", "doclet.Deprecated_Annotation_Types", "doclet.Deprecated_Fields", "doclet.Deprecated_Methods", "doclet.Deprecated_Constructors", "doclet.Deprecated_Enum_Constants", "doclet.Deprecated_Annotation_Type_Members"};
    private static final String[] SUMMARY_KEYS = new String[]{"doclet.deprecated_packages", "doclet.deprecated_interfaces", "doclet.deprecated_classes", "doclet.deprecated_enums", "doclet.deprecated_exceptions", "doclet.deprecated_errors", "doclet.deprecated_annotation_types", "doclet.deprecated_fields", "doclet.deprecated_methods", "doclet.deprecated_constructors", "doclet.deprecated_enum_constants", "doclet.deprecated_annotation_type_members"};
    private static final String[] HEADER_KEYS = new String[]{"doclet.Package", "doclet.Interface", "doclet.Class", "doclet.Enum", "doclet.Exceptions", "doclet.Errors", "doclet.AnnotationType", "doclet.Field", "doclet.Method", "doclet.Constructor", "doclet.Enum_Constant", "doclet.Annotation_Type_Member"};
    private AbstractMemberWriter[] writers;
    private ConfigurationImpl configuration;

    public DeprecatedListWriter(ConfigurationImpl configurationImpl, DocPath docPath) throws IOException {
        super(configurationImpl, docPath);
        this.configuration = configurationImpl;
        NestedClassWriterImpl nestedClassWriterImpl = new NestedClassWriterImpl(this);
        this.writers = new AbstractMemberWriter[]{nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, nestedClassWriterImpl, new FieldWriterImpl(this), new MethodWriterImpl(this), new ConstructorWriterImpl(this), new EnumConstantWriterImpl(this), new AnnotationTypeOptionalMemberWriterImpl((SubWriterHolderWriter)this, null)};
    }

    public static void generate(ConfigurationImpl configurationImpl) {
        DocPath docPath = DocPaths.DEPRECATED_LIST;
        try {
            DeprecatedListWriter deprecatedListWriter = new DeprecatedListWriter(configurationImpl, docPath);
            deprecatedListWriter.generateDeprecatedListFile(new DeprecatedAPIListBuilder(configurationImpl));
            deprecatedListWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), docPath);
            throw new DocletAbortException(iOException);
        }
    }

    protected void generateDeprecatedListFile(DeprecatedAPIListBuilder deprecatedAPIListBuilder) throws IOException {
        Content content = this.getHeader();
        content.addContent(this.getContentsList(deprecatedAPIListBuilder));
        String[] stringArray = new String[1];
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV);
        htmlTree.addStyle(HtmlStyle.contentContainer);
        for (int i = 0; i < 12; ++i) {
            if (!deprecatedAPIListBuilder.hasDocumentation(i)) continue;
            this.addAnchor(deprecatedAPIListBuilder, i, htmlTree);
            String string = this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText(HEADING_KEYS[i]), this.configuration.getText(SUMMARY_KEYS[i]));
            stringArray[0] = this.configuration.getText("doclet.0_and_1", this.configuration.getText(HEADER_KEYS[i]), this.configuration.getText("doclet.Description"));
            if (i == 0) {
                this.addPackageDeprecatedAPI(deprecatedAPIListBuilder.getList(i), HEADING_KEYS[i], string, stringArray, htmlTree);
                continue;
            }
            this.writers[i - 1].addDeprecatedAPI(deprecatedAPIListBuilder.getList(i), HEADING_KEYS[i], string, stringArray, htmlTree);
        }
        content.addContent(htmlTree);
        this.addNavLinks(false, content);
        this.addBottom(content);
        this.printHtmlDocument(null, true, content);
    }

    private void addIndexLink(DeprecatedAPIListBuilder deprecatedAPIListBuilder, int n, Content content) {
        if (deprecatedAPIListBuilder.hasDocumentation(n)) {
            HtmlTree htmlTree = HtmlTree.LI(this.getHyperLink(ANCHORS[n], this.getResource(HEADING_KEYS[n])));
            content.addContent(htmlTree);
        }
    }

    public Content getContentsList(DeprecatedAPIListBuilder deprecatedAPIListBuilder) {
        Content content = this.getResource("doclet.Deprecated_API");
        HtmlTree htmlTree = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, true, HtmlStyle.title, content);
        HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.header, htmlTree);
        Content content2 = this.getResource("doclet.Contents");
        ((Content)htmlTree2).addContent(HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, content2));
        HtmlTree htmlTree3 = new HtmlTree(HtmlTag.UL);
        for (int i = 0; i < 12; ++i) {
            this.addIndexLink(deprecatedAPIListBuilder, i, htmlTree3);
        }
        ((Content)htmlTree2).addContent(htmlTree3);
        return htmlTree2;
    }

    private void addAnchor(DeprecatedAPIListBuilder deprecatedAPIListBuilder, int n, Content content) {
        if (deprecatedAPIListBuilder.hasDocumentation(n)) {
            content.addContent(this.getMarkerAnchor(ANCHORS[n]));
        }
    }

    public Content getHeader() {
        String string = this.configuration.getText("doclet.Window_Deprecated_List");
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        return htmlTree;
    }

    @Override
    protected Content getNavLinkDeprecated() {
        HtmlTree htmlTree = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.deprecatedLabel);
        return htmlTree;
    }
}

