/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTreeWriter
extends HtmlDocletWriter {
    protected final ClassTree classtree;
    private static final String LI_CIRCLE = "circle";

    protected AbstractTreeWriter(ConfigurationImpl configurationImpl, DocPath docPath, ClassTree classTree) throws IOException {
        super(configurationImpl, docPath);
        this.classtree = classTree;
    }

    protected void addLevelInfo(ClassDoc classDoc, List<ClassDoc> list, boolean bl, Content content) {
        int n = list.size();
        if (n > 0) {
            HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
            for (int i = 0; i < n; ++i) {
                ClassDoc classDoc2 = list.get(i);
                HtmlTree htmlTree2 = new HtmlTree(HtmlTag.LI);
                htmlTree2.addAttr(HtmlAttr.TYPE, LI_CIRCLE);
                this.addPartialInfo(classDoc2, htmlTree2);
                this.addExtendsImplements(classDoc, classDoc2, htmlTree2);
                this.addLevelInfo(classDoc2, this.classtree.subs(classDoc2, bl), bl, htmlTree2);
                ((Content)htmlTree).addContent(htmlTree2);
            }
            content.addContent(htmlTree);
        }
    }

    protected void addTree(List<ClassDoc> list, String string, Content content) {
        if (list.size() > 0) {
            ClassDoc classDoc = list.get(0);
            Content content2 = this.getResource(string);
            content.addContent(HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, content2));
            this.addLevelInfo(!classDoc.isInterface() ? classDoc : null, list, list == this.classtree.baseEnums(), content);
        }
    }

    protected void addExtendsImplements(ClassDoc classDoc, ClassDoc classDoc2, Content content) {
        Object[] objectArray = classDoc2.interfaces();
        if (objectArray.length > (classDoc2.isInterface() ? 1 : 0)) {
            Arrays.sort(objectArray);
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (classDoc == objectArray[i] || !objectArray[i].isPublic() && !Util.isLinkable((ClassDoc)objectArray[i], this.configuration)) continue;
                if (n == 0) {
                    if (classDoc2.isInterface()) {
                        content.addContent(" (");
                        content.addContent(this.getResource("doclet.also"));
                        content.addContent(" extends ");
                    } else {
                        content.addContent(" (implements ");
                    }
                } else {
                    content.addContent(", ");
                }
                this.addPreQualifiedClassLink(LinkInfoImpl.Kind.TREE, (ClassDoc)objectArray[i], content);
                ++n;
            }
            if (n > 0) {
                content.addContent(")");
            }
        }
    }

    protected void addPartialInfo(ClassDoc classDoc, Content content) {
        this.addPreQualifiedStrongClassLink(LinkInfoImpl.Kind.TREE, classDoc, content);
    }

    @Override
    protected Content getNavLinkTree() {
        HtmlTree htmlTree = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.treeLabel);
        return htmlTree;
    }
}

