/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Opcode;

public class Instruction {
    private byte[] bytes;
    private int pc;

    public Instruction(byte[] byArray, int n) {
        this.bytes = byArray;
        this.pc = n;
    }

    public int getPC() {
        return this.pc;
    }

    public int getByte(int n) {
        return this.bytes[this.pc + n];
    }

    public int getUnsignedByte(int n) {
        return this.getByte(n) & 0xFF;
    }

    public int getShort(int n) {
        return this.getByte(n) << 8 | this.getUnsignedByte(n + 1);
    }

    public int getUnsignedShort(int n) {
        return this.getShort(n) & 0xFFFF;
    }

    public int getInt(int n) {
        return this.getShort(n) << 16 | this.getUnsignedShort(n + 2);
    }

    public Opcode getOpcode() {
        int n = this.getUnsignedByte(0);
        switch (n) {
            case 196: 
            case 254: 
            case 255: {
                return Opcode.get(n, this.getUnsignedByte(1));
            }
        }
        return Opcode.get(n);
    }

    public String getMnemonic() {
        Opcode opcode = this.getOpcode();
        if (opcode == null) {
            return "bytecode " + this.getUnsignedByte(0);
        }
        return opcode.toString().toLowerCase();
    }

    public int length() {
        Opcode opcode = this.getOpcode();
        if (opcode == null) {
            return 1;
        }
        switch (opcode) {
            case TABLESWITCH: {
                int n = Instruction.align(this.pc + 1) - this.pc;
                int n2 = this.getInt(n + 4);
                int n3 = this.getInt(n + 8);
                return n + 12 + 4 * (n3 - n2 + 1);
            }
            case LOOKUPSWITCH: {
                int n = Instruction.align(this.pc + 1) - this.pc;
                int n4 = this.getInt(n + 4);
                return n + 8 + 8 * n4;
            }
        }
        return opcode.kind.length;
    }

    public Kind getKind() {
        Opcode opcode = this.getOpcode();
        return opcode != null ? opcode.kind : Kind.UNKNOWN;
    }

    public <R, P> R accept(KindVisitor<R, P> kindVisitor, P p) {
        switch (this.getKind()) {
            case NO_OPERANDS: {
                return kindVisitor.visitNoOperands(this, p);
            }
            case ATYPE: {
                return kindVisitor.visitArrayType(this, TypeKind.get(this.getUnsignedByte(1)), p);
            }
            case BRANCH: {
                return kindVisitor.visitBranch(this, this.getShort(1), p);
            }
            case BRANCH_W: {
                return kindVisitor.visitBranch(this, this.getInt(1), p);
            }
            case BYTE: {
                return kindVisitor.visitValue(this, this.getByte(1), p);
            }
            case CPREF: {
                return kindVisitor.visitConstantPoolRef(this, this.getUnsignedByte(1), p);
            }
            case CPREF_W: {
                return kindVisitor.visitConstantPoolRef(this, this.getUnsignedShort(1), p);
            }
            case CPREF_W_UBYTE: 
            case CPREF_W_UBYTE_ZERO: {
                return kindVisitor.visitConstantPoolRefAndValue(this, this.getUnsignedShort(1), this.getUnsignedByte(3), p);
            }
            case DYNAMIC: {
                switch (this.getOpcode()) {
                    case TABLESWITCH: {
                        int n = Instruction.align(this.pc + 1) - this.pc;
                        int n2 = this.getInt(n);
                        int n3 = this.getInt(n + 4);
                        int n4 = this.getInt(n + 8);
                        int[] nArray = new int[n4 - n3 + 1];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = this.getInt(n + 12 + 4 * i);
                        }
                        return kindVisitor.visitTableSwitch(this, n2, n3, n4, nArray, p);
                    }
                    case LOOKUPSWITCH: {
                        int n = Instruction.align(this.pc + 1) - this.pc;
                        int n5 = this.getInt(n);
                        int n6 = this.getInt(n + 4);
                        int[] nArray = new int[n6];
                        int[] nArray2 = new int[n6];
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = this.getInt(n + 8 + i * 8);
                            nArray2[i] = this.getInt(n + 12 + i * 8);
                        }
                        return kindVisitor.visitLookupSwitch(this, n5, n6, nArray, nArray2, p);
                    }
                }
                throw new IllegalStateException();
            }
            case LOCAL: {
                return kindVisitor.visitLocal(this, this.getUnsignedByte(1), p);
            }
            case LOCAL_BYTE: {
                return kindVisitor.visitLocalAndValue(this, this.getUnsignedByte(1), this.getByte(2), p);
            }
            case SHORT: {
                return kindVisitor.visitValue(this, this.getShort(1), p);
            }
            case WIDE_NO_OPERANDS: {
                return kindVisitor.visitNoOperands(this, p);
            }
            case WIDE_LOCAL: {
                return kindVisitor.visitLocal(this, this.getUnsignedShort(2), p);
            }
            case WIDE_CPREF_W: {
                return kindVisitor.visitConstantPoolRef(this, this.getUnsignedShort(2), p);
            }
            case WIDE_CPREF_W_SHORT: {
                return kindVisitor.visitConstantPoolRefAndValue(this, this.getUnsignedShort(2), this.getUnsignedByte(4), p);
            }
            case WIDE_LOCAL_SHORT: {
                return kindVisitor.visitLocalAndValue(this, this.getUnsignedShort(2), this.getShort(4), p);
            }
            case UNKNOWN: {
                return kindVisitor.visitUnknown(this, p);
            }
        }
        throw new IllegalStateException();
    }

    private static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public static enum TypeKind {
        T_BOOLEAN(4, "boolean"),
        T_CHAR(5, "char"),
        T_FLOAT(6, "float"),
        T_DOUBLE(7, "double"),
        T_BYTE(8, "byte"),
        T_SHORT(9, "short"),
        T_INT(10, "int"),
        T_LONG(11, "long");

        public final int value;
        public final String name;

        private TypeKind(int n2, String string2) {
            this.value = n2;
            this.name = string2;
        }

        public static TypeKind get(int n) {
            switch (n) {
                case 4: {
                    return T_BOOLEAN;
                }
                case 5: {
                    return T_CHAR;
                }
                case 6: {
                    return T_FLOAT;
                }
                case 7: {
                    return T_DOUBLE;
                }
                case 8: {
                    return T_BYTE;
                }
                case 9: {
                    return T_SHORT;
                }
                case 10: {
                    return T_INT;
                }
                case 11: {
                    return T_LONG;
                }
            }
            return null;
        }
    }

    public static interface KindVisitor<R, P> {
        public R visitNoOperands(Instruction var1, P var2);

        public R visitArrayType(Instruction var1, TypeKind var2, P var3);

        public R visitBranch(Instruction var1, int var2, P var3);

        public R visitConstantPoolRef(Instruction var1, int var2, P var3);

        public R visitConstantPoolRefAndValue(Instruction var1, int var2, int var3, P var4);

        public R visitLocal(Instruction var1, int var2, P var3);

        public R visitLocalAndValue(Instruction var1, int var2, int var3, P var4);

        public R visitLookupSwitch(Instruction var1, int var2, int var3, int[] var4, int[] var5, P var6);

        public R visitTableSwitch(Instruction var1, int var2, int var3, int var4, int[] var5, P var6);

        public R visitValue(Instruction var1, int var2, P var3);

        public R visitUnknown(Instruction var1, P var2);
    }

    public static enum Kind {
        NO_OPERANDS(1),
        ATYPE(2),
        BRANCH(3),
        BRANCH_W(5),
        BYTE(2),
        CPREF(2),
        CPREF_W(3),
        CPREF_W_UBYTE(4),
        CPREF_W_UBYTE_ZERO(5),
        DYNAMIC(-1),
        LOCAL(2),
        LOCAL_BYTE(3),
        SHORT(3),
        WIDE_NO_OPERANDS(2),
        WIDE_LOCAL(4),
        WIDE_CPREF_W(4),
        WIDE_CPREF_W_SHORT(6),
        WIDE_LOCAL_SHORT(6),
        UNKNOWN(1);

        public final int length;

        private Kind(int n2) {
            this.length = n2;
        }
    }
}

