/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.authentication;

import io.apimatic.coreinterfaces.authentication.Authentication;
import java.util.HashMap;
import java.util.Map;

public abstract class AuthCredential
extends Authentication {
    private Map<String, String> authParams = new HashMap<String, String>();

    public AuthCredential(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public Map<String, String> getAuthParams() {
        return this.authParams;
    }

    public void validate() {
        boolean hasNullKeyOrValue = this.authParams.entrySet().stream().anyMatch(entry -> entry.getKey() == null || entry.getKey() == "" || entry.getValue() == null || entry.getValue() == "");
        if (hasNullKeyOrValue) {
            this.setErrorMessage("[Auth key and value cannot be null]");
            this.setValidity(false);
            return;
        }
        this.setValidity(true);
    }
}

