/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.visitors;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.core.visitors.Traverser;
import io.apicurio.datamodels.openapi.models.IOasPropertySchema;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.models.OasXML;
import io.apicurio.datamodels.openapi.visitors.IOasVisitor;
import java.util.List;

public class OasTraverser
extends Traverser
implements IOasVisitor {
    public OasTraverser(IVisitor visitor) {
        super(visitor);
    }

    @Override
    protected void traverseDocument(Document node) {
        OasDocument doc = (OasDocument)node;
        super.traverseDocument(node);
        this.traverseIfNotNull(doc.paths);
        this.traverseCollection(doc.security);
    }

    @Override
    public void visitPaths(OasPaths node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        node.accept(this.visitor);
        this.traversePathItem(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    protected void traversePathItem(OasPathItem node) {
        this.traverseIfNotNull(node.get);
        this.traverseIfNotNull(node.put);
        this.traverseIfNotNull(node.post);
        this.traverseIfNotNull(node.delete);
        this.traverseIfNotNull(node.options);
        this.traverseIfNotNull(node.head);
        this.traverseIfNotNull(node.patch);
        this.traverseCollection(node.parameters);
    }

    @Override
    public void visitResponse(OasResponse node) {
        node.accept(this.visitor);
        this.traverseResponse(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    protected void traverseResponse(OasResponse node) {
    }

    @Override
    public void visitResponses(OasResponses node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitXML(OasXML node) {
        node.accept(this.visitor);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitAllOfSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitItemsSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitPropertySchema(IOasPropertySchema node) {
        this.visitSchema((Schema)((Object)node));
    }

    @Override
    protected void traverseSchema(Schema node) {
        super.traverseSchema(node);
        OasSchema schema = (OasSchema)node;
        if (NodeCompat.isList(schema.items)) {
            this.traverseCollection((List)schema.items);
        } else {
            this.traverseIfNotNull((Node)schema.items);
        }
        this.traverseCollection(schema.allOf);
        this.traverseCollection(schema.getProperties());
        if (NodeCompat.isNode(schema.additionalProperties)) {
            this.traverseIfNotNull((Node)schema.additionalProperties);
        }
        this.traverseIfNotNull(schema.xml);
        this.traverseIfNotNull(schema.externalDocs);
    }

    @Override
    public void visitHeader(OasHeader node) {
        node.accept(this.visitor);
        this.traverseHeader(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    protected void traverseHeader(OasHeader node) {
    }

    @Override
    public void visitResponseDefinition(IDefinition node) {
        this.visitResponse((OasResponse)((Object)node));
    }

    @Override
    protected void traverseOperation(Operation node) {
        OasOperation operation = (OasOperation)node;
        this.traverseCollection(operation.parameters);
        this.traverseIfNotNull(operation.responses);
        this.traverseCollection(operation.security);
        super.traverseOperation(node);
    }
}

