/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v2.visitors;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v2.models.Oas20Definitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Example;
import io.apicurio.datamodels.openapi.v2.models.Oas20Header;
import io.apicurio.datamodels.openapi.v2.models.Oas20Headers;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20ParameterDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Scopes;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;
import io.apicurio.datamodels.openapi.visitors.OasTraverser;

public class Oas20Traverser
extends OasTraverser
implements IOas20Visitor {
    public Oas20Traverser(IOas20Visitor visitor) {
        super(visitor);
    }

    @Override
    protected void traverseDocument(Document node) {
        super.traverseDocument(node);
        Oas20Document doc = (Oas20Document)node;
        this.traverseIfNotNull(doc.definitions);
        this.traverseIfNotNull(doc.parameters);
        this.traverseIfNotNull(doc.responses);
        this.traverseIfNotNull(doc.securityDefinitions);
    }

    @Override
    protected void traverseParameter(Parameter node) {
        super.traverseParameter(node);
        Oas20Parameter param = (Oas20Parameter)node;
        this.traverseIfNotNull(param.items);
    }

    @Override
    public void visitItems(Oas20Items node) {
        node.accept(this.visitor);
        this.traverseIfNotNull(node.items);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitScopes(Oas20Scopes node) {
        node.accept(this.visitor);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitSecurityDefinitions(Oas20SecurityDefinitions node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        Oas20SecurityScheme node20 = (Oas20SecurityScheme)node;
        node.accept(this.visitor);
        this.traverseIfNotNull(node20.scopes);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitDefinitions(Oas20Definitions node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitParameterDefinitions(Oas20ParameterDefinitions node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseValidationProblems(node);
    }

    @Override
    protected void traverseHeader(OasHeader node) {
        Oas20Header header = (Oas20Header)node;
        this.traverseIfNotNull(header.items);
        super.traverseHeader(node);
    }

    @Override
    public void visitExample(Oas20Example node) {
        node.accept(this.visitor);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitHeaders(Oas20Headers node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitResponseDefinitions(Oas20ResponseDefinitions node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseValidationProblems(node);
    }

    @Override
    protected void traverseResponse(OasResponse node) {
        Oas20Response response = (Oas20Response)node;
        this.traverseIfNotNull(response.headers);
        this.traverseIfNotNull(response.schema);
        this.traverseIfNotNull(response.examples);
        super.traverseResponse(node);
    }
}

