/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.commands.NewSchemaDefinitionCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.factories.OasSchemaFactory;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;

public class NewSchemaDefinitionCommand_20
extends NewSchemaDefinitionCommand {
    public boolean _nullDefinitions;

    NewSchemaDefinitionCommand_20() {
    }

    NewSchemaDefinitionCommand_20(String definitionName, Object example, String description) {
        this._newDefinitionName = definitionName;
        this._newDefinitionExample = example;
        this._newDefinitionDescription = description;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewDefinitionCommand] Executing.", new Object[0]);
        Oas20Document doc20 = (Oas20Document)document;
        if (this.isNullOrUndefined(doc20.definitions)) {
            doc20.definitions = doc20.createDefinitions();
            this._nullDefinitions = true;
        }
        if (this.isNullOrUndefined(doc20.definitions.getDefinition(this._newDefinitionName))) {
            Oas20SchemaDefinition definition;
            if (!this.isNullOrUndefined(this._newDefinitionExample)) {
                definition = (Oas20SchemaDefinition)OasSchemaFactory.createSchemaDefinitionFromExample(doc20, this._newDefinitionName, this._newDefinitionExample);
                definition.example = this._newDefinitionExample;
            } else {
                definition = doc20.definitions.createSchemaDefinition(this._newDefinitionName);
                definition.type = "object";
            }
            if (ModelUtils.isDefined(this._newDefinitionDescription)) {
                definition.description = this._newDefinitionDescription;
            }
            doc20.definitions.addDefinition(this._newDefinitionName, definition);
            this._defExisted = false;
        } else {
            this._defExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewDefinitionCommand] Reverting.", new Object[0]);
        Oas20Document doc20 = (Oas20Document)document;
        if (this._nullDefinitions) {
            doc20.definitions = null;
        }
        if (this._defExisted) {
            return;
        }
        doc20.definitions.removeDefinition(this._newDefinitionName);
    }
}

