/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.test.nodes;

import de.fau.cs.osr.ptk.common.serialization.NodeFactory;
import de.fau.cs.osr.ptk.common.serialization.SimpleNodeFactory;
import de.fau.cs.osr.ptk.common.test.nodes.CtnBody;
import de.fau.cs.osr.ptk.common.test.nodes.CtnDocument;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNode;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNodeList;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNodeWithObjProp;
import de.fau.cs.osr.ptk.common.test.nodes.CtnNodeWithPropAndContent;
import de.fau.cs.osr.ptk.common.test.nodes.CtnSection;
import de.fau.cs.osr.ptk.common.test.nodes.CtnText;
import de.fau.cs.osr.ptk.common.test.nodes.CtnTitle;
import de.fau.cs.osr.ptk.common.test.nodes.CtnUrl;
import java.util.HashMap;
import java.util.Map;

public class CtnFactory
extends SimpleNodeFactory<CtnNode> {
    private static CtnFactory factory = null;
    private final Map<Class<?>, CtnNode> prototypes = new HashMap();
    private final Map<NodeFactory.NamedMemberId, Object> defaultValueImmutables = new HashMap<NodeFactory.NamedMemberId, Object>();

    public static NodeFactory<CtnNode> get() {
        if (factory == null) {
            factory = new CtnFactory();
        }
        return factory;
    }

    public CtnFactory() {
        this.addPrototype(new CtnText());
        this.addPrototype(new CtnNodeList());
        this.addPrototype(new CtnSection());
        this.addPrototype(new CtnDocument());
        this.addPrototype(new CtnUrl());
        this.addPrototype(new CtnNodeWithObjProp());
        this.addPrototype(new CtnNodeWithPropAndContent());
        this.addPrototype(new CtnTitle.CtnTitleImpl(), CtnTitle.class);
        this.addPrototype(new CtnBody.CtnBodyImpl(), CtnBody.class);
        this.addDvi(CtnUrl.class, "protocol", "");
        this.addDvi(CtnSection.class, "body", CtnBody.NO_BODY);
        this.addDvi(CtnSection.class, "title", CtnTitle.NO_TITLE);
        this.addDvi(CtnNodeWithObjProp.class, "prop", null);
        this.addDvi(CtnNodeWithPropAndContent.class, "prop", null);
    }

    private void addPrototype(CtnNode prototype) {
        this.prototypes.put(prototype.getClass(), prototype);
    }

    private void addPrototype(CtnNode prototype, Class<?> clazz) {
        this.prototypes.put(clazz, prototype);
    }

    private void addDvi(Class<?> clazz, String memberName, Object defaultValue) {
        this.defaultValueImmutables.put(new NodeFactory.NamedMemberId(clazz, memberName), defaultValue);
    }

    @Override
    public CtnNode instantiateNode(Class<?> clazz) {
        CtnNode p = this.prototypes.get(clazz);
        try {
            if (p != null) {
                return (CtnNode)p.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return (CtnNode)super.instantiateNode(clazz);
    }

    @Override
    public CtnNode instantiateDefaultChild(NodeFactory.NamedMemberId id, Class<?> type) {
        CtnNode p = (CtnNode)this.defaultValueImmutables.get(id);
        if (p != null) {
            return p;
        }
        if (this.defaultValueImmutables.containsKey(id)) {
            return null;
        }
        return (CtnNode)super.instantiateDefaultChild(id, type);
    }

    @Override
    public Object instantiateDefaultProperty(NodeFactory.NamedMemberId id, Class<?> type) {
        Object p = this.defaultValueImmutables.get(id);
        if (p != null) {
            return p;
        }
        if (this.defaultValueImmutables.containsKey(id)) {
            return null;
        }
        return super.instantiateDefaultProperty(id, type);
    }
}

