/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.comparer;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.comparer.AstComparisonException;
import de.fau.cs.osr.ptk.common.comparer.AstDifference;
import de.fau.cs.osr.ptk.common.comparer.AttributeComparisonException;
import de.fau.cs.osr.ptk.common.comparer.ComparisonOfChildrenFailedException;
import de.fau.cs.osr.ptk.common.comparer.PropertyComparisonException;
import de.fau.cs.osr.utils.ComparisonException;
import de.fau.cs.osr.utils.DeepComparer;
import de.fau.cs.osr.utils.DeepComparerDelegate;
import java.util.Map;

public class AstNodeComparerDelegate
implements DeepComparerDelegate {
    private final boolean compareAttributes;
    private final boolean compareLocation;

    public AstNodeComparerDelegate(boolean compareAttributes, boolean compareLocation) {
        this.compareAttributes = compareAttributes;
        this.compareLocation = compareLocation;
    }

    public boolean compare(Object a, Object b, DeepComparer comparer) throws ComparisonException {
        if (!(a instanceof AstNode) || !(b instanceof AstNode)) {
            return false;
        }
        this.compare((AstNode)a, (AstNode)b, comparer);
        return true;
    }

    public void compare(AstNode<?> a, AstNode<?> b, DeepComparer comparer) throws ComparisonException {
        if (a == b) {
            return;
        }
        if (a == null != (b == null)) {
            throw new AstComparisonException(a, b, AstDifference.NULL_VS_NON_NULL);
        }
        if (a == null) {
            return;
        }
        if (a.getClass() != b.getClass()) {
            throw new AstComparisonException(a, b, AstDifference.NODE_TYPES_DIFFER);
        }
        if (this.compareLocation && (a.getNativeLocation() == null ? b.getNativeLocation() != null : !a.getNativeLocation().equals(b.getNativeLocation()))) {
            throw new AstComparisonException(a, b, AstDifference.LOCATION_DIFFERS);
        }
        if (this.compareAttributes) {
            this.compareAttributes(a, b, comparer);
        }
        Object i = a.propertyIterator();
        Object j = b.propertyIterator();
        while (((AstNodePropertyIterator)i).next()) {
            if (!((AstNodePropertyIterator)j).next()) {
                throw new InternalError();
            }
            if (!((AstNodePropertyIterator)i).getName().equals(((AstNodePropertyIterator)j).getName())) {
                throw new InternalError();
            }
            try {
                comparer.compare(((AstNodePropertyIterator)i).getValue(), ((AstNodePropertyIterator)j).getValue());
            }
            catch (AstComparisonException e) {
                throw new PropertyComparisonException(e, a, b, ((AstNodePropertyIterator)i).getName(), ((AstNodePropertyIterator)i).getValue(), ((AstNodePropertyIterator)j).getValue());
            }
        }
        if (((AstNodePropertyIterator)j).next()) {
            throw new InternalError();
        }
        if (a.isList()) {
            if (a.size() != b.size()) {
                throw new AstComparisonException(a, b, AstDifference.NUMBER_OF_CHILDREN_DIFFERS);
            }
            i = a.iterator();
            j = b.iterator();
            int k = 0;
            while (i.hasNext() & j.hasNext()) {
                try {
                    comparer.compare(i.next(), j.next());
                    ++k;
                }
                catch (AstComparisonException e) {
                    throw new ComparisonOfChildrenFailedException(a, b, k, e);
                }
            }
        } else {
            String[] bcn;
            String[] acn = a.getChildNames();
            if (acn.length != (bcn = b.getChildNames()).length) {
                throw new InternalError();
            }
            for (int i2 = 0; i2 < acn.length; ++i2) {
                if (!acn[i2].equals(bcn[i2])) {
                    throw new InternalError();
                }
                try {
                    comparer.compare(a.get(i2), b.get(i2));
                    continue;
                }
                catch (AstComparisonException e) {
                    throw new ComparisonOfChildrenFailedException(a, b, i2, acn[i2], e);
                }
            }
        }
    }

    private void compareAttributes(AstNode<?> na, AstNode<?> nb, DeepComparer comparer) throws ComparisonException {
        Map<String, Object> a = na.getAttributes();
        Map<String, Object> b = nb.getAttributes();
        if (b == a) {
            return;
        }
        if (b.size() != a.size()) {
            throw new AstComparisonException(na, nb, AstDifference.NUMBER_OF_ATTRIBUTES_DIFFERS);
        }
        for (Map.Entry<String, Object> e : a.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null) {
                if (b.get(key) == null && b.containsKey(key)) continue;
                throw new AttributeComparisonException(na, nb, key, null, b.get(key));
            }
            try {
                comparer.compare(value, b.get(key));
            }
            catch (AstComparisonException ce) {
                throw new AttributeComparisonException(ce, na, nb, key, value, b.get(key));
            }
        }
    }
}

