/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.comparer;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.comparer.AstDifference;
import de.fau.cs.osr.utils.ComparisonException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class AstComparisonException
extends ComparisonException {
    private static final long serialVersionUID = 1L;
    private final AstDifference reason;

    public AstComparisonException() {
        this(null, null, AstDifference.DEEP_COMPARISON_FAILED);
    }

    public AstComparisonException(AstComparisonException e) {
        this(e, null, null, AstDifference.DEEP_COMPARISON_FAILED);
    }

    public AstComparisonException(AstNode<?> a, AstNode<?> b, AstDifference reason) {
        super(a, b);
        this.reason = reason;
    }

    protected AstComparisonException(AstComparisonException e, AstNode<?> a, AstNode<?> b) {
        this(e, a, b, AstDifference.CHILDREN_DIFFER);
    }

    protected AstComparisonException(AstComparisonException e, AstNode<?> a, AstNode<?> b, AstDifference reason) {
        super((ComparisonException)e, a, b);
        this.reason = reason;
    }

    public AstNode<?> getA() {
        return (AstNode)super.getA();
    }

    public AstNode<?> getB() {
        return (AstNode)super.getB();
    }

    public AstDifference getReason() {
        return this.reason;
    }

    protected Writer toString(Writer w) throws IOException {
        if (this.getA() != null != (this.getB() != null)) {
            if (this.getA() != null) {
                w.append(String.format("Node A of type %s is not null while node B is null: %s\n", this.getA().getNodeName(), this.reason.getReason()));
            } else {
                w.append(String.format("Node B of type %s is not null while node A is null: %s\n", this.getB().getNodeName(), this.reason.getReason()));
            }
        } else if (this.getA().getClass() != this.getB().getClass()) {
            w.append(String.format("Two nodes differ in type %s vs. %s: %s\n", this.getA().getClass().getName(), this.getB().getClass().getName(), this.reason.getReason()));
        } else {
            w.append(String.format("Two nodes of type %s differ: %s\n", this.getA().getNodeName(), this.reason.getReason()));
        }
        return w;
    }

    public String toString() {
        try {
            return this.toString(new StringWriter()).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

