/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstLeafNodeImpl;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.AstStringNode;
import de.fau.cs.osr.ptk.common.ast.Uninitialized;
import de.fau.cs.osr.utils.StringTools;
import java.io.IOException;

public abstract class AstStringNodeImpl<T extends AstNode<T>>
extends AstLeafNodeImpl<T>
implements AstStringNode<T> {
    private static final long serialVersionUID = -3995972757553601033L;
    private String content;

    protected AstStringNodeImpl(Uninitialized u) {
    }

    protected AstStringNodeImpl(String content) {
        this.setContent(content);
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String content) {
        if (content == null) {
            throw new NullPointerException();
        }
        this.content = content;
    }

    @Override
    public int getPropertyCount() {
        return 1;
    }

    @Override
    public AstNodePropertyIterator propertyIterator() {
        return new StringContentNodePropertyIterator();
    }

    @Override
    public void toString(Appendable out) throws IOException {
        out.append(this.getClass().getSimpleName());
        out.append("(\"");
        out.append(StringTools.escJava((String)this.getContent()));
        out.append("\")");
    }

    protected class StringContentNodePropertyIterator
    extends AstNodePropertyIterator {
        protected StringContentNodePropertyIterator() {
        }

        @Override
        protected int getPropertyCount() {
            return 1;
        }

        @Override
        protected String getName(int index) {
            switch (index) {
                case 0: {
                    return "content";
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        protected Object getValue(int index) {
            switch (index) {
                case 0: {
                    return AstStringNodeImpl.this.getContent();
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        protected Object setValue(int index, Object value) {
            switch (index) {
                case 0: {
                    String old = AstStringNodeImpl.this.getContent();
                    AstStringNodeImpl.this.setContent((String)value);
                    return old;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

