/*
 * Decompiled with CFR 0.152.
 */
package tfswx.foundation.iceruntime;

import Ice.Communicator;
import Ice.ConnectionLostException;
import Ice.InitializationData;
import Ice.ObjectPrx;
import Ice.Properties;
import Ice.Util;
import java.util.HashMap;
import tfswx.foundation.iceruntime.CommunicationService;
import tfswx.foundation.iceruntime.ICallback;
import tfswx.foundation.iceruntime.IIceContext;
import tfswx.foundation.iceruntime.IceContextClientMode;
import tfswx.foundation.iceruntime.IceContextMode;
import tfswx.foundation.iceruntime.IceContextRouteMode;

public class ClientCommunicationService
extends CommunicationService {
    private IIceContext _context;
    private InitializationData _initData;
    private IceContextMode _mode;
    private HashMap<String, String> _icecontext;

    public ClientCommunicationService(String configFile, IceContextMode mode, InitializationData initData) {
        this._mode = mode;
        this._initData = initData != null ? (InitializationData)initData.clone() : new InitializationData();
        if (configFile != null) {
            try {
                String[] args = new String[]{};
                this._initData.properties = Util.createProperties((String[])args, (Properties)this._initData.properties);
                this._initData.properties.load(configFile);
            }
            catch (Exception ex) {
                Util.getProcessLogger().error("unknown exception:\n" + ex);
                throw ex;
            }
        }
        this.ReCreateIceContext();
    }

    public void Dispose() {
        if (this._context != null) {
            this._context.Dispose();
            this._context = null;
        }
    }

    @Override
    public <TPrx extends ObjectPrx, TResult> TResult CallRemoteProcedure(String proxyString, Class<?> helperClass, ICallback call) throws Exception {
        boolean redo = false;
        int redoCount = 0;
        Exception exception = null;
        do {
            Object prx = null;
            try {
                redo = false;
                return call.call(this.CreateRemoteObj(proxyString, helperClass));
            }
            catch (ConnectionLostException ex) {
                ++redoCount;
                redo = true;
                this.ReCreateIceContext();
            }
            catch (Exception e) {
                exception = e;
            }
        } while (redo && redoCount > 0 && redoCount <= 3);
        if (redo) {
            throw new ConnectionLostException();
        }
        throw exception;
    }

    protected void ReCreateIceContext() {
        if (this._context != null) {
            this._context.Dispose();
            this._context = null;
        }
        if (this._mode == IceContextMode.Client) {
            this._context = new IceContextClientMode(this._initData);
            this.setIceGridQueryProxyString(this._initData.properties.getProperty("IceGridQuery"));
        } else {
            this._context = new IceContextRouteMode(this._initData);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean redo = false;
        int redoCount = 0;
        do {
            Communicator communicator;
            if ((communicator = this._context.getCommunicator()) == null) {
                redo = true;
                ++redoCount;
                continue;
            }
            this.setCommunicator(communicator);
        } while (redo && redoCount > 0 && redoCount <= 5);
        if (redo) {
            throw new NullPointerException("Ice.Communicator");
        }
    }

    @Override
    public HashMap<String, String> GetCommunicationContext() {
        if (this._icecontext == null) {
            this._icecontext = new HashMap();
        }
        return this._icecontext;
    }

    @Override
    public void ImportToken(String token) {
        if (this._icecontext == null) {
            this._icecontext = new HashMap();
        }
        this._icecontext.put("swxtoken", token);
    }
}

