/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.core.context;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.logging.log4j.ThreadContext;

public class AspectLogContext {
    private static TransmittableThreadLocal<String> logValueTL = new TransmittableThreadLocal();
    private static Boolean isLog4j2AsyncLoggerContextSelector;

    public static void putLogValue(String logValue) {
        logValueTL.set((Object)logValue);
        if (AspectLogContext.isLog4j2AsyncLoggerContextSelector()) {
            ThreadContext.put((String)"tl", (String)logValue);
        }
    }

    public static String getLogValue() {
        String result = (String)logValueTL.get();
        if (StrUtil.isBlank((CharSequence)result) && AspectLogContext.isLog4j2AsyncLoggerContextSelector()) {
            result = ThreadContext.get((String)"tl");
        }
        return result;
    }

    public static void remove() {
        logValueTL.remove();
        if (AspectLogContext.isLog4j2AsyncLoggerContextSelector()) {
            ThreadContext.remove((String)"tl");
        }
    }

    private static boolean isLog4j2AsyncLoggerContextSelector() {
        if (ObjectUtil.isNull((Object)isLog4j2AsyncLoggerContextSelector)) {
            boolean flag2;
            boolean flag1 = "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector".equals(System.getProperty("Log4jContextSelector"));
            try {
                Class.forName("org.apache.logging.log4j.core.pattern.LogEventPatternConverter");
                flag2 = true;
            }
            catch (Exception e) {
                flag2 = false;
            }
            boolean result = flag1 || flag2;
            isLog4j2AsyncLoggerContextSelector = result;
        }
        return isLog4j2AsyncLoggerContextSelector;
    }
}

