/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.yomahub.tlog.utils.AbstractClock;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueIdUtil {
    private static Logger log = LoggerFactory.getLogger(UniqueIdUtil.class);
    public static final long EPOCH;
    private static final long SEQUENCE_BITS = 6L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 63L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 6L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 16L;
    private static final long WORKER_ID_MAX_VALUE = 1024L;
    private static AbstractClock clock;
    private static long workerId;
    private static long sequence;
    private static long lastTime;

    static void initWorkerId() {
        InetAddress address = UniqueIdUtil.getLocalAddress();
        byte[] ipAddressByteArray = address.getAddress();
        UniqueIdUtil.setWorkerId(Long.valueOf(((ipAddressByteArray[ipAddressByteArray.length - 2] & 3) << 8) + (ipAddressByteArray[ipAddressByteArray.length - 1] & 0xFF)));
    }

    private static InetAddress getLocalAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses;
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp() || !(addresses = networkInterface.getInetAddresses()).hasMoreElements()) continue;
                return addresses.nextElement();
            }
        }
        catch (Exception e) {
            log.debug("Error when getting host ip address: <{}>.", (Object)e.getMessage());
            throw new IllegalStateException("Cannot get LocalHost InetAddress, please check your network!");
        }
        return null;
    }

    public static void setWorkerId(Long workerId) {
        Preconditions.checkArgument((workerId >= 0L && workerId < 1024L ? 1 : 0) != 0);
        UniqueIdUtil.workerId = workerId;
    }

    public static synchronized Long generateId() {
        long time = clock.millis();
        Preconditions.checkState((lastTime <= time ? 1 : 0) != 0, (String)"Clock is moving backwards, last time is %d milliseconds, current time is %d milliseconds", (Object[])new Object[]{lastTime, time});
        if (lastTime == time) {
            ++sequence;
            if (0L == (sequence &= 0x3FL)) {
                time = UniqueIdUtil.waitUntilNextTime(time);
            }
        } else {
            sequence = 0L;
        }
        lastTime = time;
        if (log.isDebugEnabled()) {
            log.debug("{}-{}-{}", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(lastTime)), workerId, sequence});
        }
        return time - EPOCH << 16 | workerId << 6 | sequence;
    }

    private static long waitUntilNextTime(long lastTime) {
        long time = clock.millis();
        while (time <= lastTime) {
            time = clock.millis();
        }
        return time;
    }

    public static void main(String[] args) throws InterruptedException {
        long start = System.currentTimeMillis();
        Set set = Sets.newConcurrentHashSet();
        for (int i = 0; i < 100000; ++i) {
            set.add(UniqueIdUtil.generateId());
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start);
        System.out.println(set.size());
    }

    static {
        clock = AbstractClock.systemClock();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2017, 3, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        EPOCH = calendar.getTimeInMillis();
        UniqueIdUtil.initWorkerId();
    }
}

