/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el.operator;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrFormatter;
import com.ql.util.express.exception.QLException;
import com.yomahub.liteflow.builder.el.operator.base.BaseOperator;
import com.yomahub.liteflow.builder.el.operator.base.OperatorHelper;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.condition.FinallyCondition;
import com.yomahub.liteflow.flow.element.condition.ThenCondition;
import com.yomahub.liteflow.flow.element.condition.TimeoutCondition;
import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MaxWaitSecondsOperator
extends BaseOperator<Condition> {
    @Override
    public Condition build(Object[] objects) throws Exception {
        OperatorHelper.checkObjectSizeEqTwo(objects);
        Executable executable = OperatorHelper.convert(objects[0], Executable.class);
        Integer maxWaitSeconds = OperatorHelper.convert(objects[1], Integer.class);
        if (executable instanceof WhenCondition) {
            WhenCondition whenCondition = OperatorHelper.convert(executable, WhenCondition.class);
            whenCondition.setMaxWaitTime(maxWaitSeconds);
            whenCondition.setMaxWaitTimeUnit(TimeUnit.SECONDS);
            return whenCondition;
        }
        if (executable instanceof FinallyCondition) {
            String errorMsg = StrFormatter.format((String)"The caller [{}] cannot use the keyword \"maxWaitSeconds'\"", (Object[])new Object[]{executable.toString()});
            throw new QLException(errorMsg);
        }
        if (this.containsFinally(executable)) {
            ThenCondition thenCondition = OperatorHelper.convert(executable, ThenCondition.class);
            return this.handleFinally(thenCondition, maxWaitSeconds);
        }
        return this.wrappedByTimeout(executable, maxWaitSeconds);
    }

    private TimeoutCondition wrappedByTimeout(Executable executable, Integer maxWaitSeconds) {
        TimeoutCondition timeoutCondition = new TimeoutCondition();
        timeoutCondition.addExecutable(executable);
        timeoutCondition.setMaxWaitTime(maxWaitSeconds);
        timeoutCondition.setMaxWaitTimeUnit(TimeUnit.SECONDS);
        return timeoutCondition;
    }

    private boolean containsFinally(Executable executable) {
        return executable instanceof ThenCondition && CollUtil.isNotEmpty(((ThenCondition)executable).getFinallyConditionList());
    }

    private ThenCondition handleFinally(ThenCondition thenCondition, Integer maxWaitSeconds) {
        ThenCondition outerThenCondition = new ThenCondition();
        List<Executable> finallyList = thenCondition.getExecutableList("FINALLY_KEY");
        finallyList.forEach(executable -> outerThenCondition.addFinallyCondition((FinallyCondition)executable));
        finallyList.clear();
        TimeoutCondition whenCondition = this.wrappedByTimeout(thenCondition, maxWaitSeconds);
        outerThenCondition.addExecutable(whenCondition);
        return outerThenCondition;
    }
}

