/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.auth.interceptor;

import com.xxl.sso.core.annotation.XxlSso;
import com.xxl.sso.core.exception.XxlSsoException;
import com.xxl.sso.core.helper.XxlSsoHelper;
import com.xxl.sso.core.model.LoginInfo;
import com.xxl.sso.core.path.impl.AntPathMatcher;
import com.xxl.tool.core.CollectionTool;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.response.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class XxlSsoNativeInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(XxlSsoNativeInterceptor.class);
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private String excludedPaths;

    public XxlSsoNativeInterceptor(String excludedPaths) {
        this.excludedPaths = excludedPaths;
        logger.info("XxlSsoNativeInterceptor init.");
    }

    private boolean isMatchExcludedPaths(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (StringTool.isNotBlank((String)this.excludedPaths)) {
            for (String excludedPath : this.excludedPaths.split(",")) {
                String uriPattern = excludedPath.trim();
                if (StringTool.isBlank((String)uriPattern) || !this.antPathMatcher.match(uriPattern, servletPath)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String role;
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        XxlSso xxlSso = (XxlSso)method.getMethodAnnotation(XxlSso.class);
        boolean needLogin = xxlSso != null ? xxlSso.login() : true;
        String permission = xxlSso != null ? xxlSso.permission() : null;
        String string = role = xxlSso != null ? xxlSso.role() : null;
        if (this.isMatchExcludedPaths(request)) {
            return true;
        }
        if (!needLogin) {
            return true;
        }
        Response<LoginInfo> loginCheckResult = XxlSsoHelper.loginCheckWithHeader(request);
        LoginInfo loginInfo = null;
        if (loginCheckResult != null && loginCheckResult.isSuccess()) {
            loginInfo = (LoginInfo)loginCheckResult.getData();
        }
        if (loginInfo == null) {
            String loginFailMsg = GsonTool.toJson((Object)Response.of((int)501, (String)("not login for path:" + request.getServletPath())));
            response.setStatus(200);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().println(loginFailMsg);
            return false;
        }
        request.setAttribute("xxl_sso_user", loginInfo);
        if (StringTool.isNotBlank((String)permission) && !CollectionTool.contains(loginInfo.getPermissionList(), (Object)permission)) {
            throw new XxlSsoException("permission limit, current login-user does not have permission:" + permission);
        }
        if (StringTool.isNotBlank((String)role) && !CollectionTool.contains(loginInfo.getRoleList(), (Object)role)) {
            throw new XxlSsoException("permission limit, current login-user does not have role:" + role);
        }
        return true;
    }
}

