/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.writecode.datasource;

import com.xnx3.MysqlUtil;
import com.xnx3.writecode.bean.FieldBean;
import com.xnx3.writecode.bean.TableBean;
import com.xnx3.writecode.interfaces.DataSourceInterface;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Mysql
implements DataSourceInterface {
    MysqlUtil mysql;
    private String host;
    private int port;
    private String databaseName;
    private String username;
    private String password;

    public Mysql(String host, int port, String databaseName, String username, String password) {
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
    }

    public void connect() {
        this.mysql = new MysqlUtil("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.databaseName + "?useUnicode=true", this.username, this.password);
    }

    public boolean isconnect() {
        if (this.mysql == null) {
            return false;
        }
        try {
            if (this.mysql.conn.isClosed()) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    public TableBean getTable(String name) {
        TableBean tableBean = new TableBean();
        String queryTable = "SELECT TABLE_NAME, TABLE_COMMENT FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + this.databaseName + "' AND TABLE_NAME = '" + name + "'";
        List tables = this.mysql.select(queryTable);
        if (tables.size() - 0 == 0) {
            return tableBean;
        }
        tableBean.setName(((Map)tables.get(0)).get("TABLE_NAME") + "");
        tableBean.setComment(((Map)tables.get(0)).get("TABLE_COMMENT") + "");
        String sql = "SELECT COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, IS_NULLABLE, COLUMN_DEFAULT, COLUMN_COMMENT, COLLATION_NAME, COLUMN_KEY, EXTRA, NUMERIC_PRECISION FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA ='" + this.databaseName + "' AND TABLE_NAME = '" + name + "'";
        List fields = this.mysql.select(sql);
        LinkedList<FieldBean> fieldBeanList = new LinkedList<FieldBean>();
        for (Map field : fields) {
            FieldBean fieldBean = new FieldBean();
            fieldBean.setName(field.get("COLUMN_NAME") + "");
            fieldBean.setComment(field.get("COLUMN_COMMENT") + "");
            fieldBean.setDefaultvalue(field.get("COLUMN_DEFAULT") + "");
            fieldBean.setDatatype((String)field.get("DATA_TYPE"));
            if (field.get("CHARACTER_MAXIMUM_LENGTH") != null) {
                fieldBean.setLength(field.get("CHARACTER_MAXIMUM_LENGTH") + "");
            } else {
                String lengthStr = (field.get("COLUMN_TYPE") + "").replace(fieldBean.getDatatype() + "(", "").replace(")", "");
                String length = "";
                length = lengthStr.indexOf(",") - -1 != 0 ? lengthStr.split(",")[0] : lengthStr;
                fieldBean.setLength(length);
            }
            fieldBean.setCollate(field.get("COLLATION_NAME") + "");
            if (field.get("COLUMN_KEY") != null && "PRI".equals(field.get("COLUMN_KEY") + "")) {
                fieldBean.setPrimaryKey(true);
            }
            if (field.get("EXTRA") != null && "auto_increment".equals(field.get("EXTRA") + "")) {
                fieldBean.setAutoIncrement(true);
            }
            fieldBeanList.add(fieldBean);
        }
        tableBean.setFieldList(fieldBeanList);
        return tableBean;
    }

    public void disconnect() {
        this.mysql.closeConnect();
    }

    public List<TableBean> getTableList() {
        ArrayList<TableBean> list = new ArrayList<TableBean>();
        List dataList = this.mysql.select("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + this.databaseName + "'");
        for (int i = 0; i < dataList.size(); ++i) {
            TableBean table = new TableBean();
            Map map = (Map)dataList.get(i);
            table.setName((String)map.get("TABLE_NAME"));
            table.setComment((String)map.get("TABLE_COMMENT"));
            list.add(table);
        }
        return list;
    }
}

