/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.cache;

import com.xnx3.CacheUtil;
import com.xnx3.cache.SerializeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisUtil {
    public static String host = "127.0.0.1";
    public static int port = 6379;
    public static String password = null;
    public static int MAX_ACTIVE = 1024;
    public static int MAX_IDLE = 200;
    public static int MAX_WAIT = 10000;
    public static int timeout = 3000;
    public static boolean TEST_ON_BORROW = true;
    public static JedisPool jedisPool = null;

    public static void createJedisPool(String host, int port, String password) {
        if (host != null && host.length() > 0 && port > 0) {
            try {
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(MAX_ACTIVE);
                config.setMaxIdle(MAX_IDLE);
                config.setMaxWaitMillis((long)MAX_WAIT);
                config.setTestOnBorrow(TEST_ON_BORROW);
                jedisPool = new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password);
                System.out.println("com.xnx3.CacheUtil use redis : " + host + "," + port + "," + timeout);
                CacheUtil.useRedis = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isUse() {
        return jedisPool != null;
    }

    public static synchronized Jedis getJedis() {
        try {
            if (jedisPool != null) {
                Jedis resource = jedisPool.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void returnResource(Jedis jedis) {
        RedisUtil.closeJedis(jedis);
    }

    public static void closeJedis(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            byte[] bytes = jedis.get(key.getBytes());
            if (bytes != null && bytes.length > 0) {
                Object object = SerializeUtils.deserialize(bytes);
                return object;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            jedis.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            String string = jedis.set(key.getBytes(), SerializeUtils.serialize(value));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value, int expiretime) {
        String result = "";
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            result = jedis.set(key.getBytes(), SerializeUtils.serialize(value));
            if (result.equals("OK")) {
                jedis.expire(key.getBytes(), expiretime);
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long delkeyObject(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Long l = jedis.del(key.getBytes());
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            Long l = null;
            return l;
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean existsObject(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            Boolean bl = jedis.exists(key.getBytes());
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Boolean bl = null;
            return bl;
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    public static Object deserialize(byte[] bytes) {
        Object result = null;
        if (RedisUtil.isEmpty(bytes)) {
            return null;
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
                try {
                    result = objectInputStream.readObject();
                }
                catch (ClassNotFoundException ex) {
                    throw new Exception("Failed to deserialize object type", ex);
                }
            }
            catch (Throwable ex) {
                throw new Exception("Failed to deserialize", ex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public static byte[] serialize(Object object) {
        byte[] result = null;
        if (object == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(128);
            try {
                if (!(object instanceof Serializable)) {
                    throw new IllegalArgumentException(SerializeUtils.class.getSimpleName() + " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                result = byteStream.toByteArray();
            }
            catch (Throwable ex) {
                throw new Exception("Failed to serialize", ex);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    static {
        String path = RedisUtil.class.getResource("/").getPath();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(path + "application.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!properties.isEmpty()) {
            String timeoutStr;
            String pwd;
            host = properties.getProperty("spring.redis.host");
            String portStr = properties.getProperty("spring.redis.port");
            if (portStr != null && portStr.length() > 0 && (port = Integer.parseInt(portStr)) == -1) {
                port = 6379;
            }
            if ((pwd = properties.getProperty("spring.redis.password")) != null && pwd.length() > 0) {
                password = pwd;
            }
            if ((timeoutStr = properties.getProperty("spring.redis.timeout")) != null && timeoutStr.length() > 0) {
                timeout = Integer.parseInt(timeoutStr);
            }
        } else {
            host = null;
        }
        if (host != null) {
            RedisUtil.createJedisPool(host, port, password);
        } else {
            System.out.println("com.xnx3.CacheUtil use java map ");
        }
    }
}

