/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.cache.JavaUtil;
import com.xnx3.cache.RedisUtil;

public class CacheUtil {
    public static final int EXPIRETIME = 604800;
    public static boolean useRedis = false;

    public static void set(String key, Object value) {
        if (useRedis) {
            RedisUtil.setObject(key, value);
        } else {
            JavaUtil.set(key, value);
        }
    }

    public static void set(String key, Object value, int expiretime) {
        if (useRedis) {
            RedisUtil.setObject(key, value, expiretime);
        } else {
            JavaUtil.set(key, value, expiretime);
        }
    }

    public static void setWeekCache(String key, Object value) {
        if (useRedis) {
            RedisUtil.setObject(key, value, 604800);
        } else {
            JavaUtil.set(key, value, -1);
        }
    }

    public static void setYearCache(String key, Object value) {
        if (useRedis) {
            RedisUtil.setObject(key, value, 31536000);
        } else {
            JavaUtil.set(key, value);
        }
    }

    public static Object get(String key) {
        if (useRedis) {
            return RedisUtil.getObject(key);
        }
        return JavaUtil.get(key);
    }

    public static void delete(String key) {
        if (useRedis) {
            RedisUtil.delkeyObject(key);
        } else {
            JavaUtil.delete(key);
        }
    }

    public static boolean isUseRedis() {
        return useRedis;
    }

    static {
        new RedisUtil();
    }
}

