/*
 * Decompiled with CFR 0.152.
 */
package org.reficio.ws.legacy;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmlUtils {
    private static DocumentBuilder documentBuilder;
    private static final Logger log;

    XmlUtils() {
    }

    public static synchronized Document parse(InputStream in) {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing InputStream; " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static synchronized Document parse(String fileName) throws IOException {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(fileName);
        }
        catch (SAXException e) {
            log.error((Object)("Error parsing fileName [" + fileName + "]; " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static synchronized Document parse(InputSource inputSource) throws IOException {
        try {
            return XmlUtils.ensureDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    public static NodeList getChildElements(Element elm) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node item = nl.item(c);
            if (item.getParentNode() != elm || item.getNodeType() != 1) continue;
            list.add((Element)item);
        }
        return new ElementNodeList(list);
    }

    public static String getChildElementText(Element elm, String name) {
        Element child = XmlUtils.getFirstChildElement(elm, name);
        return child == null ? null : XmlUtils.getElementText(child);
    }

    public static Element getFirstChildElement(Element elm) {
        return XmlUtils.getFirstChildElement(elm, null);
    }

    public static String getElementText(Element elm) {
        Node node = elm.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getFragmentText(DocumentFragment elm) {
        Node node = elm.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        return null;
    }

    public static String getChildElementText(Element elm, String name, String defaultValue) {
        String result = XmlUtils.getChildElementText(elm, name);
        return result == null ? defaultValue : result;
    }

    public static String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1) {
            return XmlUtils.getElementText((Element)node);
        }
        if (node.getNodeType() == 11) {
            return XmlUtils.getFragmentText((DocumentFragment)node);
        }
        return node.getNodeValue();
    }

    public static Element getFirstChildElement(Element elm, String name) {
        if (elm == null) {
            return null;
        }
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1 || name != null && !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstChildElementIgnoreCase(Element elm, String name) {
        if (elm == null) {
            return null;
        }
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1 || name != null && !node.getNodeName().equalsIgnoreCase(name)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstChildElementNS(Element elm, String tns, String localName) {
        if (tns == null && localName == null) {
            return XmlUtils.getFirstChildElement(elm);
        }
        if (tns == null || tns.length() == 0) {
            return XmlUtils.getFirstChildElement(elm, localName);
        }
        NodeList nl = elm.getChildNodes();
        for (int c = 0; c < nl.getLength(); ++c) {
            Node node = nl.item(c);
            if (node.getNodeType() != 1) continue;
            if (localName == null && tns.equals(node.getNamespaceURI())) {
                return (Element)node;
            }
            if (localName == null || !tns.equals(node.getNamespaceURI()) || !localName.equals(node.getLocalName())) continue;
            return (Element)node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeUnneccessaryNamespaces(String xml) {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return xml;
        }
        XmlObject xmlObject = null;
        XmlCursor cursor = null;
        try {
            xmlObject = XmlObject.Factory.parse((String)xml);
            cursor = xmlObject.newCursor();
            while (cursor.currentTokenType() != XmlCursor.TokenType.START && cursor.currentTokenType() != XmlCursor.TokenType.ENDDOC) {
                cursor.toNextToken();
            }
            if (cursor.currentTokenType() == XmlCursor.TokenType.START) {
                int c;
                HashMap nsMap = new HashMap();
                cursor.getAllNamespaces(nsMap);
                nsMap.remove(cursor.getDomNode().getPrefix());
                NamedNodeMap attributes = cursor.getDomNode().getAttributes();
                for (c = 0; attributes != null && c < attributes.getLength(); ++c) {
                    nsMap.remove(attributes.item(c).getPrefix());
                }
                if (cursor.toFirstChild()) {
                    while (cursor.getDomNode() != xmlObject.getDomNode()) {
                        attributes = cursor.getDomNode().getAttributes();
                        for (c = 0; attributes != null && c < attributes.getLength(); ++c) {
                            nsMap.remove(attributes.item(c).getPrefix());
                        }
                        nsMap.remove(cursor.getDomNode().getPrefix());
                        cursor.toNextToken();
                    }
                }
                xml = xmlObject.xmlText(new XmlOptions().setSaveOuter().setSavePrettyPrint().setSaveImplicitNamespaces(nsMap));
            }
        }
        catch (XmlException xmlException) {
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return xml;
    }

    private static DocumentBuilder ensureDocumentBuilder() {
        if (documentBuilder == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                documentBuilder = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error((Object)("Error creating DocumentBuilder; " + e.getMessage()));
            }
        }
        return documentBuilder;
    }

    public static XmlObject createXmlObject(String input, XmlOptions xmlOptions) throws XmlException {
        return XmlObject.Factory.parse((String)input, (XmlOptions)xmlOptions);
    }

    public static XmlObject createXmlObject(URL input, XmlOptions xmlOptions) throws XmlException {
        try {
            return XmlObject.Factory.parse((URL)input, (XmlOptions)xmlOptions);
        }
        catch (Exception e) {
            throw new XmlException(e.toString());
        }
    }

    public static XmlObject createXmlObject(String input) throws XmlException {
        return XmlObject.Factory.parse((String)input);
    }

    public static XmlObject createXmlObject(URL input) throws XmlException {
        try {
            return XmlObject.Factory.parse((URL)input);
        }
        catch (Exception e) {
            throw new XmlException((Throwable)e);
        }
    }

    public static void setElementText(Element elm, String text) {
        Node node = elm.getFirstChild();
        if (node == null) {
            if (text != null) {
                elm.appendChild(elm.getOwnerDocument().createTextNode(text));
            }
        } else if (node.getNodeType() == 3) {
            if (text == null) {
                node.getParentNode().removeChild(node);
            } else {
                node.setNodeValue(text);
            }
        } else if (text != null) {
            Text textNode = node.getOwnerDocument().createTextNode(text);
            elm.insertBefore(textNode, elm.getFirstChild());
        }
    }

    public static QName getQName(XmlObject contentElement) {
        return contentElement == null ? null : XmlUtils.getQName(contentElement.getDomNode());
    }

    public static QName getQName(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNamespaceURI() == null) {
            return new QName(node.getNodeName());
        }
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static Document parseXml(String xmlString) throws IOException {
        return XmlUtils.parse(new InputSource(new StringReader(xmlString)));
    }

    public static boolean setNodeValue(Node domNode, String string) {
        if (domNode == null) {
            return false;
        }
        short nodeType = domNode.getNodeType();
        switch (nodeType) {
            case 1: {
                XmlUtils.setElementText((Element)domNode, string);
                break;
            }
            case 2: 
            case 3: {
                domNode.setNodeValue(string);
                break;
            }
            case 7: {
                ((ProcessingInstruction)domNode).setData(string);
                break;
            }
            case 4: {
                ((CDATASection)domNode).setData(string);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static String declareXPathNamespaces(XmlObject xmlObject) {
        HashMap<QName, String> map = new HashMap<QName, String>();
        XmlCursor cursor = xmlObject.newCursor();
        while (cursor.hasNextToken()) {
            if (!cursor.toNextToken().isNamespace()) continue;
            map.put(cursor.getName(), cursor.getTextValue());
        }
        cursor.dispose();
        Iterator i = map.keySet().iterator();
        int nsCnt = 0;
        StringBuffer buf = new StringBuffer();
        HashSet<String> prefixes = new HashSet<String>();
        HashSet<String> usedPrefixes = new HashSet<String>();
        while (i.hasNext()) {
            QName name = (QName)i.next();
            String prefix = name.getLocalPart();
            if (prefix.length() == 0) {
                prefix = "ns" + Integer.toString(++nsCnt);
            } else if (prefix.equals("xsd") || prefix.equals("xsi")) continue;
            if (usedPrefixes.contains(prefix)) {
                int c = 1;
                while (usedPrefixes.contains(prefix + c)) {
                    ++c;
                }
                prefix = prefix + Integer.toString(c);
            } else {
                prefixes.add(prefix);
            }
            buf.append("declare namespace ");
            buf.append(prefix);
            buf.append("='");
            buf.append((String)map.get(name));
            buf.append("';\n");
            usedPrefixes.add(prefix);
        }
        return buf.toString();
    }

    public static String setXPathContent(String xmlText, String xpath, String value) {
        try {
            XmlObject[] path;
            XmlObject xmlObject = XmlObject.Factory.parse((String)xmlText);
            String namespaces = XmlUtils.declareXPathNamespaces(xmlObject);
            if (namespaces != null && namespaces.trim().length() > 0) {
                xpath = namespaces + xpath;
            }
            for (XmlObject xml : path = xmlObject.selectPath(xpath)) {
                XmlUtils.setNodeValue(xml.getDomNode(), value);
            }
            return xmlObject.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return xmlText;
        }
    }

    public static void serializePretty(XmlObject xmlObject, Writer writer) throws IOException {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(3);
        options.setSaveNoXmlDecl();
        options.setSaveAggressiveNamespaces();
        xmlObject.save(writer, options);
    }

    static {
        log = Logger.getLogger(XmlUtils.class);
    }

    private static final class ElementNodeList
    implements NodeList {
        private final List<Element> list;

        public ElementNodeList(List<Element> list) {
            this.list = list;
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Node item(int index) {
            return this.list.get(index);
        }
    }
}

