/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.http.support.okhttp3;

import com.xkcoding.http.exception.SimpleHttpException;
import com.xkcoding.http.support.Http;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.MapUtil;
import com.xkcoding.http.util.StringUtil;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttp3Impl
implements Http {
    public static final MediaType CONTENT_TYPE_JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final OkHttpClient httpClient;

    public OkHttp3Impl() {
        this(new OkHttpClient().newBuilder().connectTimeout(Duration.ofMillis(3000L)).writeTimeout(Duration.ofMillis(3000L)).readTimeout(Duration.ofMillis(3000L)).build());
    }

    public OkHttp3Impl(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String exec(Request.Builder requestBuilder) {
        this.addHeader(requestBuilder);
        Request request = requestBuilder.build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new SimpleHttpException("Unexpected code " + response);
            }
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new SimpleHttpException(e);
        }
    }

    private void addHeader(Request.Builder builder) {
        builder.header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
    }

    @Override
    public String get(String url) {
        return this.get(url, null, false);
    }

    @Override
    public String get(String url, Map<String, String> params, boolean encode) {
        return this.get(url, params, null, encode);
    }

    @Override
    public String get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (encode) {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addEncodedQueryParameter(arg_0, arg_1));
        } else {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        HttpUrl httpUrl = urlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        requestBuilder = requestBuilder.get();
        return this.exec(requestBuilder);
    }

    @Override
    public String post(String url) {
        return this.post(url, "");
    }

    @Override
    public String post(String url, String data) {
        return this.post(url, data, null);
    }

    @Override
    public String post(String url, String data, HttpHeader header) {
        if (StringUtil.isEmpty(data)) {
            data = "";
        }
        RequestBody body = RequestBody.create((String)data, (MediaType)CONTENT_TYPE_JSON);
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        requestBuilder = requestBuilder.post(body);
        return this.exec(requestBuilder);
    }

    @Override
    public String post(String url, Map<String, String> params, boolean encode) {
        return this.post(url, params, null, encode);
    }

    @Override
    public String post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        if (encode) {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((FormBody.Builder)formBuilder).addEncoded(arg_0, arg_1));
        } else {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((FormBody.Builder)formBuilder).add(arg_0, arg_1));
        }
        FormBody body = formBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        requestBuilder = requestBuilder.post((RequestBody)body);
        return this.exec(requestBuilder);
    }
}

