/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.http.support.hutool;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.xkcoding.http.exception.SimpleHttpException;
import com.xkcoding.http.support.Http;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.MapUtil;
import com.xkcoding.http.util.StringUtil;
import com.xkcoding.http.util.UrlUtil;
import java.util.Map;

public class HutoolImpl
implements Http {
    private String exec(HttpRequest request) {
        request = request.timeout(3000);
        try (HttpResponse response = request.execute();){
            if (!response.isOk()) {
                throw new SimpleHttpException("Unexpected code " + response);
            }
            String string = response.body();
            return string;
        }
    }

    @Override
    public String get(String url) {
        return this.get(url, null, false);
    }

    @Override
    public String get(String url, Map<String, String> params, boolean encode) {
        return this.get(url, params, null, encode);
    }

    @Override
    public String get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        String baseUrl = StringUtil.appendIfNotContain(url, "?", "&");
        url = baseUrl + MapUtil.parseMapToString(params, encode);
        HttpRequest request = HttpRequest.get((String)url);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpRequest)request).header(arg_0, arg_1));
        }
        return this.exec(request);
    }

    @Override
    public String post(String url) {
        HttpRequest request = HttpRequest.post((String)url);
        return this.exec(request);
    }

    @Override
    public String post(String url, String data) {
        return this.post(url, data, null);
    }

    @Override
    public String post(String url, String data, HttpHeader header) {
        HttpRequest request = HttpRequest.post((String)url);
        if (StringUtil.isNotEmpty(data)) {
            request.body(data);
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpRequest)request).header(arg_0, arg_1));
        }
        return this.exec(request);
    }

    @Override
    public String post(String url, Map<String, String> params, boolean encode) {
        return this.post(url, params, null, encode);
    }

    @Override
    public String post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpRequest request = HttpRequest.post((String)url);
        if (encode) {
            MapUtil.forEach(params, (k, v) -> request.form(k, (Object)UrlUtil.urlEncode(v)));
        } else {
            MapUtil.forEach(params, (arg_0, arg_1) -> ((HttpRequest)request).form(arg_0, arg_1));
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpRequest)request).header(arg_0, arg_1));
        }
        return this.exec(request);
    }
}

