/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.linkis.node.execution.parser;

import com.google.gson.reflect.TypeToken;
import com.webank.wedatasphere.dss.linkis.node.execution.WorkflowContext;
import com.webank.wedatasphere.dss.linkis.node.execution.job.Job;
import com.webank.wedatasphere.dss.linkis.node.execution.job.JobSignalKeyCreator;
import com.webank.wedatasphere.dss.linkis.node.execution.job.LinkisJob;
import com.webank.wedatasphere.dss.linkis.node.execution.parser.JobParser;
import com.webank.wedatasphere.dss.linkis.node.execution.utils.LinkisJobExecutionUtils;
import java.util.Collection;
import java.util.Map;

public class JobParamsParser
implements JobParser {
    private JobSignalKeyCreator signalKeyCreator;

    public JobSignalKeyCreator getSignalKeyCreator() {
        return this.signalKeyCreator;
    }

    public void setSignalKeyCreator(JobSignalKeyCreator signalKeyCreator) {
        this.signalKeyCreator = signalKeyCreator;
    }

    @Override
    public void parseJob(Job job) throws Exception {
        if (job instanceof LinkisJob) {
            LinkisJob linkisJob = (LinkisJob)job;
            linkisJob.getLogObj().info("Start to  put variable and configuration");
            Map<String, Object> flowVariables = linkisJob.getVariables();
            this.putParamsMap(job.getParams(), "variable", flowVariables);
            Map<String, Object> sharedValue = WorkflowContext.getAppJointContext().getSubMapByPrefix("signal." + this.getSignalKeyCreator().getSignalKeyByJob(job));
            if (sharedValue != null) {
                Collection<Object> values = sharedValue.values();
                for (Object value : values) {
                    Map variableMap = (Map)LinkisJobExecutionUtils.gson.fromJson(value.toString(), new TypeToken<Map<String, Object>>(){}.getType());
                    this.putParamsMap(job.getParams(), "variable", variableMap);
                }
            }
            Map<String, Object> configuration = linkisJob.getConfiguration();
            this.putParamsMap(job.getParams(), "configuration", configuration);
            linkisJob.getLogObj().info("Finished to  put variable and configuration");
        }
    }

    private void putParamsMap(Map<String, Object> params, String key, Map<String, Object> value) {
        if (null == value) {
            return;
        }
        if (params.get(key) != null) {
            ((Map)params.get(key)).putAll(value);
        } else {
            params.put(key, value);
        }
    }
}

