/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.linkis.node.execution.parser;

import com.google.gson.reflect.TypeToken;
import com.webank.wedatasphere.dss.linkis.node.execution.conf.LinkisJobExecutionConfiguration;
import com.webank.wedatasphere.dss.linkis.node.execution.entity.BMLResource;
import com.webank.wedatasphere.dss.linkis.node.execution.exception.LinkisJobExecutionErrorException;
import com.webank.wedatasphere.dss.linkis.node.execution.job.CommonLinkisJob;
import com.webank.wedatasphere.dss.linkis.node.execution.job.Job;
import com.webank.wedatasphere.dss.linkis.node.execution.parser.JobParser;
import com.webank.wedatasphere.dss.linkis.node.execution.utils.LinkisJobExecutionUtils;
import com.webank.wedatasphere.linkis.filesystem.WorkspaceClientFactory;
import com.webank.wedatasphere.linkis.filesystem.request.WorkspaceClient;
import com.webank.wedatasphere.linkis.filesystem.response.ScriptFromBMLResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CodeParser
implements JobParser {
    private static final Pattern pb = Pattern.compile("((project)|(flow)|(node))://[^\\s\"]+[$\\s]{0,1}", 2);

    @Override
    public void parseJob(Job job) throws Exception {
        if (!(job instanceof CommonLinkisJob)) {
            return;
        }
        CommonLinkisJob linkisAppjointJob = (CommonLinkisJob)job;
        Map script = (Map)LinkisJobExecutionUtils.gson.fromJson(linkisAppjointJob.getCode(), new TypeToken<Map<String, Object>>(){}.getType());
        List<BMLResource> jobResourceList = linkisAppjointJob.getJobResourceList();
        BMLResource scriptResource = null;
        if (script == null) {
            throw new LinkisJobExecutionErrorException(90102, "Script is empty");
        }
        String fileName = (String)script.get("script");
        for (BMLResource bmlResource : jobResourceList) {
            if (!bmlResource.getFileName().equals(fileName)) continue;
            scriptResource = bmlResource;
            break;
        }
        if (null == scriptResource) {
            throw new LinkisJobExecutionErrorException(90102, "Failed to get script resource");
        }
        Map<String, Object> executionParams = this.getExecutionParams(scriptResource, linkisAppjointJob);
        if (executionParams.get("executionCode") != null) {
            String executionCode = (String)executionParams.get("executionCode");
            linkisAppjointJob.getLogObj().info("************************************SUBMIT CODE************************************");
            linkisAppjointJob.getLogObj().info(executionCode);
            linkisAppjointJob.getLogObj().info("************************************SUBMIT CODE************************************");
            ArrayList<String> resourceNames = this.getResourceNames(executionCode);
            ArrayList<BMLResource> bmlResourceArrayList = this.getResourcesByNames(resourceNames, linkisAppjointJob);
            linkisAppjointJob.setCode(this.replaceCodeResourceNames(executionCode, resourceNames, bmlResourceArrayList));
            if (linkisAppjointJob.getRuntimeParams() != null) {
                linkisAppjointJob.getRuntimeParams().put("resources", bmlResourceArrayList);
            }
        }
        if (executionParams.get("params") != null && executionParams.get("params") instanceof Map && linkisAppjointJob.getParams() != null) {
            linkisAppjointJob.getParams().putAll((Map)executionParams.get("params"));
        }
    }

    private Map<String, Object> getExecutionParams(BMLResource bmlResource, CommonLinkisJob linkisAppjointJob) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        WorkspaceClient client = WorkspaceClientFactory.getClient((String)linkisAppjointJob.getSubmitUser(), (String)((String)LinkisJobExecutionConfiguration.LINKIS_AUTHOR_USER_TOKEN.getValue(linkisAppjointJob.getJobProps())), (String)((String)LinkisJobExecutionConfiguration.LINKIS_URL.getValue(linkisAppjointJob.getJobProps())));
        ScriptFromBMLResponse response = client.requestOpenScriptFromBML(bmlResource.getResourceId(), bmlResource.getVersion(), bmlResource.getFileName());
        map.put("executionCode", response.scriptContent());
        map.put("params", response.metadata());
        return map;
    }

    private ArrayList<String> getResourceNames(String code) {
        ArrayList<String> bmlResourceNames = new ArrayList<String>();
        Matcher mb = pb.matcher(code);
        while (mb.find()) {
            bmlResourceNames.add(mb.group().trim());
        }
        return bmlResourceNames;
    }

    private ArrayList<BMLResource> getResourcesByNames(ArrayList<String> resourceNames, CommonLinkisJob linkisAppjointJob) {
        ArrayList<BMLResource> bmlResourceArrayList = new ArrayList<BMLResource>();
        String jobName = linkisAppjointJob.getJobName();
        String flowName = linkisAppjointJob.getSource().get("flowName");
        String projectName = linkisAppjointJob.getSource().get("projectName");
        List<BMLResource> projectResourceList = linkisAppjointJob.getProjectResourceList();
        List<BMLResource> jobResourceList = linkisAppjointJob.getJobResourceList();
        for (String resourceName : resourceNames) {
            String[] resourceNameSplit = resourceName.split("://");
            String prefix = resourceNameSplit[0].toLowerCase();
            String fileName = resourceNameSplit[1];
            BMLResource resource = null;
            String afterFileName = fileName;
            switch (prefix) {
                case "project": {
                    resource = this.findResource(projectResourceList, fileName);
                    afterFileName = "project_" + projectName + "_" + fileName;
                    break;
                }
                case "flow": {
                    resource = this.findFlowResource(linkisAppjointJob, fileName, flowName);
                    break;
                }
                case "node": {
                    resource = this.findResource(jobResourceList, fileName);
                    afterFileName = "job_" + jobName + "_" + fileName;
                    break;
                }
            }
            if (null == resource) {
                linkisAppjointJob.getLogObj().error("Failed to find the " + prefix + " resource file of " + fileName);
                throw new RuntimeException("Failed to find the " + prefix + " resource file of " + fileName);
            }
            if (!afterFileName.equals(fileName)) {
                resource.setFileName(afterFileName);
            }
            bmlResourceArrayList.add(resource);
        }
        return bmlResourceArrayList;
    }

    private BMLResource findFlowResource(CommonLinkisJob linkisAppjointJob, String fileName, String flowName) {
        String firstFlow;
        String fullFlowName = "";
        Map<String, List<BMLResource>> fLowNameAndResources = linkisAppjointJob.getFlowNameAndResources();
        if (fLowNameAndResources == null) {
            return null;
        }
        Optional<Map.Entry> first = fLowNameAndResources.entrySet().stream().filter(fLowNameAndResource -> ((String)fLowNameAndResource.getKey()).endsWith(flowName + ".resources")).findFirst();
        if (first.isPresent()) {
            fullFlowName = (String)first.get().getKey();
            BMLResource resource = this.findResource((List)first.get().getValue(), fileName);
            if (resource != null) {
                resource.setFileName(flowName + "_" + fileName);
                return resource;
            }
        }
        if ((firstFlow = "flow." + flowName + ".resources").equals(fullFlowName)) {
            return null;
        }
        String parentFlowName = StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)fullFlowName, (String)("." + flowName + ".resources")), (String)".");
        if (StringUtils.isEmpty((String)parentFlowName)) {
            return null;
        }
        return this.findFlowResource(linkisAppjointJob, fileName, parentFlowName);
    }

    private String replaceCodeResourceNames(String code, ArrayList<String> resourceNameList, ArrayList<BMLResource> resourceList) {
        if (resourceList.size() != resourceNameList.size()) {
            throw new RuntimeException("Failed to parsed resource file");
        }
        String[] names = resourceNameList.toArray(new String[0]);
        String[] afterNames = new String[resourceList.size()];
        for (int i = 0; i < afterNames.length; ++i) {
            afterNames[i] = resourceList.get(i).getFileName();
        }
        return StringUtils.replaceEach((String)code, (String[])names, (String[])afterNames);
    }

    private BMLResource findResource(List<BMLResource> resourceArrayList, String fileName) {
        if (resourceArrayList != null && !resourceArrayList.isEmpty()) {
            for (BMLResource resource : resourceArrayList) {
                if (!resource.getFileName().equals(fileName)) continue;
                return resource;
            }
        }
        return null;
    }
}

