/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.linkis.node.execution.job;

import com.webank.wedatasphere.dss.linkis.node.execution.WorkflowContext;
import com.webank.wedatasphere.dss.linkis.node.execution.exception.LinkisJobExecutionErrorException;
import com.webank.wedatasphere.dss.linkis.node.execution.job.AbstractCommonLinkisJob;
import com.webank.wedatasphere.dss.linkis.node.execution.job.CommonLinkisJob;
import com.webank.wedatasphere.dss.linkis.node.execution.job.Job;
import com.webank.wedatasphere.dss.linkis.node.execution.job.JobTypeEnum;
import com.webank.wedatasphere.dss.linkis.node.execution.job.LinkisJob;
import com.webank.wedatasphere.dss.linkis.node.execution.job.ReadJob;
import com.webank.wedatasphere.dss.linkis.node.execution.job.SharedJob;
import com.webank.wedatasphere.dss.linkis.node.execution.job.SignalSharedJob;
import com.webank.wedatasphere.dss.linkis.node.execution.utils.LinkisJobExecutionUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class Builder {
    protected abstract String getJobType();

    protected abstract Boolean isReadNode();

    protected abstract Boolean isShareNod();

    protected abstract Boolean isSignalSharedNode();

    protected abstract ReadJob createReadJob(boolean var1);

    protected abstract SharedJob createSharedJob(boolean var1);

    protected abstract SignalSharedJob createSignalSharedJob(boolean var1);

    protected abstract LinkisJob creatLinkisJob(boolean var1);

    protected abstract void fillJobInfo(Job var1);

    protected abstract void fillLinkisJobInfo(LinkisJob var1);

    protected abstract void fillCommonLinkisJobInfo(CommonLinkisJob var1);

    public Job build() throws Exception {
        LinkisJob job = null;
        String jobType = this.getJobType();
        String[] jobTypeSplit = jobType.split("\\.");
        if (jobTypeSplit.length < 3) {
            throw new LinkisJobExecutionErrorException(90100, "This is not Linkis job type,this jobtype is " + jobType);
        }
        String engineType = jobTypeSplit[1];
        String runType = StringUtils.substringAfterLast((String)jobType, (String)(jobTypeSplit[0] + "." + jobTypeSplit[1] + "."));
        if ("linkis.control.empty".equalsIgnoreCase(jobType)) {
            job = new AbstractCommonLinkisJob(){

                @Override
                public String getSubmitUser() {
                    return null;
                }

                @Override
                public String getUser() {
                    return null;
                }

                @Override
                public String getJobName() {
                    return null;
                }
            };
            job.setJobType(JobTypeEnum.EmptyJob);
            return job;
        }
        if (LinkisJobExecutionUtils.isCommonAppjointJob(engineType).booleanValue()) {
            if (this.isReadNode().booleanValue()) {
                ReadJob readJob = this.createReadJob(false);
                readJob.setSharedNodesInfo(this.getSharedNodesAndJobId(readJob));
                job = (LinkisJob)((Object)readJob);
                job.setJobType(JobTypeEnum.ReadJob);
            } else if (this.isShareNod().booleanValue()) {
                SharedJob sharedJob = this.createSharedJob(false);
                job = (LinkisJob)((Object)sharedJob);
                job.setJobType(JobTypeEnum.ShareJob);
            } else if (this.isSignalSharedNode().booleanValue()) {
                job = (LinkisJob)((Object)this.createSignalSharedJob(false));
                job.setJobType(JobTypeEnum.ShareJob);
            } else {
                job = this.creatLinkisJob(false);
                job.setJobType(JobTypeEnum.CommonJob);
            }
        } else {
            if (this.isReadNode().booleanValue()) {
                ReadJob readJob = this.createReadJob(true);
                readJob.setSharedNodesInfo(this.getSharedNodesAndJobId(readJob));
                job = (LinkisJob)((Object)readJob);
                job.setJobType(JobTypeEnum.ReadJob);
            } else if (this.isShareNod().booleanValue()) {
                SharedJob sharedJob = this.createSharedJob(true);
                job = (LinkisJob)((Object)sharedJob);
                job.setJobType(JobTypeEnum.ShareJob);
            } else if (this.isSignalSharedNode().booleanValue()) {
                job = (LinkisJob)((Object)this.createSignalSharedJob(true));
                job.setJobType(JobTypeEnum.ShareJob);
            } else {
                job = this.creatLinkisJob(true);
                job.setJobType(JobTypeEnum.CommonJob);
            }
            this.fillCommonLinkisJobInfo((CommonLinkisJob)job);
        }
        job.setEngineType(engineType);
        job.setRunType(runType);
        this.fillJobInfo(job);
        this.fillLinkisJobInfo(job);
        return job;
    }

    private Map<String, Object> getSharedNodesAndJobId(ReadJob job) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] sharedIds = job.getShareNodeIds();
        if (sharedIds == null) {
            return map;
        }
        for (String nodeId : sharedIds) {
            map.put(nodeId, WorkflowContext.getAppJointContext().getValue(job.getSharedKey(nodeId)));
        }
        return map;
    }
}

