/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.linkis.node.execution.execution.impl;

import com.webank.wedatasphere.dss.linkis.node.execution.WorkflowContext;
import com.webank.wedatasphere.dss.linkis.node.execution.conf.LinkisJobExecutionConfiguration;
import com.webank.wedatasphere.dss.linkis.node.execution.exception.LinkisJobExecutionErrorException;
import com.webank.wedatasphere.dss.linkis.node.execution.execution.LinkisNodeExecution;
import com.webank.wedatasphere.dss.linkis.node.execution.job.Job;
import com.webank.wedatasphere.dss.linkis.node.execution.job.SharedJob;
import com.webank.wedatasphere.dss.linkis.node.execution.job.SignalSharedJob;
import com.webank.wedatasphere.dss.linkis.node.execution.listener.LinkisExecutionListener;
import com.webank.wedatasphere.dss.linkis.node.execution.parser.CodeParser;
import com.webank.wedatasphere.dss.linkis.node.execution.parser.JobParser;
import com.webank.wedatasphere.dss.linkis.node.execution.parser.JobRuntimeParamsParser;
import com.webank.wedatasphere.dss.linkis.node.execution.service.impl.BuildJobActionImpl;
import com.webank.wedatasphere.dss.linkis.node.execution.utils.LinkisUjesClientUtils;
import com.webank.wedatasphere.linkis.common.utils.Utils;
import com.webank.wedatasphere.linkis.ujes.client.UJESClient;
import com.webank.wedatasphere.linkis.ujes.client.request.JobExecuteAction;
import com.webank.wedatasphere.linkis.ujes.client.request.ResultSetAction;
import com.webank.wedatasphere.linkis.ujes.client.response.JobInfoResult;
import com.webank.wedatasphere.linkis.ujes.client.response.JobLogResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LinkisNodeExecutionImpl
implements LinkisNodeExecution,
LinkisExecutionListener {
    private static LinkisNodeExecution linkisExecution = new LinkisNodeExecutionImpl();
    private UJESClient client;
    private ArrayList<JobParser> jobParsers = new ArrayList();

    private LinkisNodeExecutionImpl() {
        this.registerJobParser(new CodeParser());
        this.registerJobParser(new JobRuntimeParamsParser());
    }

    public static LinkisNodeExecution getLinkisNodeExecution() {
        return linkisExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UJESClient getClient(Map<String, String> props) {
        if (this.client != null) return this.client;
        Class<LinkisNodeExecution> clazz = LinkisNodeExecution.class;
        synchronized (LinkisNodeExecution.class) {
            if (this.client != null) return this.client;
            this.client = LinkisUjesClientUtils.getUJESClient((String)LinkisJobExecutionConfiguration.LINKIS_URL.getValue(props), (String)LinkisJobExecutionConfiguration.LINKIS_ADMIN_USER.getValue(props), (String)LinkisJobExecutionConfiguration.LINKIS_AUTHOR_USER_TOKEN.getValue(props), props);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.client;
        }
    }

    public void registerJobParser(JobParser jobParser) {
        this.jobParsers.add(jobParser);
    }

    @Override
    public void runJob(Job job) throws Exception {
        for (JobParser parser : this.jobParsers) {
            parser.parseJob(job);
        }
        JobExecuteAction jobAction = BuildJobActionImpl.getbuildJobAction().getJobAction(job);
        job.setJobExecuteResult(this.getClient(job.getJobProps()).execute(jobAction));
        job.getLogObj().info("<---------------Start to execute job--------------->");
    }

    @Override
    public String getState(Job job) {
        return this.getClient(job.getJobProps()).getJobInfo(job.getJobExecuteResult()).getJobStatus();
    }

    @Override
    public String getLog(Job job) {
        JobLogResult jobLogResult = this.getClient(job.getJobProps()).log(job.getJobExecuteResult(), job.getLogFromLine(), ((Integer)LinkisJobExecutionConfiguration.LOG_SIZE.getValue()).intValue());
        job.setLogFromLine(jobLogResult.fromLine());
        ArrayList logArray = jobLogResult.getLog();
        if (logArray != null && logArray.size() >= (Integer)LinkisJobExecutionConfiguration.LOG_ARRAY_LEN.getValue() && StringUtils.isNotEmpty((String)((String)logArray.get(3)))) {
            return (String)logArray.get(3);
        }
        return null;
    }

    @Override
    public void waitForComplete(Job job) throws Exception {
        JobInfoResult jobInfo = this.getClient(job.getJobProps()).getJobInfo(job.getJobExecuteResult());
        while (!jobInfo.isCompleted()) {
            job.getLogObj().info("Update Progress info:" + this.getProgress(job));
            job.getLogObj().info("<----linkis log ---->");
            String log = this.getLog(job);
            if (log != null) {
                job.getLogObj().info(log);
            }
            job.getLogObj().info("<----linkis log ---->");
            Utils.sleepQuietly((long)((Integer)LinkisJobExecutionConfiguration.LINKIS_JOB_REQUEST_STATUS_TIME.getValue(job.getJobProps())).intValue());
            jobInfo = this.getClient(job.getJobProps()).getJobInfo(job.getJobExecuteResult());
        }
        if (!jobInfo.isSucceed()) {
            throw new LinkisJobExecutionErrorException(90101, "Failed to execute Job: " + jobInfo.getMessage());
        }
    }

    @Override
    public void cancel(Job job) throws Exception {
        this.getClient(job.getJobProps()).kill(job.getJobExecuteResult());
    }

    @Override
    public double getProgress(Job job) {
        return this.getClient(job.getJobProps()).progress(job.getJobExecuteResult()).getProgress();
    }

    @Override
    public Boolean isCompleted(Job job) {
        return this.getClient(job.getJobProps()).getJobInfo(job.getJobExecuteResult()).isCompleted();
    }

    @Override
    public int getResultSize(Job job) {
        String[] resultSetList;
        JobInfoResult jobInfo = this.getClient(job.getJobProps()).getJobInfo(job.getJobExecuteResult());
        if (jobInfo.isSucceed() && (resultSetList = jobInfo.getResultSetList(this.getClient(job.getJobProps()))) != null && resultSetList.length > 0) {
            return resultSetList.length;
        }
        return 0;
    }

    @Override
    public String getResult(Job job, int index, int maxSize) {
        String resultContent = null;
        JobInfoResult jobInfo = this.getClient(job.getJobProps()).getJobInfo(job.getJobExecuteResult());
        String[] resultSetList = jobInfo.getResultSetList(this.getClient(job.getJobProps()));
        if (resultSetList != null && resultSetList.length > 0) {
            Object fileContent = this.client.resultSet(ResultSetAction.builder().setPath(resultSetList[index]).setUser(job.getJobExecuteResult().getUser()).setPageSize(maxSize).build()).getFileContent();
            if (fileContent instanceof ArrayList) {
                ArrayList resultSetRow = (ArrayList)fileContent;
                resultContent = StringUtils.join((Collection)resultSetRow, (String)"\n");
            } else {
                resultContent = fileContent.toString();
            }
        }
        return resultContent;
    }

    @Override
    public void onStatusChanged(String fromState, String toState, Job job) {
        if ("Succeed".equalsIgnoreCase(toState)) {
            if (job instanceof SignalSharedJob) {
                SignalSharedJob signalSharedJob = (SignalSharedJob)((Object)job);
                String result = this.getResult(job, 0, -1);
                WorkflowContext.getAppJointContext().setValue(signalSharedJob.getSharedKey(), result, -1);
            } else if (job instanceof SharedJob) {
                String taskId = job.getJobExecuteResult().getTaskID();
                job.getLogObj().info("Set shared info:" + taskId);
                SharedJob sharedJob = (SharedJob)((Object)job);
                WorkflowContext.getAppJointContext().setValue(sharedJob.getSharedKey(), taskId, sharedJob.getSharedNum());
            }
        }
    }
}

