/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.linkis.node.execution;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.webank.wedatasphere.dss.linkis.node.execution.WorkflowContext;
import com.webank.wedatasphere.dss.linkis.node.execution.conf.LinkisJobExecutionConfiguration;
import com.webank.wedatasphere.dss.linkis.node.execution.entity.ContextInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class WorkflowContextImpl
implements WorkflowContext {
    private Cache<String, ContextInfo> contextCache = CacheBuilder.newBuilder().maximumSize((long)((Integer)LinkisJobExecutionConfiguration.LINKIS_CACHE_MAX_SIZE.getValue()).intValue()).expireAfterWrite((long)((Integer)LinkisJobExecutionConfiguration.LINKIS_CACHE_EXPIRE_TIME.getValue()).intValue(), TimeUnit.HOURS).build();

    @Override
    public Object getValue(String key) {
        ContextInfo contextInfo = (ContextInfo)this.contextCache.getIfPresent((Object)key);
        if (contextInfo != null && contextInfo.getReadNum() > 0) {
            int readNum = contextInfo.getReadNum() - 1;
            Object value = contextInfo.getValue();
            if (readNum <= 0) {
                this.contextCache.invalidate((Object)key);
            }
            contextInfo.setReadNum(contextInfo.getReadNum() - 1);
            return value;
        }
        if (contextInfo != null && contextInfo.getReadNum() < 0) {
            return contextInfo.getValue();
        }
        return null;
    }

    @Override
    public List<Object> getValues(String prefix) {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator<String> keys = this.keyIterator();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!key.startsWith(prefix)) continue;
            values.add(this.getValue(key));
        }
        return values;
    }

    @Override
    public Iterator<String> keyIterator() {
        return this.contextCache.asMap().keySet().iterator();
    }

    @Override
    public Map<String, Object> getSubMapByPrefix(String keyPrefix) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<String> keys = this.keyIterator();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!key.startsWith(keyPrefix)) continue;
            map.put(StringUtils.substringAfter((String)key, (String)keyPrefix), this.getValue(key));
        }
        return map;
    }

    @Override
    public void setValue(String key, Object value, int readNum) {
        this.contextCache.put((Object)key, (Object)new ContextInfo(value, readNum));
    }
}

