/*
 * Decompiled with CFR 0.152.
 */
package com.ustcinfo.bwp.client.support;

import com.ustcinfo.bwp.client.support.ClientServiceLoader;
import com.ustcinfo.bwp.data.service.FlowDataService;
import com.ustcinfo.bwp.data.service.FlowHisDataService;
import com.ustcinfo.bwp.exception.BwpClientException;
import com.ustcinfo.bwp.service.ActivityService;
import com.ustcinfo.bwp.service.ConsignationService;
import com.ustcinfo.bwp.service.FlowService;
import com.ustcinfo.bwp.service.GlobalTransactionService;
import com.ustcinfo.bwp.service.RollBackService;
import com.ustcinfo.bwp.service.RollbackExtendedService;
import com.ustcinfo.bwp.service.WorkItemService;
import com.ustcinfo.bwp.spi.BwpManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ServiceFactory {
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int MAX_TOTAL = 256;
    private static final int DEFAULT_MAX_PER_ROUTE = 50;
    private static int _socketTimeout = 30000;
    private static ReentrantLock lock = new ReentrantLock();
    private static Map<String, Object> serviceMap = new HashMap<String, Object>();
    private static Map<Integer, CloseableHttpClient> httpClientMap = new HashMap<Integer, CloseableHttpClient>();

    public static <T> T getService(Class<?> clazz, Integer ... soTimeout) {
        String serviceKey = clazz.getSimpleName();
        if (soTimeout.length > 0 && soTimeout[0] > 0) {
            _socketTimeout = soTimeout[0] * 1000;
            serviceKey = new StringBuffer(clazz.getSimpleName()).append(_socketTimeout).toString();
        }
        if (serviceMap.get(serviceKey) == null) {
            try {
                CloseableHttpClient httpClient = ServiceFactory.getHttpClient(_socketTimeout);
                lock.lock();
                if (serviceMap.get(serviceKey) == null) {
                    Object object;
                    List<Object> serviceList = new LinkedList();
                    try {
                        serviceList = ClientServiceLoader.load(clazz, httpClient);
                        Object service = serviceList.get(0);
                        serviceMap.put(serviceKey, service);
                        object = service;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BwpClientException("0200", "08", String.format("\u52a0\u8f7d %s\u7684Service Client \u5f02\u5e38!", clazz.getName()), e);
                    }
                    return (T)object;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return (T)serviceMap.get(serviceKey);
    }

    private static CloseableHttpClient getHttpClient(Integer soTimeout) {
        if (httpClientMap.get(soTimeout) == null) {
            try {
                lock.lock();
                if (httpClientMap.get(soTimeout) == null) {
                    RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(soTimeout.intValue()).setConnectTimeout(3000).setStaleConnectionCheckEnabled(true).build();
                    PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                    cm.setMaxTotal(256);
                    cm.setDefaultMaxPerRoute(50);
                    CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).setConnectionManager((HttpClientConnectionManager)cm).build();
                    httpClientMap.put(soTimeout, httpClient);
                    CloseableHttpClient closeableHttpClient = httpClient;
                    return closeableHttpClient;
                }
            }
            finally {
                lock.unlock();
            }
        }
        return httpClientMap.get(soTimeout);
    }

    public static ActivityService getActivityService(Integer ... socketTimeout) {
        return (ActivityService)ServiceFactory.getService(ActivityService.class, socketTimeout);
    }

    public static FlowService getFlowService(Integer ... socketTimeout) {
        return (FlowService)ServiceFactory.getService(FlowService.class, socketTimeout);
    }

    public static BwpManager getBwpManagerService(Integer ... socketTimeout) {
        return (BwpManager)ServiceFactory.getService(BwpManager.class, socketTimeout);
    }

    public static ConsignationService getConsignationService(Integer ... socketTimeout) {
        return (ConsignationService)ServiceFactory.getService(ConsignationService.class, socketTimeout);
    }

    public static RollBackService getRollBackService(Integer ... socketTimeout) {
        return (RollBackService)ServiceFactory.getService(RollBackService.class, socketTimeout);
    }

    public static RollbackExtendedService getRollbackExtService(Integer ... socketTimeout) {
        return (RollbackExtendedService)ServiceFactory.getService(RollbackExtendedService.class, socketTimeout);
    }

    public static FlowDataService getFlowDataService(Integer ... socketTimeout) {
        return (FlowDataService)ServiceFactory.getService(FlowDataService.class, socketTimeout);
    }

    public static FlowHisDataService getFlowHisDataService(Integer ... socketTimeout) {
        return (FlowHisDataService)ServiceFactory.getService(FlowHisDataService.class, socketTimeout);
    }

    public static WorkItemService getWorkItemService(Integer ... socketTimeout) {
        return (WorkItemService)ServiceFactory.getService(WorkItemService.class, socketTimeout);
    }

    public static GlobalTransactionService getGlobalTxnService(Integer ... socketTimeout) {
        return (GlobalTransactionService)ServiceFactory.getService(GlobalTransactionService.class, socketTimeout);
    }
}

