/*
 * Decompiled with CFR 0.152.
 */
package com.ustcinfo.bwp.client.support;

import com.ustcinfo.bwp.service.startflow.util.IOUtils;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;

public class ClientServiceLoader {
    public static final String MAPPING_CONFIG_PREFIX = "META-INF/services";

    public static <T> List<T> load(Class<T> service, CloseableHttpClient httpClient) throws Exception {
        String mappingConfigFile = "META-INF/services/" + service.getName();
        Enumeration<URL> configFileUrls = ClientServiceLoader.class.getClassLoader().getResources(mappingConfigFile);
        if (configFileUrls == null) {
            return null;
        }
        LinkedList services = new LinkedList();
        while (configFileUrls.hasMoreElements()) {
            String[] serviceNames;
            URL configFileUrl = configFileUrls.nextElement();
            String configContent = IOUtils.toString((InputStream)configFileUrl.openStream());
            String[] stringArray = serviceNames = configContent.split("\n");
            int n = serviceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String serviceName = stringArray[n2];
                Class<?> serviceClass = ClientServiceLoader.class.getClassLoader().loadClass(serviceName);
                Constructor<?> constructor = serviceClass.getDeclaredConstructor(CloseableHttpClient.class);
                constructor.setAccessible(true);
                Object serviceInstance = constructor.newInstance(httpClient);
                services.add(serviceInstance);
                ++n2;
            }
        }
        return services;
    }
}

