/*
 * Decompiled with CFR 0.152.
 */
package com.ustcinfo.bwp.client.impl;

import com.ustcinfo.bwp.BwpEngineException;
import com.ustcinfo.bwp.client.util.RequestExecutor;
import com.ustcinfo.bwp.exception.BwpClientException;
import com.ustcinfo.bwp.service.GlobalTransactionService;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.impl.client.CloseableHttpClient;

public class TxRestClient
implements GlobalTransactionService {
    private CloseableHttpClient httpClient;
    private static ThreadLocal<String> txId = new ThreadLocal();
    private static ThreadLocal<AtomicInteger> invokeIndex = new ThreadLocal();

    private TxRestClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public boolean begin() throws BwpEngineException {
        this.clearTxInfo();
        txId.set(UUID.randomUUID().toString());
        invokeIndex.set(new AtomicInteger(0));
        RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), new Object[0]);
        return true;
    }

    public boolean commit() throws BwpEngineException {
        if (TxRestClient.getTransactionId() == null) {
            throw new BwpClientException("0200", "06", "\u5f53\u524d\u7ebf\u7a0b\u672a\u5173\u8054\u5230\u6b63\u5728\u8fd0\u884c\u7684\u4e8b\u52a1\uff01");
        }
        RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), new Object[0]);
        this.clearTxInfo();
        return true;
    }

    public boolean rollback() throws BwpEngineException {
        if (TxRestClient.getTransactionId() == null) {
            throw new BwpClientException("0200", "07", "\u5f53\u524d\u7ebf\u7a0b\u672a\u5173\u8054\u5230\u6b63\u5728\u8fd0\u884c\u7684\u4e8b\u52a1\uff01");
        }
        try {
            RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), TxRestClient.getTransactionId(), TxRestClient.getInvokeIndex(), new Object[0]);
            return true;
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.clearTxInfo();
        }
    }

    public static String getTransactionId() {
        return txId.get();
    }

    protected static String getInvokeIndex() {
        if (invokeIndex.get() == null) {
            return "-1";
        }
        return String.valueOf(invokeIndex.get().getAndIncrement());
    }

    private void clearTxInfo() {
        txId.remove();
        invokeIndex.remove();
    }
}

