/*
 * Decompiled with CFR 0.152.
 */
package com.ustcinfo.bwp.client.impl;

import com.ustcinfo.bwp.BwpEngineException;
import com.ustcinfo.bwp.client.util.RequestExecutor;
import com.ustcinfo.bwp.data.service.FlowDataService;
import com.ustcinfo.bwp.modle.ActivityInst;
import com.ustcinfo.bwp.modle.ActivityRepo;
import com.ustcinfo.bwp.modle.CurrentActInfo;
import com.ustcinfo.bwp.modle.ProcessDefine;
import com.ustcinfo.bwp.modle.ProcessInstance;
import com.ustcinfo.bwp.modle.WorkItem;
import com.ustcinfo.bwp.modle.elements.OperationElement;
import com.ustcinfo.bwp.service.startflow.util.SerializeUtils;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;

public class FlowDataRestClient
implements FlowDataService {
    private CloseableHttpClient httpClient;

    private FlowDataRestClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Long getPrimaryKey(String name) {
        try {
            return Long.valueOf(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, name));
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<CurrentActInfo> getCurrentActInfo(Long processInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId);
            return SerializeUtils.getBeanList((String)json, CurrentActInfo[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<CurrentActInfo> getCurActInfoByMainProcInstId(Long processInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId);
            return SerializeUtils.getBeanList((String)json, CurrentActInfo[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean ifCurrentProcessActive(Long processInstId) {
        try {
            return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId));
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<CurrentActInfo> getCurActInfoIncludeSubProcess(Long processInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId);
            return SerializeUtils.getBeanList((String)json, CurrentActInfo[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<WorkItem> getActiveWorkItem(Long processInstId, Long activityInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityInstId);
            return SerializeUtils.getBeanList((String)json, WorkItem[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<CurrentActInfo> getSubProcessInfoByActDefId(Long processInstId, String activityDefId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityDefId);
            return SerializeUtils.getBeanList((String)json, CurrentActInfo[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<WorkItem> getWorkItemByProcessInstId(Long processInstId, Long activityInstId, String particType, String particId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityInstId, particType, particId);
            return SerializeUtils.getBeanList((String)json, WorkItem[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ActivityRepo> getActivityRepo(String sysCode, String busiTypeCode, String areaCode) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, sysCode, busiTypeCode, areaCode);
            return SerializeUtils.getBeanList((String)json, ActivityRepo[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<OperationElement> getActivityOper(Long processInstId, String activityDefId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityDefId);
            return SerializeUtils.getBeanList((String)json, OperationElement[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProcessInstance getProcInstanceByProcInstId(Long processInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId);
            return (ProcessInstance)SerializeUtils.unserialize((String)json, ProcessInstance.class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPageTemplate(Long processInstId, String activityDefId) {
        try {
            return (String)SerializeUtils.unserialize((String)RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId, activityDefId), String.class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ActivityRepo> getActivityRepoByActivityName(String sysCode, String busiTypeCode, String areaCode, String activityName) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, sysCode, busiTypeCode, areaCode, activityName);
            return SerializeUtils.getBeanList((String)json, ActivityRepo[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ActivityInst> getActInstsByProcessInstId(Long processInstId) {
        try {
            String json = RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processInstId);
            return SerializeUtils.getBeanList((String)json, ActivityInst[].class);
        }
        catch (BwpEngineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean synchronizeProcessDefine(ProcessDefine processDefine, String operateType) throws BwpEngineException {
        return Boolean.parseBoolean(RequestExecutor.execute(this.httpClient, Thread.currentThread().getStackTrace()[1].getMethodName(), null, null, processDefine, operateType));
    }
}

